/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.texteditors;

import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.ITextEditorExtension;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;
import org.eclipse.ui.texteditor.StatusLineContributionItem;
import org.eclipse.ui.texteditor.TextEditorAction;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.jboss.tools.common.model.ui.texteditors.TextActionHelper;
import org.jboss.tools.common.text.xml.ui.TextEditorMessages;

public abstract class AbstractMultiPageContributor
extends MultiPageEditorActionBarContributor {
    protected static final String[] ACTIONS = new String[]{ITextEditorActionConstants.UNDO, ITextEditorActionConstants.REDO, ITextEditorActionConstants.CUT, ITextEditorActionConstants.COPY, ITextEditorActionConstants.PASTE, ITextEditorActionConstants.DELETE, ITextEditorActionConstants.SELECT_ALL, ITextEditorActionConstants.FIND, IDEActionFactory.BOOKMARK.getId(), IDEActionFactory.ADD_TASK.getId(), ITextEditorActionConstants.PRINT, ITextEditorActionConstants.REVERT, ITextEditorActionConstants.SAVE};
    protected static final String[] STATUSFIELDS = new String[]{"ElementState", "InputMode", "InputPosition"};
    protected IEditorPart mainPart;
    protected IEditorPart fActiveEditorPart;
    protected RetargetTextEditorAction fFindNext;
    protected RetargetTextEditorAction fFindPrevious;
    protected RetargetTextEditorAction fIncrementalFind;
    protected RetargetTextEditorAction fIncrementalFindReverse;
    protected RetargetTextEditorAction fGotoLine;
    protected Map<String, StatusLineContributionItem> fStatusFields;
    protected RetargetTextEditorAction fContentAssistProposal;
    protected RetargetTextEditorAction fContentAssistTip;
    protected TextEditorAction fToggleOccurencesMarkUp;
    protected static String[] ACTIONS_1 = new String[]{ITextEditorActionConstants.CUT, ITextEditorActionConstants.COPY, ITextEditorActionConstants.PASTE, ITextEditorActionConstants.DELETE};
    protected static String[] ACTIONS_2 = new String[]{ITextEditorActionConstants.CUT, ITextEditorActionConstants.COPY, ITextEditorActionConstants.PASTE, ITextEditorActionConstants.DELETE, ITextEditorActionConstants.UNDO, ITextEditorActionConstants.REDO};
    Map<IAction, ActionHandler> used = new HashMap<IAction, ActionHandler>();
    Map<String, Deactivator> registered = new HashMap<String, Deactivator>();

    public AbstractMultiPageContributor() {
        this.createAssistObjects();
        this.createStatusFields();
    }

    protected void createAssistObjects() {
        ResourceBundle resourceBundle = XMLUIMessages.getResourceBundle();
        this.fContentAssistProposal = new RetargetTextEditorAction(resourceBundle, "");
        this.fContentAssistProposal.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.fContentAssistTip = new RetargetTextEditorAction(TextEditorMessages.getResourceBundle(), "ContentAssistTip.");
        this.fContentAssistTip.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
    }

    protected void createStatusFields() {
        this.fStatusFields = new HashMap<String, StatusLineContributionItem>(3);
        int i = 0;
        while (i < STATUSFIELDS.length) {
            this.fStatusFields.put(STATUSFIELDS[i], new StatusLineContributionItem(STATUSFIELDS[i]));
            ++i;
        }
    }

    public void init(IActionBars bars, IWorkbenchPage page) {
        super.init(bars, page);
        IToolBarManager toolBarManager = bars.getToolBarManager();
        if (toolBarManager != null && this.fToggleOccurencesMarkUp != null) {
            toolBarManager.add((IContributionItem)new Separator());
            toolBarManager.add((IAction)this.fToggleOccurencesMarkUp);
        }
    }

    protected void initEditMenu(IActionBars bars) {
        IMenuManager menuManager = bars.getMenuManager();
        IMenuManager editMenu = menuManager.findMenuUsingPath("edit");
        if (editMenu != null) {
            editMenu.add((IContributionItem)new Separator());
            editMenu.add((IAction)this.fContentAssistProposal);
            editMenu.add((IAction)this.fContentAssistTip);
        }
    }

    public void setActiveEditor(IEditorPart part) {
        IStatusLineManager slm;
        super.setActiveEditor(part);
        this.mainPart = part;
        IActionBars actionBars = this.getActionBars();
        if (actionBars != null && (slm = actionBars.getStatusLineManager()) != null) {
            slm.setErrorMessage(null);
            slm.setMessage(null);
        }
    }

    protected ITextEditor getTextEditor(IEditorPart editor) {
        ITextEditor textEditor = null;
        if (editor instanceof ITextEditor) {
            textEditor = (ITextEditor)editor;
        }
        if (textEditor == null && editor != null) {
            textEditor = (ITextEditor)editor.getAdapter(ITextEditor.class);
        }
        return textEditor;
    }

    protected void cleanStatusLine() {
        if (this.fActiveEditorPart instanceof ITextEditorExtension) {
            ITextEditorExtension extension = (ITextEditorExtension)this.fActiveEditorPart;
            int i = 0;
            while (i < STATUSFIELDS.length) {
                extension.setStatusField(null, STATUSFIELDS[i]);
                ++i;
            }
        }
    }

    protected final void cleanActionBarStatus() {
        IStatusLineManager slm = this.getActionBars().getStatusLineManager();
        if (slm != null) {
            slm.setErrorMessage(null);
            slm.setMessage(null);
        }
    }

    protected void updateStatus() {
        if (this.fActiveEditorPart instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)this.fActiveEditorPart;
            this.fContentAssistProposal.setAction(this.getAction(textEditor, "ContentAssistProposal"));
            this.fContentAssistTip.setAction(this.getAction(textEditor, "ContentAssistTip"));
        }
        if (this.fActiveEditorPart instanceof ITextEditorExtension) {
            ITextEditorExtension extension = (ITextEditorExtension)this.fActiveEditorPart;
            int i = 0;
            while (i < STATUSFIELDS.length) {
                extension.setStatusField((IStatusField)this.fStatusFields.get(STATUSFIELDS[i]), STATUSFIELDS[i]);
                ++i;
            }
        }
    }

    public void contributeToStatusLine(IStatusLineManager statusLineManager) {
        super.contributeToStatusLine(statusLineManager);
        int i = 0;
        while (i < STATUSFIELDS.length) {
            statusLineManager.add((IContributionItem)this.fStatusFields.get(STATUSFIELDS[i]));
            ++i;
        }
    }

    protected final IAction getAction(ITextEditor editor, String actionId) {
        return editor == null ? null : editor.getAction(actionId);
    }

    public void registerKeyBindings(IHandlerService handler, String[] actions, ITextEditor editor) {
        int i = 0;
        while (i < actions.length) {
            IAction action = editor.getAction(actions[i]);
            this.registerKeyBinding(handler, actions[i], action);
            ++i;
        }
    }

    protected void registerKeyBinding(IHandlerService handler, String command, IAction action) {
        IHandlerActivation a;
        if (action == null) {
            return;
        }
        if (handler == null) {
            return;
        }
        ActionHandler h = this.used.get(action);
        if (h == null) {
            h = new ActionHandler(action);
            this.used.put(action, h);
        }
        action.getId();
        Deactivator c = this.registered.remove(command);
        if (c != null) {
            c.deactivate();
        }
        if ((a = handler.activateHandler(command, (IHandler)h)) != null) {
            this.registered.put(command, new Deactivator(handler, a));
        }
    }

    public void dispose() {
        if (this.fToggleOccurencesMarkUp != null) {
            this.fToggleOccurencesMarkUp.setEditor(null);
            this.fToggleOccurencesMarkUp = null;
        }
        super.dispose();
    }

    protected class AFakeTextEditor
    implements ITextEditor,
    ITextOperationTarget {
        protected HashMap<String, IAction> actions = new HashMap();

        public AFakeTextEditor() {
            this.createFakeActions();
        }

        protected void createFakeActions() {
            TextActionHelper.addCutAction(this);
            TextActionHelper.addCopyAction(this);
            TextActionHelper.addPasteAction(this);
            TextActionHelper.addDeleteAction(this);
        }

        public IDocumentProvider getDocumentProvider() {
            return null;
        }

        public void close(boolean save) {
        }

        public boolean isEditable() {
            return false;
        }

        public void doRevertToSaved() {
        }

        public void setAction(String actionID, IAction action) {
            this.actions.put(actionID, action);
        }

        public IAction getAction(String id) {
            return this.actions.get(id);
        }

        public void setActionActivationCode(String actionId, char activationCharacter, int activationKeyCode, int activationStateMask) {
        }

        public void removeActionActivationCode(String actionId) {
        }

        public boolean showsHighlightRangeOnly() {
            return false;
        }

        public void showHighlightRangeOnly(boolean showHighlightRangeOnly) {
        }

        public void setHighlightRange(int offset, int length, boolean moveCursor) {
        }

        public IRegion getHighlightRange() {
            return null;
        }

        public void resetHighlightRange() {
        }

        public ISelectionProvider getSelectionProvider() {
            return null;
        }

        public void selectAndReveal(int offset, int length) {
        }

        public IEditorInput getEditorInput() {
            return null;
        }

        public IEditorSite getEditorSite() {
            return (IEditorSite)(AbstractMultiPageContributor.this.fActiveEditorPart != null ? AbstractMultiPageContributor.this.fActiveEditorPart.getSite() : AbstractMultiPageContributor.this.mainPart.getSite());
        }

        public void gotoMarker(IMarker marker) {
        }

        public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        }

        public void addPropertyListener(IPropertyListener listener) {
        }

        public void createPartControl(Composite parent) {
        }

        public void dispose() {
        }

        public IWorkbenchPartSite getSite() {
            return AbstractMultiPageContributor.this.fActiveEditorPart != null ? AbstractMultiPageContributor.this.fActiveEditorPart.getSite() : AbstractMultiPageContributor.this.mainPart.getSite();
        }

        public String getTitle() {
            return null;
        }

        public Image getTitleImage() {
            return null;
        }

        public String getTitleToolTip() {
            return null;
        }

        public void removePropertyListener(IPropertyListener listener) {
        }

        public void setFocus() {
        }

        public Object getAdapter(Class adapter) {
            if (ITextOperationTarget.class.equals((Object)adapter)) {
                return this;
            }
            return null;
        }

        public void doSave(IProgressMonitor monitor) {
        }

        public void doSaveAs() {
        }

        public boolean isDirty() {
            return false;
        }

        public boolean isSaveAsAllowed() {
            return false;
        }

        public boolean isSaveOnCloseNeeded() {
            return false;
        }

        public boolean canDoOperation(int operation) {
            return false;
        }

        public void doOperation(int operation) {
        }
    }

    class Deactivator {
        IHandlerService service;
        IHandlerActivation handler;

        Deactivator(IHandlerService service, IHandlerActivation handler) {
            this.service = service;
            this.handler = handler;
        }

        void deactivate() {
            this.service.deactivateHandler(this.handler);
        }
    }
}

