/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.propertieseditor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.jboss.tools.common.meta.action.XAction;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.meta.action.impl.XEntityDataImpl;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.action.CommandBar;
import org.jboss.tools.common.model.ui.action.XMenuInvoker;
import org.jboss.tools.common.model.ui.attribute.XAttributeSupport;
import org.jboss.tools.common.model.ui.messages.UIMessages;
import org.jboss.tools.common.model.ui.objecteditor.XChildrenEditor;
import org.jboss.tools.common.model.ui.texteditors.TextActionHelper;
import org.jboss.tools.common.model.util.AbstractTableHelper;
import org.jboss.tools.common.propertieseditor.FPTableHelper;

public class PropertiesEditor
extends XChildrenEditor
implements ITextEditor,
ITextOperationTarget {
    static final String ENT_PROPERTY = "Property";
    static final String ATTR_NAME = "name";
    static final String ATTR_VALUE = "value";
    static final String ATTR_ENABLED = "enabled";
    XModelObject property = PreferenceModelUtilities.getPreferenceModel().createModelObject("Property", null);
    XAttributeSupport nsupport = new XAttributeSupport(this.property, (XEntityData)XEntityDataImpl.create((String[][])new String[][]{{"Property", "yes"}, {"name", "no"}}), true);
    XAttributeSupport vsupport = new XAttributeSupport(this.property, (XEntityData)XEntityDataImpl.create((String[][])new String[][]{{"Property", "yes"}, {"value", "no"}}));
    ExpandableComposite filterComposite;
    Button caseSensitive = null;
    Button fake = null;
    private Label statistics;
    Composite panel = null;
    private ArrayList<String> actionMapping = new ArrayList();
    private Map<String, IAction> actions = new HashMap<String, IAction>();
    private IEditorInput input;
    IEditorSite site;
    FPTableHelper pHelper;
    private QualifiedName filterOpenedId = new QualifiedName("", "filterOpened");
    private QualifiedName nameFilterId = new QualifiedName("", "nameFilter");
    private QualifiedName valueFilterId = new QualifiedName("", "valueFilter");
    private QualifiedName isFilterExpressionId = new QualifiedName("", "isFilterExpression");
    private QualifiedName isCaseSensitiveId = new QualifiedName("", "isCaseSensitiveId");
    private boolean filterOpened = false;
    private boolean isFilterExpression = false;
    private boolean isCaseSensitive = false;

    public PropertiesEditor() {
        this.xtable.setMultiSelected();
        this.setMnemonicEnabled(true);
    }

    protected AbstractTableHelper createHelper() {
        this.pHelper = new FPTableHelper(this);
        return this.pHelper;
    }

    protected int[] getColumnWidthHints() {
        return new int[]{10, 20};
    }

    protected boolean areUpDounActionsEnabled() {
        return true;
    }

    public Control createControl(Composite parent) {
        this.panel = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        this.panel.setLayout((Layout)layout);
        this.nsupport.getPropertyEditorAdapterByName(ATTR_NAME).setValue(this.pHelper.nameFilter);
        this.vsupport.getPropertyEditorAdapterByName(ATTR_VALUE).setValue(this.pHelper.valueFilter);
        ExpandableComposite g = this.filterComposite = new ExpandableComposite(this.panel, 0);
        g.setText(UIMessages.PROPERTIES_EDITOR_FILTER);
        g.setLayoutData((Object)new GridData(768));
        Composite g1 = new Composite((Composite)g, 0);
        GridLayout l1 = new GridLayout(3, false);
        l1.horizontalSpacing = 10;
        l1.marginRight = 0;
        l1.marginHeight = 0;
        l1.verticalSpacing = 0;
        g1.setLayout((Layout)l1);
        g1.setLayoutData((Object)new GridData(768));
        g.setClient((Control)g1);
        g.setExpanded(this.filterOpened);
        g.addExpansionListener(new IExpansionListener(){

            public void expansionStateChanging(ExpansionEvent e) {
            }

            public void expansionStateChanged(ExpansionEvent e) {
                PropertiesEditor.this.filterOpened = e.getState();
                PropertiesEditor.this.panel.update();
                PropertiesEditor.this.panel.layout();
            }
        });
        Composite ng = new Composite(g1, 0);
        GridLayout nl = new GridLayout(2, false);
        nl.marginRight = 0;
        nl.marginHeight = 0;
        ng.setLayout((Layout)nl);
        ng.setLayoutData((Object)new GridData(768));
        this.nsupport.fillComposite(ng);
        this.nsupport.addPropertyChangeListener(this.pHelper);
        Composite vg = new Composite(g1, 0);
        GridLayout vl = new GridLayout(2, false);
        vl.marginHeight = 0;
        vg.setLayout((Layout)vl);
        vg.setLayoutData((Object)new GridData(768));
        this.vsupport.fillComposite(vg);
        this.vsupport.addPropertyChangeListener(this.pHelper);
        this.createCaseSensitive(g1);
        this.statistics = new Label(g1, 0);
        GridData d = new GridData(768);
        d.horizontalSpan = 2;
        this.statistics.setLayoutData((Object)d);
        this.createRegExp(g1, g);
        Control c = super.createControl(this.panel);
        c.setLayoutData((Object)new GridData(1808));
        TMenuInvoker menu = new TMenuInvoker();
        menu.setViewer((Viewer)this.xtable.getViewer());
        this.xtable.getViewer().getTable().addMouseListener((MouseListener)menu);
        this.getControl().addMouseListener((MouseListener)menu);
        return this.panel;
    }

    void createCaseSensitive(Composite g1) {
        this.caseSensitive = new Button(g1, 32);
        this.caseSensitive.setText("Case sensitive");
        GridData fd = new GridData();
        Font font = this.caseSensitive.getFont();
        if (font != null) {
            FontData[] data = font.getFontData();
            data[0].setHeight(data[0].getHeight() - 2);
            font = new Font(font.getDevice(), data);
            this.caseSensitive.setFont(font);
        }
        this.caseSensitive.setLayoutData((Object)fd);
        this.caseSensitive.setSelection(this.isCaseSensitive);
        this.caseSensitive.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesEditor.this.isCaseSensitive = PropertiesEditor.this.caseSensitive.getSelection();
                PropertiesEditor.this.pHelper.applyFilters();
                PropertiesEditor.this.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    void createRegExp(Composite g1, ExpandableComposite g) {
        this.fake = new Button(g1, 32);
        this.fake.setText(UIMessages.PROPERTIES_EDITOR_EXPRESSION);
        GridData fd = new GridData();
        Font font = this.fake.getFont();
        if (font != null) {
            FontData[] data = font.getFontData();
            data[0].setHeight(data[0].getHeight() - 2);
            font = new Font(font.getDevice(), data);
            this.fake.setFont(font);
        }
        this.fake.setLayoutData((Object)fd);
        this.fake.setSelection(this.isFilterExpression);
        this.fake.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PropertiesEditor.this.isFilterExpression = PropertiesEditor.this.fake.getSelection();
                PropertiesEditor.this.pHelper.applyFilters();
                PropertiesEditor.this.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
    }

    protected void setMargins(CommandBar bar) {
        bar.getLayout().setMargins(10, 10, 0, 10);
    }

    protected Color getItemColor(int i) {
        XModelObject o = this.helper.getModelObject(i);
        boolean disabled = "no".equals(o.getAttributeValue(ATTR_ENABLED));
        return disabled ? GREYED_COLOR : DEFAULT_COLOR;
    }

    protected String getAddActionPath() {
        return "CreateActions.CreateProperty";
    }

    protected void edit() {
        XModelObject o = this.helper.getModelObject(this.xtable.getSelectionIndex());
        if (o != null) {
            this.callAction(o, "Properties.Edit");
        }
    }

    public IDocumentProvider getDocumentProvider() {
        return null;
    }

    public void close(boolean save) {
    }

    public boolean isEditable() {
        return false;
    }

    public void doRevertToSaved() {
    }

    public void setAction(String actionID, IAction action) {
        this.actions.put(actionID, action);
    }

    public IAction getAction(String actionId) {
        return this.actions.get(actionId);
    }

    public void setActionActivationCode(String actionId, char activationCharacter, int activationKeyCode, int activationStateMask) {
    }

    public void removeActionActivationCode(String actionId) {
    }

    public boolean showsHighlightRangeOnly() {
        return false;
    }

    public void showHighlightRangeOnly(boolean showHighlightRangeOnly) {
    }

    public void setHighlightRange(int offset, int length, boolean moveCursor) {
    }

    public IRegion getHighlightRange() {
        return null;
    }

    public void resetHighlightRange() {
    }

    public void selectAndReveal(int offset, int length) {
    }

    public IEditorInput getEditorInput() {
        return this.input;
    }

    public IEditorSite getEditorSite() {
        return this.site;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.site = site;
        this.input = input;
        if (input instanceof IFileEditorInput) {
            IFile f = ((IFileEditorInput)input).getFile();
            this.loadPreferences(f);
        }
    }

    void loadPreferences(IFile f) {
        if (f == null || !f.exists()) {
            return;
        }
        try {
            this.filterOpened = "true".equals(f.getPersistentProperty(this.filterOpenedId));
            this.pHelper.nameFilter = f.getPersistentProperty(this.nameFilterId);
            this.pHelper.valueFilter = f.getPersistentProperty(this.valueFilterId);
            if (this.pHelper.nameFilter == null) {
                this.pHelper.nameFilter = "";
            }
            if (this.pHelper.valueFilter == null) {
                this.pHelper.valueFilter = "";
            }
            this.isFilterExpression = "true".equals(f.getPersistentProperty(this.isFilterExpressionId));
            this.isCaseSensitive = "true".equals(f.getPersistentProperty(this.isCaseSensitiveId));
        }
        catch (CoreException coreException) {}
    }

    void savePreferences(IFile f) {
        if (f == null || !f.exists()) {
            return;
        }
        try {
            f.setPersistentProperty(this.filterOpenedId, "" + this.filterOpened);
            f.setPersistentProperty(this.nameFilterId, this.pHelper.nameFilter);
            f.setPersistentProperty(this.valueFilterId, this.pHelper.valueFilter);
            f.setPersistentProperty(this.isFilterExpressionId, "" + this.isFilterExpression);
            f.setPersistentProperty(this.isCaseSensitiveId, "" + this.isCaseSensitive);
        }
        catch (CoreException coreException) {}
    }

    public void addPropertyListener(IPropertyListener listener) {
    }

    public void createPartControl(Composite parent) {
        this.createControl(parent);
        this.createActions();
    }

    public IWorkbenchPartSite getSite() {
        return this.site;
    }

    public String getTitle() {
        return null;
    }

    public Image getTitleImage() {
        return null;
    }

    public String getTitleToolTip() {
        return null;
    }

    public void removePropertyListener(IPropertyListener listener) {
    }

    public void setFocus() {
        if (this.xtable == null || !this.xtable.isActive()) {
            return;
        }
        this.xtable.getTable().setFocus();
    }

    public Object getAdapter(Class adapter) {
        if (ITextOperationTarget.class.equals((Object)adapter)) {
            return this;
        }
        return null;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public boolean isSaveOnCloseNeeded() {
        return false;
    }

    public boolean canDoOperation(int operation) {
        return true;
    }

    public void doOperation(int operation) {
        if (operation > this.actionMapping.size()) {
            ModelUIPlugin.getPluginLog().logError((Throwable)new IllegalArgumentException("Can not find global action with index: " + operation));
        } else {
            String globalAction = this.actionMapping.get(operation);
            this.doGlobalAction(globalAction);
        }
    }

    protected void createActions() {
        this.actionMapping.add(null);
        this.actionMapping.add(1, ActionFactory.UNDO.getId());
        this.actionMapping.add(2, ActionFactory.REDO.getId());
        this.actionMapping.add(3, ActionFactory.CUT.getId());
        this.actionMapping.add(4, ActionFactory.COPY.getId());
        this.actionMapping.add(5, ActionFactory.PASTE.getId());
        this.actionMapping.add(6, ActionFactory.DELETE.getId());
        this.actionMapping.add(7, ActionFactory.SELECT_ALL.getId());
        this.actionMapping.add(8, "ShiftRight");
        this.actionMapping.add(9, "ShiftLeft");
        this.actionMapping.add(10, ActionFactory.PRINT.getId());
        TextActionHelper.addCutAction(this);
        TextActionHelper.addCopyAction(this);
        TextActionHelper.addPasteAction(this);
        TextActionHelper.addDeleteAction(this);
    }

    public void doGlobalAction(String actionName) {
        if (this.nsupport.doGlobalAction(actionName)) {
            // empty if block
        }
        if (this.vsupport.doGlobalAction(actionName)) {
            // empty if block
        }
        if (ITextEditorActionConstants.DELETE.equals(actionName)) {
            this.action(XChildrenEditor.DELETE);
        } else if (ITextEditorActionConstants.COPY.equals(actionName)) {
            this.doXActionCopy();
        } else if (ITextEditorActionConstants.PASTE.equals(actionName)) {
            this.doXActionPaste();
        }
    }

    private void doXActionCopy() {
        if (this.xtable == null || this.xtable.getTable() == null || this.xtable.getTable().isDisposed() || !this.xtable.getTable().isFocusControl()) {
            return;
        }
        ISelection selection = this.getSelectionProvider().getSelection();
        if (selection == null || selection.isEmpty() || !(selection instanceof StructuredSelection)) {
            return;
        }
        StructuredSelection ss = (StructuredSelection)selection;
        if (!(ss.getFirstElement() instanceof XModelObject)) {
            return;
        }
        XModelObject object = (XModelObject)ss.getFirstElement();
        XModelObject[] os = null;
        if (ss.size() > 1) {
            os = new XModelObject[ss.size()];
            Iterator it = ss.iterator();
            int i = 0;
            while (i < os.length) {
                os[i] = (XModelObject)it.next();
                ++i;
            }
        }
        this.invokeXAction("CopyActions.Copy", object, os);
    }

    private void doXActionPaste() {
        if (this.xtable == null || this.xtable.getTable() == null || this.xtable.getTable().isDisposed() || !this.xtable.getTable().isFocusControl()) {
            return;
        }
        this.invokeXAction("CopyActions.Paste", this.helper.getModelObject(), null);
    }

    private void invokeXAction(String actionPath, XModelObject object, XModelObject[] os) {
        XAction action = XActionInvoker.getAction((String)actionPath, (XModelObject)object);
        if (action == null) {
            return;
        }
        if (os == null) {
            if (!action.isEnabled(object)) {
                return;
            }
            XActionInvoker.invoke((String)actionPath, (XModelObject)object, (Properties)new Properties());
        } else {
            if (!action.isEnabled(object, os)) {
                return;
            }
            XActionInvoker.invoke((String)actionPath, (XModelObject)object, (XModelObject[])os, (Properties)new Properties());
        }
    }

    public void refresh() {
        this.xtable.update();
        this.updateBar();
        this.validateStatistics();
    }

    void validateStatistics() {
        boolean errors;
        int filtered = this.pHelper.filteredChildren.length;
        int total = this.pHelper.getModelObject().getChildren().length;
        boolean bl = errors = this.pHelper.compileError.length() > 0;
        if (!this.isFilterExpression) {
            this.statistics.setText(UIMessages.PROPERTIES_EDITOR_FILTER_SIMPLE);
        } else if (errors) {
            this.statistics.setText(this.pHelper.compileError);
        } else {
            this.statistics.setText("");
        }
        if (filtered != total) {
            this.filterComposite.setText(String.valueOf(UIMessages.PROPERTIES_EDITOR_FILTER) + " " + NLS.bind((String)UIMessages.PROPERTIES_EDITOR_FILTER_MATCHES, (Object)filtered, (Object)total));
        } else {
            this.filterComposite.setText(UIMessages.PROPERTIES_EDITOR_FILTER);
        }
        this.filterComposite.layout();
        this.statistics.update();
        this.panel.update();
        this.panel.layout();
        this.panel.getParent().update();
        this.panel.getParent().layout();
    }

    public void dispose() {
        super.dispose();
        if (this.input instanceof IFileEditorInput) {
            IFile f = ((IFileEditorInput)this.input).getFile();
            this.savePreferences(f);
        }
    }

    public class TMenuInvoker
    extends XMenuInvoker {
        public XModelObject getSelectedModelObject() {
            int i = ((TableViewer)this.viewer).getTable().getSelectionIndex();
            if (i < 0) {
                return null;
            }
            return PropertiesEditor.this.helper.getModelObject(i);
        }
    }
}

