/*
 * JBoss, Home of Professional Open Source.
 *
 * See the LEGAL.txt file distributed with this work for information regarding copyright ownership and licensing.
 *
 * See the AUTHORS.txt file distributed with this work for a full listing of individual contributors.
 */
package com.metamatrix.metamodels.xml.provider;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import com.metamatrix.metamodels.xml.util.XmlDocumentAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class XmlDocumentItemProviderAdapterFactory extends XmlDocumentAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
    /**
     * This keeps track of the root adapter factory that delegates to this adapter factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ComposedAdapterFactory parentAdapterFactory;

    /**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected IChangeNotifier changeNotifier = new ChangeNotifier();

    /**
     * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected Collection supportedTypes = new ArrayList();

    /**
     * This constructs an instance.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public XmlDocumentItemProviderAdapterFactory() {
        supportedTypes.add(IEditingDomainItemProvider.class);
        supportedTypes.add(IStructuredItemContentProvider.class);
        supportedTypes.add(ITreeItemContentProvider.class);
        supportedTypes.add(IItemLabelProvider.class);
        supportedTypes.add(IItemPropertySource.class);		
    }

    /**
     * This keeps track of the one adapter used for all {@link com.metamatrix.metamodels.xml.XmlFragment} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected XmlFragmentItemProvider xmlFragmentItemProvider;

    /**
     * This creates an adapter for a {@link com.metamatrix.metamodels.xml.XmlFragment}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createXmlFragmentAdapter() {
        if (xmlFragmentItemProvider == null) {
            xmlFragmentItemProvider = new XmlFragmentItemProvider(this);
        }

        return xmlFragmentItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link com.metamatrix.metamodels.xml.XmlDocument} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected XmlDocumentItemProvider xmlDocumentItemProvider;

    /**
     * This creates an adapter for a {@link com.metamatrix.metamodels.xml.XmlDocument}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createXmlDocumentAdapter() {
        if (xmlDocumentItemProvider == null) {
            xmlDocumentItemProvider = new XmlDocumentItemProvider(this);
        }

        return xmlDocumentItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link com.metamatrix.metamodels.xml.XmlElement} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected XmlElementItemProvider xmlElementItemProvider;

    /**
     * This creates an adapter for a {@link com.metamatrix.metamodels.xml.XmlElement}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createXmlElementAdapter() {
        if (xmlElementItemProvider == null) {
            xmlElementItemProvider = new XmlElementItemProvider(this);
        }

        return xmlElementItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link com.metamatrix.metamodels.xml.XmlAttribute} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected XmlAttributeItemProvider xmlAttributeItemProvider;

    /**
     * This creates an adapter for a {@link com.metamatrix.metamodels.xml.XmlAttribute}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createXmlAttributeAdapter() {
        if (xmlAttributeItemProvider == null) {
            xmlAttributeItemProvider = new XmlAttributeItemProvider(this);
        }

        return xmlAttributeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link com.metamatrix.metamodels.xml.XmlRoot} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected XmlRootItemProvider xmlRootItemProvider;

    /**
     * This creates an adapter for a {@link com.metamatrix.metamodels.xml.XmlRoot}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createXmlRootAdapter() {
        if (xmlRootItemProvider == null) {
            xmlRootItemProvider = new XmlRootItemProvider(this);
        }

        return xmlRootItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link com.metamatrix.metamodels.xml.XmlComment} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected XmlCommentItemProvider xmlCommentItemProvider;

    /**
     * This creates an adapter for a {@link com.metamatrix.metamodels.xml.XmlComment}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createXmlCommentAdapter() {
        if (xmlCommentItemProvider == null) {
            xmlCommentItemProvider = new XmlCommentItemProvider(this);
        }

        return xmlCommentItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link com.metamatrix.metamodels.xml.XmlNamespace} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected XmlNamespaceItemProvider xmlNamespaceItemProvider;

    /**
     * This creates an adapter for a {@link com.metamatrix.metamodels.xml.XmlNamespace}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createXmlNamespaceAdapter() {
        if (xmlNamespaceItemProvider == null) {
            xmlNamespaceItemProvider = new XmlNamespaceItemProvider(this);
        }

        return xmlNamespaceItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link com.metamatrix.metamodels.xml.XmlSequence} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected XmlSequenceItemProvider xmlSequenceItemProvider;

    /**
     * This creates an adapter for a {@link com.metamatrix.metamodels.xml.XmlSequence}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createXmlSequenceAdapter() {
        if (xmlSequenceItemProvider == null) {
            xmlSequenceItemProvider = new XmlSequenceItemProvider(this);
        }

        return xmlSequenceItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link com.metamatrix.metamodels.xml.XmlAll} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected XmlAllItemProvider xmlAllItemProvider;

    /**
     * This creates an adapter for a {@link com.metamatrix.metamodels.xml.XmlAll}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createXmlAllAdapter() {
        if (xmlAllItemProvider == null) {
            xmlAllItemProvider = new XmlAllItemProvider(this);
        }

        return xmlAllItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link com.metamatrix.metamodels.xml.XmlChoice} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected XmlChoiceItemProvider xmlChoiceItemProvider;

    /**
     * This creates an adapter for a {@link com.metamatrix.metamodels.xml.XmlChoice}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createXmlChoiceAdapter() {
        if (xmlChoiceItemProvider == null) {
            xmlChoiceItemProvider = new XmlChoiceItemProvider(this);
        }

        return xmlChoiceItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link com.metamatrix.metamodels.xml.ProcessingInstruction} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected ProcessingInstructionItemProvider processingInstructionItemProvider;

    /**
     * This creates an adapter for a {@link com.metamatrix.metamodels.xml.ProcessingInstruction}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createProcessingInstructionAdapter() {
        if (processingInstructionItemProvider == null) {
            processingInstructionItemProvider = new ProcessingInstructionItemProvider(this);
        }

        return processingInstructionItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all {@link com.metamatrix.metamodels.xml.XmlFragmentUse} instances.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected XmlFragmentUseItemProvider xmlFragmentUseItemProvider;

    /**
     * This creates an adapter for a {@link com.metamatrix.metamodels.xml.XmlFragmentUse}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter createXmlFragmentUseAdapter() {
        if (xmlFragmentUseItemProvider == null) {
            xmlFragmentUseItemProvider = new XmlFragmentUseItemProvider(this);
        }

        return xmlFragmentUseItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public ComposeableAdapterFactory getRootAdapterFactory() {
        return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
    }

    /**
     * This sets the composed adapter factory that contains this factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public boolean isFactoryForType(Object type) {
        return supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    /**
     * This implementation substitutes the factory itself as the key for the adapter.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, this);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    @Override
    public Object adapt(Object object, Object type) {
        if (isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || (((Class)type).isInstance(adapter))) {
                return adapter;
            }
        }

        return null;
    }

    /**
     * This adds a listener.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void addListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.addListener(notifyChangedListener);
    }

    /**
     * This removes a listener.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void removeListener(INotifyChangedListener notifyChangedListener) {
        changeNotifier.removeListener(notifyChangedListener);
    }

    /**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void fireNotifyChanged(Notification notification) {
        changeNotifier.fireNotifyChanged(notification);

        if (parentAdapterFactory != null) {
            parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    /**
     * This disposes all of the item providers created by this factory. 
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void dispose() {
        if (xmlFragmentItemProvider != null) xmlFragmentItemProvider.dispose();
        if (xmlDocumentItemProvider != null) xmlDocumentItemProvider.dispose();
        if (xmlElementItemProvider != null) xmlElementItemProvider.dispose();
        if (xmlAttributeItemProvider != null) xmlAttributeItemProvider.dispose();
        if (xmlRootItemProvider != null) xmlRootItemProvider.dispose();
        if (xmlCommentItemProvider != null) xmlCommentItemProvider.dispose();
        if (xmlNamespaceItemProvider != null) xmlNamespaceItemProvider.dispose();
        if (xmlSequenceItemProvider != null) xmlSequenceItemProvider.dispose();
        if (xmlAllItemProvider != null) xmlAllItemProvider.dispose();
        if (xmlChoiceItemProvider != null) xmlChoiceItemProvider.dispose();
        if (processingInstructionItemProvider != null) processingInstructionItemProvider.dispose();
        if (xmlFragmentUseItemProvider != null) xmlFragmentUseItemProvider.dispose();
    }

}
