/*
 * JBoss, Home of Professional Open Source.
 *
 * See the LEGAL.txt file distributed with this work for information regarding copyright ownership and licensing.
 *
 * See the AUTHORS.txt file distributed with this work for a full listing of individual contributors.
 */
package com.metamatrix.modeler.modelgenerator.uml2.util;

import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Property;
import com.metamatrix.metamodels.relational.BaseTable;

/**
 * This class will encapsulate all 'naming' activities for the Uml2RelationalUtil class.  An implementation of
 * this interface will be used to name all relational objects generated by it.
 */
public interface RelationalObjectNamingStrategy {
    

    
    /**
     * This method will be used to name the Primary Key objects.
     * 
     * @param klass the input Class that is represented in the Relational Output by the table parameter. Can
     * be null if there is no Class in the input UML that is 'directly related to this table.
     * @param table the output tabel that represents the input Class parameter.
     * @return the name of the Primary Key.
     */
    public String getNameForPrimaryKey(Classifier klass, BaseTable table);
    
    /**
     * This method will be used to name a BaseTable that represents the given Class instance.
     * 
     * @param klass
     * @return
     */
    public String getNameForClassBaseTable(Classifier klass);
    
    public String getNameForDatatypeTable(Property referringProperty, DataType datatype);
    
    public String getNameForDatatypeValueColumn(Property referringProperty, DataType datatype, String nameSuffix);

    /**
     * @param fromTable
     * @param i
     * @return
     */
    public String getNameForCopiedPKColumn(BaseTable fromTable, int i);

    /**
     * @param fromTable
     * @return
     */
    public String getNameForForeignKey(BaseTable toTable);
    
    public String getNameForForeignKey(Property property, BaseTable table);

    /**
     * @param table
     * @param property
     * @return
     */
    public String getNameForUnidirectionalIntersectTable(BaseTable fromTable, BaseTable toTable, Property fromProperty);

    /**
     * @param property
     * @return
     */
    public String getNameForColumn(Property property);

    /**
     * @param i
     * @return
     */
    public String getNameForArtificialPKColumn(int i);

    /**
     * @param outputTable1
     * @param outputTable2
     * @param type1
     * @param type2
     * @return
     */
    public String getNameForIntersectTableRepresentingAssociation(Association association);


    
    
    

}
