/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.engines.impl;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.tools.common.meta.XChild;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.impl.RegularObjectImpl;
import org.jboss.tools.common.model.impl.XModelImpl;
import org.jboss.tools.common.model.impl.XModelObjectImpl;
import org.jboss.tools.common.model.loaders.impl.URLRootLoader;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnginesLoader
extends URLRootLoader {
    static Map<String, XModelObject> emptyMap = new HashMap<String, XModelObject>();

    @Override
    public void load(XModelObject object) {
        super.load(object);
        XChild[] cs = object.getModelEntity().getChildren();
        int i = 0;
        while (i < cs.length) {
            if (cs[i].isRequired() && cs[i].getMaxCount() == 1 && object.getChildren(cs[i].getName()).length <= 0) {
                object.addChild(XModelObjectLoaderUtil.createValidObject(object.getModel(), cs[i].getName()));
            }
            ++i;
        }
        if (this.isFilePath(this.getPath(object))) {
            File f = this.file(object);
            if (f.isFile()) {
                object.getModel().getFileRegistry().register(f);
            } else {
                object.getModel().getFileRegistry().unregister(f);
            }
        }
    }

    @Override
    public boolean save(XModelObject object) {
        File f;
        boolean b = super.save(object);
        if (b && this.isFilePath(this.getPath(object)) && (f = this.file(object)).isFile()) {
            object.getModel().getFileRegistry().register(f);
        }
        return b;
    }

    @Override
    public boolean update(XModelObject object) throws XModelException {
        if (!this.isFilePath(this.getPath(object))) {
            return true;
        }
        File f = this.file(object);
        if (!object.getModel().getFileRegistry().isUpdated(f)) {
            return true;
        }
        XModelObject c = object.copy(0);
        this.load(c);
        EnginesLoader.merge(object, c);
        return true;
    }

    @Override
    public String fileroot(XModelObject object) {
        return String.valueOf(XModelConstants.getWorkspace(object.getModel())) + "/";
    }

    @Override
    protected String fileName(XModelObject object) {
        return String.valueOf(object.getModelEntity().getName().toLowerCase()) + ".rex";
    }

    public static void merge(XModelObject object, XModelObject update) throws XModelException {
        EnginesLoader.merge(object, update, object.isActive());
    }

    public static void merge(XModelObject object, XModelObject update, boolean fire) throws XModelException {
        XModelObjectLoaderUtil.mergeAttributes(object, update, fire);
        Map<String, XModelObject> map = EnginesLoader.getChildrenForSaveAsMap(object);
        Set<String> set = null;
        XModelObject[] cs = update.getChildren();
        int i = 0;
        while (i < cs.length) {
            XModelObject c = object.getChildByPath(cs[i].getPathPart());
            if (c == null) {
                if (set == null) {
                    set = EnginesLoader.getChildrenToRemove(map, update);
                }
                if ((c = EnginesLoader.findAppropriateChild(set, cs[i], map)) == null) {
                    c = cs[i].copy();
                    object.addChild(c);
                } else {
                    boolean has_id;
                    boolean bl = has_id = c.getModelEntity().getAttribute(XModelObjectLoaderUtil.ATTR_ID_NAME) != null || ((XModelObjectImpl)c).hasIdAttr();
                    if (has_id) {
                        c.removeFromParent();
                        EnginesLoader.merge(c, cs[i], false);
                        if (!object.addChild(c)) {
                            c.set("__duplicate", "1234");
                            object.addChild(c);
                        }
                        if (c.get("__duplicate") != null) {
                            c.set("__duplicate", "");
                        }
                    } else {
                        EnginesLoader.merge(c, cs[i], fire);
                    }
                }
            } else if (c.getModelEntity().getName().equals(cs[i].getModelEntity().getName())) {
                EnginesLoader.merge(c, cs[i], fire);
            } else {
                object.removeChild(c);
                object.addChild(cs[i].copy());
            }
            map.remove(c.getPathPart());
            ++i;
        }
        if (!map.isEmpty()) {
            for (XModelObject o : map.values()) {
                XChild childEntity = object.getModelEntity().getChild(o.getModelEntity().getName());
                if (childEntity != null && childEntity.isRequired()) continue;
                o.removeFromParent();
            }
        }
        boolean doFire = false;
        int i2 = 0;
        while (i2 < cs.length) {
            int ci;
            XModelObject c = object.getChildByPath(cs[i2].getPathPart());
            if (c != null && (ci = ((RegularObjectImpl)object).getIndexOfChild(c)) != i2) {
                doFire = true;
                ((RegularObjectImpl)object).move(ci, i2, false);
            }
            ++i2;
        }
        if (fire && doFire) {
            ((XModelImpl)object.getModel()).fireStructureChanged(object);
        }
    }

    private static Map<String, XModelObject> getChildrenForSaveAsMap(XModelObject object) {
        XModelObject[] cs = object.getChildrenForSave();
        if (cs.length == 0) {
            return emptyMap;
        }
        HashMap<String, XModelObject> map = new HashMap<String, XModelObject>();
        int i = 0;
        while (i < cs.length) {
            map.put(cs[i].getPathPart(), cs[i]);
            ++i;
        }
        return map;
    }

    public static Set<String> getChildrenToRemove(Map<String, XModelObject> save, XModelObject update) {
        Iterator<String> it = save.keySet().iterator();
        HashSet<String> set = new HashSet<String>();
        while (it.hasNext()) {
            String p = it.next();
            if (update.getChildByPath(p) != null) continue;
            set.add(p);
        }
        return set;
    }

    public static XModelObject findAppropriateChild(Set<String> set, XModelObject updateChild, Map<String, XModelObject> map) {
        String entity = updateChild.getModelEntity().getName();
        Iterator<String> it = set.iterator();
        while (it.hasNext()) {
            String p = it.next();
            XModelObject o = map.get(p);
            if (o == null || !entity.equals(o.getModelEntity().getName())) continue;
            it.remove();
            map.remove(p);
            return o;
        }
        return null;
    }
}

