/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.views.DataflowViewPage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.part.MessagePage;
import org.eclipse.ui.part.PageBook;
import org.eclipse.ui.part.PageBookView;

public class DataflowView
extends PageBookView
implements IResourceChangeListener {
    public void createPartControl(Composite composite) {
        super.createPartControl(composite);
    }

    protected IPage createDefaultPage(PageBook pageBook) {
        MessagePage messagePage = new MessagePage();
        this.initPage((IPageBookViewPage)messagePage);
        messagePage.createControl((Composite)pageBook);
        messagePage.setMessage(PMDPlugin.getDefault().getStringTable().getString("view.dataflow.default_text"));
        return messagePage;
    }

    protected PageBookView.PageRec doCreatePage(IWorkbenchPart iWorkbenchPart) {
        FileRecord fileRecord = this.getFileRecordFromWorkbenchPart(iWorkbenchPart);
        if (fileRecord != null) {
            fileRecord.getResource().getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
            DataflowViewPage dataflowViewPage = new DataflowViewPage(iWorkbenchPart, fileRecord);
            this.initPage((IPageBookViewPage)dataflowViewPage);
            dataflowViewPage.createControl((Composite)this.getPageBook());
            return new PageBookView.PageRec(iWorkbenchPart, (IPage)dataflowViewPage);
        }
        return null;
    }

    protected void doDestroyPage(IWorkbenchPart iWorkbenchPart, PageBookView.PageRec pageRec) {
        DataflowViewPage dataflowViewPage = (DataflowViewPage)pageRec.page;
        if (dataflowViewPage != null) {
            dataflowViewPage.dispose();
        }
        pageRec.dispose();
    }

    protected IWorkbenchPart getBootstrapPart() {
        IWorkbenchPage iWorkbenchPage = this.getSite().getPage();
        if (iWorkbenchPage != null) {
            return iWorkbenchPage.getActiveEditor();
        }
        return null;
    }

    protected boolean isImportant(IWorkbenchPart iWorkbenchPart) {
        return iWorkbenchPart instanceof IEditorPart;
    }

    public void partActivated(IWorkbenchPart iWorkbenchPart) {
        IWorkbenchPart iWorkbenchPart2 = this.getSite().getPage().getActivePart();
        if (iWorkbenchPart2 == null) {
            this.getSite().getPage().activate((IWorkbenchPart)this);
        }
        super.partActivated(iWorkbenchPart);
    }

    public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
        this.partActivated(iWorkbenchPart);
    }

    public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
        try {
            iResourceChangeEvent.getDelta().accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta iResourceDelta) throws CoreException {
                    IPath iPath = DataflowView.this.getCurrentDataflowViewPage().getFileRecord().getResource().getFullPath();
                    if (iResourceDelta.getFullPath().equals((Object)iPath)) {
                        Display.getDefault().asyncExec(new Runnable(this, iResourceDelta){
                            final /* synthetic */ 1 this$1;
                            private final /* synthetic */ IResourceDelta val$delta;
                            {
                                this.this$1 = var1_1;
                                this.val$delta = iResourceDelta;
                            }

                            public void run() {
                                DataflowView.access$1(1.access$0(this.this$1), this.val$delta.getResource());
                            }
                        });
                        return false;
                    }
                    return true;
                }

                static /* synthetic */ DataflowView access$0(1 var0) {
                    return var0.DataflowView.this;
                }
            });
        }
        catch (CoreException coreException) {
            PMDPlugin.getDefault().logError("message.error.core_exception", coreException);
        }
    }

    private DataflowViewPage getCurrentDataflowViewPage() {
        IPage iPage = super.getCurrentPage();
        if (!(iPage instanceof DataflowViewPage)) {
            return null;
        }
        return (DataflowViewPage)iPage;
    }

    private FileRecord getFileRecordFromWorkbenchPart(IWorkbenchPart iWorkbenchPart) {
        if (iWorkbenchPart instanceof IEditorPart) {
            IEditorInput iEditorInput = ((IEditorPart)iWorkbenchPart).getEditorInput();
            if (iEditorInput != null && iEditorInput instanceof IFileEditorInput) {
                IFile iFile = ((IFileEditorInput)iEditorInput).getFile();
                if (iFile.getFileExtension().equalsIgnoreCase("java")) {
                    return new FileRecord((IResource)iFile);
                }
                return null;
            }
        } else {
            IEditorPart iEditorPart = this.getSite().getPage().getActiveEditor();
            if (iEditorPart != null) {
                return this.getFileRecordFromWorkbenchPart((IWorkbenchPart)iEditorPart);
            }
        }
        return null;
    }

    private void refresh(IResource iResource) {
        DataflowViewPage dataflowViewPage = this.getCurrentDataflowViewPage();
        if (dataflowViewPage != null) {
            dataflowViewPage.refresh(iResource);
        }
    }

    static /* synthetic */ void access$1(DataflowView dataflowView, IResource iResource) {
        dataflowView.refresh(iResource);
    }
}

