/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.action.impl;

import java.util.Properties;
import org.jboss.tools.common.meta.action.impl.MultistepWizardStep;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.meta.action.impl.handlers.PasteHandler;
import org.jboss.tools.common.model.XModelException;

public class MultistepWizardSupport
extends SpecialWizardSupport {
    protected MultistepWizardStep[] steps = this.createSteps();
    protected int[] previousSteps = new int[10];
    static String[] N_F_C_ACTIONS = new String[]{NEXT, FINISH, CANCEL, HELP};
    static String[] F_C_ACTIONS = new String[]{FINISH, CANCEL, HELP};
    static String[] B_F_C_ACTIONS = new String[]{BACK, FINISH, CANCEL, HELP};
    static String[] B_N_F_C_ACTIONS = new String[]{BACK, NEXT, FINISH, CANCEL, HELP};

    protected MultistepWizardStep[] createSteps() {
        return new MultistepWizardStep[0];
    }

    protected void initSteps() {
        int i = 0;
        while (i < this.steps.length) {
            this.steps[i].setSupport(this, i);
            ++i;
        }
    }

    public void action(String name) throws XModelException {
        if (FINISH.equals(name)) {
            this.execute();
            this.setFinished(true);
        } else if (CANCEL.equals(name)) {
            this.getProperties().setProperty(PasteHandler.IS_CANCELLED, "true");
            this.setFinished(true);
        } else if (NEXT.equals(name)) {
            int next = this.next();
            this.previousSteps[next] = this.getStepId();
            this.setStepId(next);
        } else if (BACK.equals(name)) {
            this.setStepId(this.previousSteps[this.getStepId()]);
        } else if (HELP.equals(name)) {
            this.help();
        }
    }

    public int getPreviousStepId() {
        return this.previousSteps[this.getStepId()];
    }

    public String[] getActionNames(int stepId) {
        if (stepId == 0) {
            return this.hasNext(stepId) ? N_F_C_ACTIONS : F_C_ACTIONS;
        }
        return this.hasNext(stepId) ? B_N_F_C_ACTIONS : B_F_C_ACTIONS;
    }

    protected boolean hasNext(int stepId) {
        return stepId < this.steps.length - 1;
    }

    public String getStepImplementingClass(int stepId) {
        if (stepId >= 0 && stepId < this.steps.length) {
            return this.steps[stepId].getStepImplementingClass();
        }
        return super.getStepImplementingClass(stepId);
    }

    public boolean isFieldEditorEnabled(int stepId, String name, Properties values) {
        return this.steps[stepId].isFieldEditorEnabled(name, values);
    }

    private int next() throws XModelException {
        int step = this.getStepId() + 1;
        while (!this.isRequired(step)) {
            ++step;
        }
        this.prepareStep(step);
        return step;
    }

    protected void prepareStep(int nextStep) throws XModelException {
    }

    protected boolean isRequired(int nextStep) {
        return true;
    }

    protected void execute() throws XModelException {
    }
}

