/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import java.text.MessageFormat;
import java.util.Properties;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.filesystems.impl.MountFileSystemHandler;
import org.jboss.tools.common.model.undo.XUndoableImpl;

public class UnmountFileSystemUndo
extends XUndoableImpl {
    protected XModel model = null;
    protected String entity;
    protected String pathpart;
    protected Properties p = new Properties();
    protected String[] pns = new String[]{"name", "location", "slave model", "file system"};

    public UnmountFileSystemUndo(XModelObject fs) {
        this.model = fs.getModel();
        this.pathpart = fs.getPathPart();
        this.entity = fs.getModelEntity().getName();
        int i = 0;
        while (i < this.pns.length) {
            if (fs.getModelEntity().getAttribute(this.pns[i]) != null) {
                this.p.setProperty(this.pns[i], fs.getAttributeValue(this.pns[i]));
            }
            ++i;
        }
        String nm = this.p.getProperty(this.pns[1]) != null ? this.p.getProperty(this.pns[1]) : MessageFormat.format("Engines/remote model/ {0}:FileSystems/{1}", this.p.getProperty(this.pns[2]), this.p.getProperty(this.pns[3]));
        this.description = MessageFormat.format("Unmount file system {0}", nm);
    }

    protected void doUndo() {
        XModelObject o = this.model.createModelObject(this.entity, this.p);
        FileSystemsHelper.getFileSystems(this.model).addChild(o);
        MountFileSystemHandler.updateClassPath(o);
    }

    protected void doRedo() {
        XModelObject o = this.model.getByPath("FileSystems/" + this.pathpart);
        if (o != null) {
            o.removeFromParent();
        }
        MountFileSystemHandler.updateClassPath(o);
    }

    protected String getActionIcon() {
        return "images/actions/delete.gif";
    }
}

