/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.helpers;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.common.model.util.EclipseJavaUtil;
import org.jboss.tools.struts.StrutsModelPlugin;

public class MethodDescriptor {
    private IMethod constructor;

    public MethodDescriptor(IMethod constructor) {
        this.constructor = constructor;
    }

    public String getName() {
        return this.constructor.getElementName();
    }

    public String getParameters() {
        StringBuffer result = new StringBuffer();
        String[] ps = this.constructor.getParameterTypes();
        int i = 0;
        while (i < ps.length) {
            String type = EclipseJavaUtil.resolveType((IType)this.constructor.getDeclaringType(), (String)ps[i]);
            if (type == null) {
                type = ps[i];
            }
            result.append('p').append(i).append(i == ps.length - 1 ? "" : ", ");
            ++i;
        }
        return result.toString();
    }

    public String getParametersWithType() {
        StringBuffer result = new StringBuffer();
        String[] ps = this.constructor.getParameterTypes();
        int i = 0;
        while (i < ps.length) {
            String type = EclipseJavaUtil.resolveType((IType)this.constructor.getDeclaringType(), (String)ps[i]);
            if (type == null) {
                type = ps[i];
            }
            type = this.convertType(type);
            result.append(type);
            result.append(' ').append('p').append(i);
            if (i < ps.length - 1) {
                result.append(", ");
            }
            ++i;
        }
        return result.toString();
    }

    private String convertType(String type) {
        String postfix = "";
        while (type.startsWith("[")) {
            postfix = String.valueOf(postfix) + "[]";
            type = type.substring(1);
        }
        if (type.startsWith("L") && type.endsWith(";")) {
            return String.valueOf(type.substring(1, type.length() - 1)) + postfix;
        }
        if (type.equals("I")) {
            type = "int";
        }
        return String.valueOf(type) + postfix;
    }

    public String getModifiers() {
        StringBuffer result = new StringBuffer();
        int modifiers = 0;
        try {
            modifiers = this.constructor.getFlags();
        }
        catch (JavaModelException e) {
            StrutsModelPlugin.getPluginLog().logError((Throwable)e);
        }
        if (Flags.isPublic((int)modifiers)) {
            result.append("public");
        } else if (Flags.isPrivate((int)modifiers)) {
            result.append("private");
        } else if (Flags.isProtected((int)modifiers)) {
            result.append("protected");
        }
        if (Flags.isStatic((int)modifiers)) {
            result.append(result.length() > 0 ? " " : "").append("static");
        }
        if (Flags.isFinal((int)modifiers)) {
            result.append(result.length() > 0 ? " " : "").append("final");
        }
        return result.toString();
    }
}

