/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import java.io.File;
import org.jboss.tools.common.model.filesystems.impl.LFileObject;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;

public class LFileObjectImpl
implements LFileObject {
    protected String root;
    protected String aliaspath;
    protected String relpath;
    private File f = null;

    public LFileObjectImpl(String root, String alias, String relpath) {
        this.root = root;
        this.relpath = relpath;
        this.aliaspath = relpath.length() == 0 ? alias : String.valueOf(alias) + '/' + relpath;
        String fn = relpath.length() == 0 ? root : root + '/' + relpath;
        this.f = new File(fn);
    }

    public String getName() {
        return this.f == null ? null : this.f.getName();
    }

    public boolean exists() {
        return this.f != null && this.f.exists();
    }

    public boolean isDirectory() {
        return this.f != null && this.f.isDirectory();
    }

    public boolean isFile() {
        return this.f != null && this.f.isFile();
    }

    public long lastModified() {
        return this.f == null ? 0L : this.f.lastModified();
    }

    public String getPath() {
        return this.aliaspath;
    }

    public boolean canWrite() {
        return this.f != null && this.f.canWrite();
    }

    public String read() {
        return this.f == null ? "" : XModelObjectLoaderUtil.readFile(this.f);
    }

    public void write(String s) {
        XModelObjectLoaderUtil.writeFile(this.f, s);
    }

    public String[] listFiles() {
        File[] fs;
        File[] fileArray = fs = this.f == null ? null : this.f.listFiles();
        if (fs == null) {
            return new String[0];
        }
        String[] rs = new String[fs.length];
        String rp = this.getPath();
        int i = 0;
        while (i < rs.length) {
            rs[i] = String.valueOf(rp) + '/' + fs[i].getName();
            ++i;
        }
        return rs;
    }

    public boolean mkdirs() {
        return this.f != null && this.f.mkdirs();
    }

    public boolean delete() {
        if (this.f == null) {
            return true;
        }
        XModelObjectLoaderUtil.remove(this.f);
        return this.f.exists();
    }
}

