/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.document.NodeImpl;
import org.jboss.tools.jst.jsp.util.NodesManagingUtil;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.NodeData;
import org.jboss.tools.vpe.editor.mapping.VpeDomMapping;
import org.jboss.tools.vpe.editor.mapping.VpeElementMapping;
import org.jboss.tools.vpe.editor.mapping.VpeNodeMapping;
import org.jboss.tools.vpe.editor.selection.VpeSelectionController;
import org.jboss.tools.vpe.editor.template.ISelectionManager;
import org.jboss.tools.vpe.editor.template.SelectionData;
import org.jboss.tools.vpe.editor.template.VpeTemplate;
import org.jboss.tools.vpe.editor.util.SelectionUtil;
import org.jboss.tools.vpe.editor.util.TextUtil;
import org.jboss.tools.vpe.editor.util.VpeNodesManagingUtil;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsISelection;
import org.w3c.dom.Node;

public class SelectionManager
implements ISelectionManager {
    private VpePageContext pageContext;
    private StructuredTextEditor sourceEditor;
    private VpeSelectionController selectionController;

    public SelectionManager(VpePageContext pageContext, StructuredTextEditor sourceEditor, VpeSelectionController selectionController) {
        this.pageContext = pageContext;
        this.sourceEditor = sourceEditor;
        this.selectionController = selectionController;
    }

    @Override
    public final void setSelection(nsISelection selection) {
        int selectionLength;
        int selectionOffset;
        nsIDOMNode visualNode = SelectionUtil.getSelectedNode(selection);
        if (visualNode == null) {
            return;
        }
        SelectionData selectionData = this.getSelectionData(visualNode);
        if (selectionData == null) {
            return;
        }
        if (selectionData.getVisualNode().getNodeType() != 3 && SelectionUtil.getLastSelectedNode(this.getPageContext()) == selectionData.getVisualNode()) {
            return;
        }
        if (selectionData.isNodeEditable()) {
            Point sourceSelectionRange = SelectionUtil.getSourceSelectionRange(selection, selectionData.getSourceNode());
            selectionOffset = sourceSelectionRange.x;
            selectionLength = sourceSelectionRange.y;
        } else {
            selectionOffset = 0;
            selectionLength = NodesManagingUtil.getNodeLength((Node)selectionData.getSourceNode());
        }
        SelectionUtil.setSourceSelection(this.getPageContext(), selectionData.getSourceNode(), selectionOffset, selectionLength);
        this.getPageContext().getVisualBuilder().setSelectionRectangle(selectionData.getVisualNode());
    }

    @Override
    public final void setSelection(nsIDOMNode visualNode, int rangeOffset) {
        int selectionLength;
        int selectionOffset;
        SelectionData selectionData = this.getSelectionData(visualNode);
        if (selectionData == null) {
            return;
        }
        if (selectionData.isNodeEditable()) {
            selectionOffset = rangeOffset;
            selectionLength = 0;
        } else {
            selectionOffset = 0;
            selectionLength = NodesManagingUtil.getNodeLength((Node)selectionData.getSourceNode());
        }
        SelectionUtil.clearSelection(this.selectionController);
        SelectionUtil.setSourceSelection(this.getPageContext(), selectionData.getSourceNode(), selectionOffset, selectionLength);
        this.getPageContext().getVisualBuilder().setSelectionRectangle(selectionData.getVisualNode());
    }

    private SelectionData getSelectionData(nsIDOMNode visualNode) {
        boolean isNodeEditable;
        Node targetSourceNode;
        nsIDOMNode targetVisualNode;
        VpeNodeMapping nodeMapping = VpeNodesManagingUtil.getNodeMapping(this.getDomMapping(), visualNode);
        if (nodeMapping == null) {
            return null;
        }
        if (nodeMapping instanceof VpeElementMapping) {
            VpeElementMapping elementMapping = (VpeElementMapping)nodeMapping;
            NodeData nodeData = elementMapping.getTemplate().getNodeData(visualNode, elementMapping.getElementData(), this.getDomMapping());
            if (nodeData != null) {
                targetVisualNode = nodeData.getVisualNode();
                if (nodeData.getSourceNode() != null) {
                    targetSourceNode = nodeData.getSourceNode();
                    isNodeEditable = nodeData.isEditable();
                } else {
                    targetSourceNode = elementMapping.getSourceNode();
                    isNodeEditable = false;
                }
            } else {
                targetVisualNode = elementMapping.getVisualNode();
                targetSourceNode = elementMapping.getSourceNode();
                isNodeEditable = false;
            }
        } else {
            targetVisualNode = nodeMapping.getVisualNode();
            targetSourceNode = nodeMapping.getSourceNode();
            isNodeEditable = true;
        }
        SelectionData selectionData = new SelectionData(targetVisualNode, targetSourceNode, isNodeEditable);
        return selectionData;
    }

    @Override
    public final void refreshVisualSelection() {
        nsIDOMNode targetVisualNode;
        if (this.getSourceEditor().getTextViewer() == null) {
            return;
        }
        Point range = SelectionUtil.getSourceSelectionRange(this.getSourceEditor());
        if (range == null) {
            return;
        }
        int focusOffcetInSourceDocument = range.x;
        int anchorOffcetInSourceDocument = focusOffcetInSourceDocument + range.y;
        VpeNodeMapping nodeMapping = SelectionUtil.getNodeMappingBySourceSelection(this.getSourceEditor(), this.getDomMapping());
        if (nodeMapping == null) {
            return;
        }
        SelectionUtil.clearSelection(this.selectionController);
        if (nodeMapping instanceof VpeElementMapping) {
            VpeElementMapping elementMapping = (VpeElementMapping)nodeMapping;
            VpeTemplate template = elementMapping.getTemplate();
            NodeData nodeData = template.getNodeData(targetVisualNode = template.getVisualNodeBySourcePosition(elementMapping, focusOffcetInSourceDocument, anchorOffcetInSourceDocument, this.getDomMapping()), elementMapping.getElementData(), this.getDomMapping());
            if (nodeData != null) {
                this.restoreVisualCursorPosition(template, nodeData, focusOffcetInSourceDocument, anchorOffcetInSourceDocument);
            }
        } else {
            targetVisualNode = nodeMapping.getVisualNode();
        }
        this.getPageContext().getVisualBuilder().setSelectionRectangle(targetVisualNode);
    }

    private void restoreVisualCursorPosition(VpeTemplate template, NodeData nodeData, int focusOffcetInSourceDocument, int anchorOffsetrInSourceDocument) {
        nsIDOMNode visualNode = nodeData.getVisualNode();
        if (visualNode != null && visualNode.getNodeType() == 3 && nodeData.getSourceNode() != null) {
            Node targetSourceNode = nodeData.getSourceNode();
            int focusOffcetReferenceToSourceNode = focusOffcetInSourceDocument - NodesManagingUtil.getStartOffsetNode((Node)targetSourceNode);
            int anchorOffcetReferenceToSourceNode = anchorOffsetrInSourceDocument - NodesManagingUtil.getStartOffsetNode((Node)targetSourceNode);
            int length = visualNode.getNodeValue().length();
            NodeImpl sourceTextImpl = (NodeImpl)targetSourceNode;
            int visualNodeFocusOffcet = TextUtil.visualPosition(sourceTextImpl.getValueSource(), focusOffcetReferenceToSourceNode);
            int visualNodeAnchorOffcet = TextUtil.visualPosition(sourceTextImpl.getValueSource(), anchorOffcetReferenceToSourceNode);
            if (visualNodeFocusOffcet > length || visualNodeAnchorOffcet > length) {
                return;
            }
            nsISelection selection = this.selectionController.getSelection((short)1);
            selection.collapse(visualNode, visualNodeFocusOffcet);
            if (visualNodeAnchorOffcet != visualNodeFocusOffcet) {
                selection.extend(visualNode, visualNodeAnchorOffcet);
            }
        }
    }

    protected VpePageContext getPageContext() {
        return this.pageContext;
    }

    protected VpeDomMapping getDomMapping() {
        return this.pageContext.getDomMapping();
    }

    protected StructuredTextEditor getSourceEditor() {
        return this.sourceEditor;
    }
}

