/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.problem;

import java.util.ArrayList;
import org.eclipse.jface.action.IAction;
import org.jboss.tools.common.model.ui.problem.ProblemDialogAction;

public class Problem {
    public static final String ERROR = "Problem.Error";
    public static final int NONE = -1;
    private String type;
    private String message;
    private String title;
    private String location;
    private int line = -1;
    private int column = -1;
    private int position = -1;
    private ArrayList<IAction> actions = new ArrayList();

    private Problem() {
    }

    public Problem(String message) {
        this.message = message;
        this.type = ERROR;
    }

    public Problem(String message, int position, int line, int column) {
        this.message = message;
        this.position = position;
        this.line = line;
        this.column = column;
        this.type = ERROR;
    }

    public void addActions(IAction[] actions) {
        int i = 0;
        while (i < actions.length) {
            this.actions.add(actions[i]);
            ++i;
        }
    }

    public void addAction(ProblemDialogAction action) {
        if (action != null) {
            this.actions.add((IAction)action);
        }
    }

    public int getColumn() {
        return this.column;
    }

    public int getPosition() {
        return this.position;
    }

    public int getLine() {
        return this.line;
    }

    public String getLocation() {
        return this.location;
    }

    public String getMessage() {
        return this.message;
    }

    public String getTitle() {
        return this.title;
    }

    public void setColumn(int i) {
        this.column = i;
    }

    public void setLine(int i) {
        this.line = i;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public ArrayList getActions() {
        return this.actions;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        this.type = string;
    }

    public int hashCode() {
        return this.line + (this.message == null ? -1 : this.message.hashCode()) + (this.location == null ? -1 : this.location.hashCode());
    }

    public boolean equals(Object object) {
        if (!(object instanceof Problem)) {
            return false;
        }
        Problem other = (Problem)object;
        return other.line == this.line && this.equalStrings(other.message, this.message) && this.equalStrings(other.location, this.location);
    }

    private boolean equalStrings(String s1, String s2) {
        return s1 == null && s2 == null || s1 != null && s1.equals(s2);
    }

    public String toString() {
        return "type=" + this.type + " location=" + this.location + " message=" + this.message + " line=" + this.line + " column=" + this.column;
    }
}

