/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.templates.model;

import java.util.Collection;
import java.util.HashMap;
import org.jboss.tools.common.model.ui.templates.model.MetaClassTemplate;
import org.jboss.tools.common.model.ui.templates.model.MetaElementFactory;

public class MetaGroup {
    private String uri;
    private HashMap<String, MetaClassTemplate> templates = new HashMap();
    MetaGroup parent;

    public void setParent(MetaGroup parent) {
        this.parent = parent;
        if (parent != null) {
            this.uri = parent.getUri();
            for (MetaClassTemplate pc : parent.getTemplates()) {
                MetaClassTemplate t = MetaElementFactory.instance.createClassTemplate(pc);
                this.templates.put(t.getAxis(), t);
            }
        }
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public Collection getTemplates() {
        return this.templates.values();
    }

    public MetaClassTemplate getMetaTemplate(String axis) {
        return this.templates.get(axis);
    }

    public MetaClassTemplate addMetaClassTemplate(String axis) {
        MetaClassTemplate t = this.getMetaTemplate(axis);
        if (t != null) {
            return t;
        }
        t = MetaElementFactory.instance.createClassTemplate(null);
        t.setAxis(axis);
        this.templates.put(axis, t);
        return t;
    }

    public boolean isOverriding() {
        for (MetaClassTemplate t : this.templates.values()) {
            if (!t.isOverriding()) continue;
            return true;
        }
        return false;
    }

    public void commitToParent() {
        if (this.parent == null) {
            return;
        }
        for (MetaClassTemplate pc : this.getTemplates()) {
            pc.commitToParent();
        }
    }

    public void loadFromParent(int depth) {
        if (this.parent == null) {
            return;
        }
        for (MetaClassTemplate pc : this.getTemplates()) {
            pc.loadFromParent(depth);
        }
    }
}

