/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.java.generation;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

public class JavaBeanGenerator {
    public static String PARAM_PACKAGENAME = "packageName";
    public static String PARAM_SHORTNAME = "shortName";
    public static String PARAM_ACCESS = "access";
    public static String PARAM_EXTENDS = "extends";
    public static String PARAM_IMPLEMENTS = "implements";
    public static String PARAM_INTERFACE = "interface";
    public static String ATT_CLASS_NAME = "class name";
    public static String ATT_ACCESS_MODIFIER = "access modifier";
    protected XModelObject context;
    protected Properties input;

    public void setContext(XModelObject context) {
        this.context = context;
    }

    public void setInput(Properties input) {
        this.input = input;
    }

    public IJavaProject getJavaProject() {
        IProject project = EclipseResourceUtil.getProject(this.context);
        return EclipseResourceUtil.getJavaProject((IProject)project);
    }

    public void generate() throws CoreException {
        IJavaProject javaproject = this.getJavaProject();
        if (javaproject == null) {
            return;
        }
        String srcpath = this.getSrcLocation(javaproject);
        if (srcpath == null) {
            return;
        }
        String qclsname = this.input.getProperty(ATT_CLASS_NAME);
        String filepath = String.valueOf(srcpath) + "/" + qclsname.replace('.', '/') + ".java";
        if (new File(filepath).exists()) {
            return;
        }
        int lastDot = qclsname.lastIndexOf(46);
        Properties p = new Properties();
        p.setProperty(PARAM_SHORTNAME, qclsname.substring(lastDot + 1));
        p.setProperty(PARAM_PACKAGENAME, lastDot < 0 ? "" : qclsname.substring(0, lastDot));
        String access = this.input.getProperty(ATT_ACCESS_MODIFIER);
        if (access == null || "default".equals(access)) {
            access = "";
        }
        p.setProperty(PARAM_ACCESS, access);
        p.setProperty(PARAM_EXTENDS, this.input.getProperty("extends"));
        p.setProperty(PARAM_IMPLEMENTS, this.input.getProperty("implements").replace(';', ','));
        p.setProperty(PARAM_INTERFACE, this.input.getProperty("interface").replace(';', ','));
        this.doGenerateJava(javaproject, filepath, p);
    }

    private String getSrcLocation(IJavaProject javaproject) throws CoreException {
        IClasspathEntry[] entries = javaproject.getResolvedClasspath(true);
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getEntryKind() == 3) {
                Object resource = null;
                IPath projectPath = ModelPlugin.getWorkspace().getRoot().getFullPath();
                resource = projectPath != null && projectPath.equals((Object)projectPath.append(entries[i].getPath())) ? ModelPlugin.getWorkspace().getRoot() : ModelPlugin.getWorkspace().getRoot().getFolder(entries[i].getPath());
                return resource.getLocation().toString();
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGenerateJava(IJavaProject javaproject, String filepath, Properties p) throws CoreException {
        ICompilationUnit cu;
        String pkgname;
        IPackageFragmentRoot root = JavaBeanGenerator.getJavaProjectSrcRoot(javaproject);
        IPackageFragment pack = root.getPackageFragment(pkgname = p.getProperty(PARAM_PACKAGENAME));
        if (!pack.exists()) {
            pack = root.createPackageFragment(pkgname, true, null);
        }
        String shortname = p.getProperty(PARAM_SHORTNAME);
        String lineDelimiter = System.getProperty("line.separator", "\n");
        ICompilationUnit parentCU = pack.createCompilationUnit(String.valueOf(shortname) + ".java", "", false, null);
        ICompilationUnit createdWorkingCopy = parentCU.getWorkingCopy(null);
        String typeContent = this.constructTypeStub(p, lineDelimiter);
        String cuContent = this.buildClassContent(parentCU, shortname, typeContent, lineDelimiter);
        createdWorkingCopy.getBuffer().setContents(cuContent);
        IType createdType = createdWorkingCopy.getType(shortname);
        ICompilationUnit iCompilationUnit = cu = createdType.getCompilationUnit();
        synchronized (iCompilationUnit) {
            cu.reconcile(0, true, null, null);
        }
        ISourceRange range = createdType.getSourceRange();
        IBuffer buf = cu.getBuffer();
        String originalContent = buf.getText(range.getOffset(), range.getLength());
        String formattedContent = JavaBeanGenerator.codeFormat2(4, originalContent, 0, lineDelimiter, cu.getJavaProject());
        buf.replace(range.getOffset(), range.getLength(), formattedContent);
        cu.commitWorkingCopy(false, null);
    }

    private String buildClassContent(ICompilationUnit cls, String shortname, String typeContent, String lineDelimiter) throws CoreException {
        StringBuffer qName = new StringBuffer();
        qName.append(shortname);
        String comments = CodeGeneration.getTypeComment((ICompilationUnit)cls, (String)qName.toString(), (String)lineDelimiter);
        IPackageFragment p = (IPackageFragment)cls.getParent();
        String content = CodeGeneration.getCompilationUnitContent((ICompilationUnit)cls, (String)comments, (String)typeContent, (String)lineDelimiter);
        if (content != null) {
            ASTParser parser = ASTParser.newParser((int)2);
            parser.setSource(content.toCharArray());
            CompilationUnit unit = (CompilationUnit)parser.createAST(null);
            if ((p.isDefaultPackage() || unit.getPackage() != null) && !unit.types().isEmpty()) {
                return content;
            }
        }
        StringBuffer sb = new StringBuffer();
        if (!p.isDefaultPackage()) {
            sb.append("package ");
            sb.append(p.getElementName());
            sb.append(';');
        }
        int i = 0;
        while (i < 2) {
            sb.append(lineDelimiter);
            ++i;
        }
        if (comments != null) {
            sb.append(comments);
            sb.append(lineDelimiter);
        }
        sb.append(typeContent);
        return sb.toString();
    }

    public static String codeFormat2(int kind, String sourceString, int indentationLevel, String lineSeparator, IJavaProject project) {
        TextEdit edit = ToolFactory.createCodeFormatter((Map)project.getOptions(true)).format(kind, sourceString, 0, sourceString.length(), indentationLevel, lineSeparator);
        Document doc = new Document(sourceString);
        try {
            edit.apply((IDocument)doc, 0);
            return doc.get();
        }
        catch (BadLocationException badLocationException) {
            return sourceString;
        }
    }

    public static IPackageFragmentRoot getJavaProjectSrcRoot(IJavaProject javaProject) throws CoreException {
        IClasspathEntry[] es = javaProject.getResolvedClasspath(true);
        int i = 0;
        while (i < es.length) {
            if (es[i].getEntryKind() == 3) {
                return javaProject.getPackageFragmentRoot((IResource)ModelPlugin.getWorkspace().getRoot().getFolder(es[i].getPath()));
            }
            ++i;
        }
        return null;
    }

    private String constructTypeStub(Properties p, String lineDelimiter) {
        StringBuffer sb = new StringBuffer();
        String access = p.getProperty(PARAM_ACCESS);
        if (access == null) {
            access = "";
        } else if (access.length() > 0) {
            access = String.valueOf(access) + " ";
        }
        boolean isInterface = "true".equals(p.getProperty(PARAM_INTERFACE));
        String kind = isInterface ? "interface " : "class ";
        String shortname = p.getProperty(PARAM_SHORTNAME);
        String _extends = p.getProperty(PARAM_EXTENDS);
        if (_extends == null) {
            _extends = "";
        } else if (_extends.length() > 0) {
            _extends = "extends " + _extends + " ";
        }
        String _implements = this.formatImplements(p.getProperty(PARAM_IMPLEMENTS));
        if (_implements == null) {
            _implements = "";
        } else if (_implements.length() > 0) {
            _implements = isInterface ? "extends " + _implements + " " : "implements " + _implements + " ";
        }
        String header = String.valueOf(access) + kind + shortname + " " + _extends + _implements + "{" + lineDelimiter;
        sb.append(header);
        if (!isInterface) {
            sb.append("public " + shortname + "() {" + lineDelimiter + "}" + lineDelimiter);
        }
        sb.append("}" + lineDelimiter);
        return sb.toString();
    }

    private String formatImplements(String s) {
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(s, ",;");
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken());
            if (!st.hasMoreTokens()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

