/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.options.impl;

import java.io.File;
import org.eclipse.core.runtime.Preferences;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.options.impl.XStudioLoaderPeer;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.util.FileUtil;

public class PreferenceImportExport
implements Preferences.IPropertyChangeListener {
    static String MODEL_PREFERENCES = "model_preferences";
    static PreferenceImportExport instance;
    int lock = 0;

    public static PreferenceImportExport getInstance() {
        if (instance == null) {
            instance = new PreferenceImportExport();
        }
        return instance;
    }

    public PreferenceImportExport() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                PreferenceImportExport.this.getPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)PreferenceImportExport.this);
            }
        };
        new Thread(r).start();
    }

    public void lock() {
        ++this.lock;
    }

    public void unlock() {
        if (this.lock > 0) {
            --this.lock;
        }
    }

    public boolean isLocked() {
        return this.lock > 0;
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        if (this.isLocked()) {
            return;
        }
        if (!event.getProperty().equals(MODEL_PREFERENCES)) {
            return;
        }
        String newValue = (String)event.getNewValue();
        XStudioLoaderPeer peer = XStudioLoaderPeer.instance();
        File f = peer.getProjectPreferencesFile();
        if (f != null) {
            String text;
            String string = text = f.exists() ? FileUtil.readFile((File)f) : null;
            if (newValue != null && newValue.equals(text)) {
                return;
            }
            if (newValue == null && text == null) {
                return;
            }
            if (newValue != null) {
                FileUtil.writeFile((File)f, (String)newValue);
            } else {
                f.delete();
            }
            this.lock();
            try {
                PreferenceModelUtilities.getPreferenceModel().load();
            }
            finally {
                this.unlock();
            }
        }
    }

    private Preferences getPreferences() {
        return ModelPlugin.getDefault().getPluginPreferences();
    }

    public void apply(File f) {
        if (this.isLocked()) {
            return;
        }
        this.lock();
        try {
            if (f == null || !f.exists()) {
                return;
            }
            String text = FileUtil.readFile((File)f);
            if (text != null && text.length() > 0) {
                String oldValue = this.getPreferences().getString(MODEL_PREFERENCES);
                if (text.equals(oldValue)) {
                    return;
                }
                this.getPreferences().setValue(MODEL_PREFERENCES, text);
            }
        }
        finally {
            this.unlock();
        }
    }
}

