/*
 * JBoss, the OpenSource EJB server
 * 
 * Distributable under LGPL license. See terms of license at gnu.org.
 */
package javax.resource.spi;

import java.util.Timer;

import javax.resource.spi.work.WorkManager;

/**
 * Used to pass context to the resource adapter start(BootstrapContext) method.
 */
public interface BootstrapContext
{
   /**
	 * Creates a new Timer that can be used to perform period work.
	 * 
	 * @return the timer instance
	 * @throws UnavailableException when not timer is available. It can be
	 *            retried later.
	 */
   Timer createTimer() throws UnavailableException;

   /**
	 * Get the work manager, the resource adapter should use this for all work
	 * on new threads.
	 * 
	 * @return the work manager
	 */
   WorkManager getWorkManager();

   /**
	 * Get the XATerminator. The resource adapter should use this to gain access
	 * to the transaction and crash recovery.
	 * 
	 * @return the XATerminator
	 */
   XATerminator getXATerminator();
}