/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.properties;

import de.tobject.findbugs.FindBugsJob;
import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.actions.FindBugsAction;
import de.tobject.findbugs.preferences.FindBugsPreferenceInitializer;
import de.tobject.findbugs.properties.DetectorConfigurationTab;
import de.tobject.findbugs.properties.FilterFilesTab;
import de.tobject.findbugs.properties.ReportConfigurationTab;
import de.tobject.findbugs.reporter.MarkerUtil;
import de.tobject.findbugs.util.ProjectUtilities;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.config.UserPreferences;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FindbugsPropertyPage
extends PropertyPage
implements IWorkbenchPreferencePage {
    private boolean natureEnabled;
    private UserPreferences origUserPreferences;
    private UserPreferences currentUserPreferences;
    private IProject project;
    private Button chkEnableFindBugs;
    private Button chkRunAtFullBuild;
    private Button restoreDefaultsButton;
    private ComboViewer effortViewer;
    private TabFolder tabFolder;
    private DetectorConfigurationTab detectorTab;
    private FilterFilesTab filterFilesTab;
    private ReportConfigurationTab reportConfigurationTab;
    private final Map<DetectorFactory, Boolean> visibleDetectors = new HashMap<DetectorFactory, Boolean>();
    private Button enableProjectCheck;
    private Link workspaceSettingsLink;
    private boolean projectPropsInitiallyEnabled;
    private ScopedPreferenceStore projectStore;
    private ScopedPreferenceStore workspaceStore;

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        IAdaptable resource = this.getElement();
        if (resource != null) {
            this.project = (IProject)resource.getAdapter(IProject.class);
        }
        this.initPreferencesStore(this.project);
        this.createGlobalElements(parent);
        this.createConfigurationTabFolder(parent);
        this.createDefaultsButton(parent);
        this.setProjectEnabled(this.enableProjectCheck == null || this.enableProjectCheck.getSelection());
        return parent;
    }

    private void initPreferencesStore(IProject currProject) {
        this.workspaceStore = new ScopedPreferenceStore((IScopeContext)new InstanceScope(), "edu.umd.cs.findbugs.plugin.eclipse");
        if (currProject != null) {
            this.projectStore = new ScopedPreferenceStore((IScopeContext)new ProjectScope(currProject), "edu.umd.cs.findbugs.plugin.eclipse");
            this.projectPropsInitiallyEnabled = FindbugsPlugin.isProjectSettingsEnabled(currProject);
            if (!this.projectPropsInitiallyEnabled) {
                currProject = null;
            }
            this.setPreferenceStore((IPreferenceStore)this.projectStore);
        } else {
            this.setPreferenceStore((IPreferenceStore)this.workspaceStore);
        }
        this.loadPreferences(currProject);
    }

    private UserPreferences loadPreferences(IProject currProject) {
        this.origUserPreferences = currProject == null ? FindbugsPlugin.getUserPreferences(null, true) : FindbugsPlugin.getProjectPreferences(currProject, true);
        this.currentUserPreferences = (UserPreferences)this.origUserPreferences.clone();
        return this.currentUserPreferences;
    }

    private void createConfigurationTabFolder(Composite composite) {
        this.tabFolder = new TabFolder(composite, 128);
        GridData layoutData = new GridData(1808);
        layoutData.verticalIndent = -5;
        this.tabFolder.setLayoutData((Object)layoutData);
        this.detectorTab = this.createDetectorConfigurationTab(this.tabFolder);
        this.reportConfigurationTab = this.createReportConfigurationTab(this.tabFolder);
        this.filterFilesTab = this.createFilterFilesTab(this.tabFolder);
    }

    private void createDefaultsButton(Composite composite) {
        this.restoreDefaultsButton = new Button(composite, 0);
        this.restoreDefaultsButton.setText(FindbugsPropertyPage.getMessage("property.restoreSettings"));
        this.restoreDefaultsButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.restoreDefaultsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FindbugsPropertyPage.this.restoreDefaultSettings();
            }
        });
    }

    private void createGlobalElements(Composite parent) {
        if (this.getProject() != null) {
            this.createWorkspaceButtons(parent);
        }
        Composite globalGroup = new Composite(parent, 128);
        GridLayout layout = new GridLayout(4, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        globalGroup.setLayout((Layout)layout);
        GridData layoutData = new GridData(768);
        layoutData.verticalIndent = -2;
        globalGroup.setLayoutData((Object)layoutData);
        this.natureEnabled = ProjectUtilities.hasFindBugsNature(this.getProject());
        if (this.getProject() != null) {
            this.chkEnableFindBugs = new Button(globalGroup, 32);
            this.chkEnableFindBugs.setText(FindbugsPropertyPage.getMessage("property.runAuto"));
            this.chkEnableFindBugs.setSelection(this.natureEnabled);
            this.chkEnableFindBugs.setToolTipText(FindbugsPropertyPage.getMessage("property.runAuto.tip"));
            this.chkEnableFindBugs.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    boolean enabled = FindbugsPropertyPage.this.chkEnableFindBugs.getSelection();
                    FindbugsPropertyPage.this.chkRunAtFullBuild.setEnabled(enabled);
                }
            });
            this.chkRunAtFullBuild = new Button(globalGroup, 32);
            this.chkRunAtFullBuild.setText(FindbugsPropertyPage.getMessage("property.runFull"));
            this.chkRunAtFullBuild.setSelection(this.origUserPreferences.isRunAtFullBuild());
            this.chkRunAtFullBuild.setToolTipText(FindbugsPropertyPage.getMessage("property.runFull.tip"));
            this.chkRunAtFullBuild.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    boolean selection = FindbugsPropertyPage.this.chkRunAtFullBuild.getSelection();
                    FindbugsPropertyPage.this.currentUserPreferences.setRunAtFullBuild(selection);
                }
            });
            this.chkRunAtFullBuild.setEnabled(this.chkEnableFindBugs.getSelection());
        }
        Composite prioGroup = new Composite(globalGroup, 0);
        GridLayout prioLayout = new GridLayout(2, false);
        prioGroup.setLayout((Layout)prioLayout);
        layoutData = new GridData(768);
        layoutData.horizontalIndent = -5;
        layoutData.verticalIndent = -5;
        prioGroup.setLayoutData((Object)layoutData);
        Label effortLabel = new Label(prioGroup, 0);
        effortLabel.setText(FindbugsPropertyPage.getMessage("property.effort"));
        this.effortViewer = new ComboViewer(prioGroup, 12);
        this.effortViewer.add((Object[])Effort.values());
        String effortLevel = this.currentUserPreferences.getEffort();
        this.effortViewer.setSelection((ISelection)new StructuredSelection((Object)Effort.getEffort(effortLevel)), true);
        this.effortViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Effort placeHolder = (Effort)((Object)((IStructuredSelection)event.getSelection()).getFirstElement());
                FindbugsPropertyPage.this.currentUserPreferences.setEffort(placeHolder.getEffortLevel());
            }
        });
        effortLabel.setToolTipText("Set FindBugs analysis effort (minimal is faster but less precise)");
        this.effortViewer.getCombo().setToolTipText("Set FindBugs analysis effort (minimal is faster but less precise)");
    }

    private void createWorkspaceButtons(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.enableProjectCheck = FindbugsPropertyPage.createLabeledCheck("Enable project specific settings", "These settings would be used for the current project only", this.projectPropsInitiallyEnabled, composite);
        this.enableProjectCheck.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean enabled = FindbugsPropertyPage.this.enableProjectCheck.getSelection();
                IProject currProject = enabled ? FindbugsPropertyPage.this.getProject() : null;
                FindbugsPropertyPage.this.refreshUI(FindbugsPropertyPage.this.loadPreferences(currProject));
                FindbugsPropertyPage.this.setProjectEnabled(enabled);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.workspaceSettingsLink = this.createLink(composite, "Configure Workspace Settings...");
        this.workspaceSettingsLink.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        Label sep = new Label(parent, 258);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        sep.setLayoutData((Object)gridData);
    }

    protected void refreshUI(UserPreferences prefs) {
        this.visibleDetectors.clear();
        this.effortViewer.setSelection((ISelection)new StructuredSelection((Object)Effort.getEffort(prefs.getEffort())), true);
        this.detectorTab.refreshUI(prefs);
        this.filterFilesTab.refreshUI(prefs);
        this.reportConfigurationTab.refreshUI(prefs);
    }

    private Link createLink(Composite composite, String text) {
        Link link = new Link(composite, 0);
        link.setFont(composite.getFont());
        link.setText("<A>" + text + "</A>");
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String id = "FindBugsPreferencePage";
                int result = PreferencesUtil.createPreferenceDialogOn((Shell)FindbugsPropertyPage.this.getShell(), (String)id, (String[])new String[]{id}, null).open();
                if (result == 0) {
                    FindbugsPropertyPage.this.refreshUI(FindbugsPropertyPage.this.loadPreferences(null));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        link.setToolTipText("Configure global workspace (user) settings");
        return link;
    }

    protected void setProjectEnabled(boolean selection) {
        if (this.enableProjectCheck != null) {
            this.workspaceSettingsLink.setEnabled(!selection);
        }
        this.detectorTab.setEnabled(selection);
        this.filterFilesTab.setEnabled(selection);
        this.reportConfigurationTab.setEnabled(selection);
        this.restoreDefaultsButton.setEnabled(selection);
        this.effortViewer.getCombo().setEnabled(selection);
    }

    protected static Button createLabeledCheck(String title, String tooltip, boolean value, Composite defPanel) {
        Button fButton = new Button(defPanel, 16416);
        GridData data = new GridData();
        fButton.setLayoutData((Object)data);
        fButton.setText(title);
        fButton.setSelection(value);
        fButton.setToolTipText(tooltip);
        return fButton;
    }

    private void restoreDefaultSettings() {
        if (this.getProject() != null) {
            this.chkEnableFindBugs.setSelection(false);
            this.chkRunAtFullBuild.setEnabled(false);
        } else {
            FindBugsPreferenceInitializer.restoreDefaults((IPreferenceStore)this.workspaceStore);
        }
        this.currentUserPreferences = FindBugsPreferenceInitializer.createDefaultUserPreferences();
        this.refreshUI(this.currentUserPreferences);
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public boolean performOk() {
        boolean reporterSettingsChanged;
        if (!this.currentUserPreferences.equals(this.origUserPreferences) && (this.getProject() == null || this.enableProjectCheck.getSelection())) {
            try {
                FindbugsPlugin.saveUserPreferences(this.getProject(), this.currentUserPreferences);
            }
            catch (CoreException e) {
                FindbugsPlugin.getDefault().logException(e, "Could not store FindBugs preferences for project");
            }
        }
        boolean analysisSettingsChanged = this.areAnalysisPrefsChanged(this.currentUserPreferences, this.origUserPreferences);
        boolean needRedisplayMarkers = reporterSettingsChanged = !this.currentUserPreferences.getFilterSettings().equals(this.origUserPreferences.getFilterSettings());
        if (this.getProject() != null) {
            boolean builderEnabled = this.chkEnableFindBugs.getSelection();
            if (!this.natureEnabled && builderEnabled) {
                this.addNature();
            } else if (this.natureEnabled && !builderEnabled) {
                this.removeNature();
            }
            builderEnabled &= this.chkRunAtFullBuild.getSelection();
            boolean newSelection = this.enableProjectCheck.getSelection();
            if (this.projectPropsInitiallyEnabled != newSelection) {
                analysisSettingsChanged = true;
                FindbugsPlugin.setProjectSettingsEnabled(this.project, this.getPreferenceStore(), newSelection);
            }
            if (analysisSettingsChanged) {
                if (builderEnabled) {
                    this.runFindbugsBuilder();
                    needRedisplayMarkers = false;
                } else if (!this.getPreferenceStore().getBoolean("dontRemindAboutFullBuild")) {
                    this.remindAboutFullBuild();
                }
            }
        }
        if (needRedisplayMarkers) {
            this.redisplayMarkers();
        }
        return true;
    }

    protected void remindAboutFullBuild() {
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openInformation((Shell)this.getShell(), (String)"Full FindBugs build required", (String)"FindBugs analysis settings are changed.\nConsider to execute FindBugs analysis again.", (String)"Do not show this warning again", (boolean)false, null, null);
        this.getPreferenceStore().setValue("dontRemindAboutFullBuild", dialog.getToggleState());
    }

    private void redisplayMarkers() {
        if (this.project != null) {
            MarkerUtil.redisplayMarkers(JavaCore.create((IProject)this.project));
        } else {
            IProject[] projects;
            for (IProject aProject : projects = ResourcesPlugin.getWorkspace().getRoot().getProjects()) {
                if (!ProjectUtilities.hasFindBugsNature(aProject)) continue;
                MarkerUtil.redisplayMarkers(JavaCore.create((IProject)aProject));
            }
        }
    }

    private boolean areAnalysisPrefsChanged(UserPreferences pref1, UserPreferences pref2) {
        String effort2;
        String effort1 = "" + pref1.getEffort();
        return !effort1.equals(effort2 = pref2.getEffort()) || this.isDetectorConfigurationChanged(pref1, pref2) || !((Object)pref1.getExcludeBugsFiles()).equals(pref2.getExcludeBugsFiles()) || !((Object)pref1.getExcludeFilterFiles()).equals(pref2.getExcludeFilterFiles()) || !((Object)pref1.getIncludeFilterFiles()).equals(pref2.getIncludeFilterFiles());
    }

    boolean isDetectorConfigurationChanged(UserPreferences pref1, UserPreferences pref2) {
        Iterator<DetectorFactory> iterator = DetectorFactoryCollection.instance().factoryIterator();
        while (iterator.hasNext()) {
            DetectorFactory factory = iterator.next();
            if (factory.isHidden() && !this.detectorTab.isHiddenVisible() || !(pref1.isDetectorEnabled(factory) ^ pref2.isDetectorEnabled(factory))) continue;
            return true;
        }
        return false;
    }

    protected IProject getProject() {
        return this.project;
    }

    private void runFindbugsBuilder() {
        if (this.getProject() == null) {
            return;
        }
        StructuredSelection selection = new StructuredSelection((Object)this.getProject());
        FindBugsAction action = new FindBugsAction();
        action.selectionChanged(null, (ISelection)selection);
        action.run(null);
    }

    private void addNature() {
        NatureWorker worker = new NatureWorker(true);
        worker.scheduleInteractive();
    }

    private void removeNature() {
        NatureWorker worker = new NatureWorker(false);
        worker.scheduleInteractive();
    }

    protected static String getMessage(String key) {
        return FindbugsPlugin.getDefault().getMessage(key);
    }

    protected UserPreferences getCurrentUserPreferences() {
        return this.currentUserPreferences;
    }

    UserPreferences getOriginalUserPreferences() {
        return this.origUserPreferences;
    }

    Map<DetectorFactory, Boolean> getVisibleDetectors() {
        return this.visibleDetectors;
    }

    DetectorConfigurationTab getDetectorTab() {
        return this.detectorTab;
    }

    public void setErrorMessage(String newMessage) {
        this.setValid(newMessage == null);
        super.setErrorMessage(newMessage);
    }

    public void init(IWorkbench workbench) {
    }

    protected Button getChkEnableFindBugs() {
        return this.chkEnableFindBugs;
    }

    protected Button getEnableProjectCheck() {
        return this.enableProjectCheck;
    }

    protected ComboViewer getEffortViewer() {
        return this.effortViewer;
    }

    protected DetectorConfigurationTab createDetectorConfigurationTab(TabFolder parentTabFolder) {
        return new DetectorConfigurationTab(parentTabFolder, this, 0);
    }

    protected ReportConfigurationTab createReportConfigurationTab(TabFolder parentTabFolder) {
        return new ReportConfigurationTab(parentTabFolder, this, 0);
    }

    protected FilterFilesTab createFilterFilesTab(TabFolder parentTabFolder) {
        return new FilterFilesTab(parentTabFolder, this, 0);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Effort {
        MIN("min", "property.effortmin"),
        DEFAULT("default", "property.effortdefault"),
        MAX("max", "property.effortmax");

        private final String effortLevel;
        private final String message;

        private Effort(String level, String messageKey) {
            this.effortLevel = level;
            this.message = FindbugsPropertyPage.getMessage(messageKey);
        }

        public String toString() {
            return this.message;
        }

        public String getEffortLevel() {
            return this.effortLevel;
        }

        static Effort getEffort(String level) {
            Effort[] efforts;
            for (Effort effort : efforts = Effort.values()) {
                if (!effort.getEffortLevel().equals(level)) continue;
                return effort;
            }
            return DEFAULT;
        }
    }

    private final class NatureWorker
    extends FindBugsJob {
        private boolean add;

        public NatureWorker(boolean add) {
            super((add ? "Adding FindBugs nature to " : "Removing FindBugs nature from ") + FindbugsPropertyPage.this.getProject(), FindbugsPropertyPage.this.getProject());
            this.add = true;
            this.add = add;
            this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }

        protected void runWithProgress(IProgressMonitor monitor) throws CoreException {
            if (this.add) {
                ProjectUtilities.addFindBugsNature(FindbugsPropertyPage.this.getProject(), monitor);
            } else {
                ProjectUtilities.removeFindBugsNature(FindbugsPropertyPage.this.getProject(), monitor);
            }
        }
    }
}

