/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.properties;

import name.herlin.command.CommandException;
import net.sourceforge.pmd.RuleSet;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.cmd.BuildProjectCommand;
import net.sourceforge.pmd.eclipse.runtime.properties.IProjectProperties;
import net.sourceforge.pmd.eclipse.runtime.properties.PropertiesException;
import net.sourceforge.pmd.eclipse.ui.properties.PMDPropertyPageBean;
import net.sourceforge.pmd.eclipse.ui.properties.UpdateProjectPropertiesCmd;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.IWorkingSetSelectionDialog;

public class PMDPropertyPageController {
    private static final Logger log;
    private final Shell shell;
    private IProject project;
    private PMDPropertyPageBean propertyPageBean;
    private boolean pmdAlreadyActivated;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.pmd.eclipse.ui.properties.PMDPropertyPageController");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public PMDPropertyPageController(Shell shell) {
        this.shell = shell;
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject iProject) {
        if (iProject.isAccessible()) {
            this.project = iProject;
        } else {
            log.warn((Object)"Couldn't accept project because it is not accessible.");
        }
    }

    public PMDPropertyPageBean getPropertyPageBean() {
        if (this.propertyPageBean == null) {
            log.debug((Object)"Building a property page bean");
            try {
                IProjectProperties iProjectProperties = PMDPlugin.getDefault().loadProjectProperties(this.project);
                this.propertyPageBean = new PMDPropertyPageBean();
                this.propertyPageBean.setPmdEnabled(iProjectProperties.isPmdEnabled());
                this.propertyPageBean.setProjectWorkingSet(iProjectProperties.getProjectWorkingSet());
                this.propertyPageBean.setProjectRuleSet(iProjectProperties.getProjectRuleSet());
                this.propertyPageBean.setRuleSetStoredInProject(iProjectProperties.isRuleSetStoredInProject());
                this.propertyPageBean.setRuleSetFile(iProjectProperties.getRuleSetFile());
                this.propertyPageBean.setIncludeDerivedFiles(iProjectProperties.isIncludeDerivedFiles());
                this.propertyPageBean.setViolationsAsErrors(iProjectProperties.violationsAsErrors());
                this.pmdAlreadyActivated = iProjectProperties.isPmdEnabled();
            }
            catch (PropertiesException propertiesException) {
                PMDPlugin.getDefault().showError(propertiesException.getMessage(), propertiesException);
            }
        }
        return this.propertyPageBean;
    }

    public RuleSet getAvailableRules() {
        return PMDPlugin.getDefault().getPreferencesManager().getRuleSet();
    }

    public boolean performOk() {
        try {
            this.checkProjectRuleSetFile();
            UpdateProjectPropertiesCmd updateProjectPropertiesCmd = new UpdateProjectPropertiesCmd();
            updateProjectPropertiesCmd.setProject(this.project);
            updateProjectPropertiesCmd.setPmdEnabled(this.propertyPageBean.isPmdEnabled());
            updateProjectPropertiesCmd.setProjectWorkingSet(this.propertyPageBean.getProjectWorkingSet());
            updateProjectPropertiesCmd.setProjectRuleSet(this.propertyPageBean.getProjectRuleSet());
            updateProjectPropertiesCmd.setRuleSetStoredInProject(this.propertyPageBean.isRuleSetStoredInProject());
            updateProjectPropertiesCmd.setRuleSetFile(this.propertyPageBean.getRuleSetFile());
            updateProjectPropertiesCmd.setIncludeDerivedFiles(this.propertyPageBean.isIncludeDerivedFiles());
            updateProjectPropertiesCmd.setViolationsAsErrors(this.propertyPageBean.violationsAsErrors());
            updateProjectPropertiesCmd.setUserInitiated(true);
            updateProjectPropertiesCmd.performExecute();
            log.debug((Object)"Updating command terminated, checking whether the project need to be rebuilt");
            if (this.pmdAlreadyActivated && updateProjectPropertiesCmd.isNeedRebuild()) {
                this.rebuildProject();
            }
        }
        catch (PropertiesException propertiesException) {
            PMDPlugin.getDefault().showError(propertiesException.getMessage(), propertiesException);
        }
        catch (CommandException commandException) {
            PMDPlugin.getDefault().showError(commandException.getMessage(), commandException);
        }
        return true;
    }

    public IWorkingSet selectWorkingSet(IWorkingSet iWorkingSet) {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkingSetManager iWorkingSetManager = iWorkbench.getWorkingSetManager();
        IWorkingSetSelectionDialog iWorkingSetSelectionDialog = iWorkingSetManager.createWorkingSetSelectionDialog(this.shell, false);
        IWorkingSet iWorkingSet2 = null;
        if (iWorkingSet != null) {
            iWorkingSetSelectionDialog.setSelection(new IWorkingSet[]{iWorkingSet});
        }
        if (iWorkingSetSelectionDialog.open() == 0) {
            if (iWorkingSetSelectionDialog.getSelection().length == 0) {
                log.info((Object)"Deselect working set");
            } else {
                iWorkingSet2 = iWorkingSetSelectionDialog.getSelection()[0];
                log.info((Object)("Working set " + iWorkingSet2.getName() + " selected"));
            }
        }
        return iWorkingSet2;
    }

    private void rebuildProject() {
        boolean bl = MessageDialog.openQuestion((Shell)this.shell, (String)this.getMessage("message.question.title"), (String)this.getMessage("message.question.rebuild_project"));
        if (bl) {
            log.info((Object)("Full rebuild of the project " + this.project.getName()));
            try {
                BuildProjectCommand buildProjectCommand = new BuildProjectCommand();
                buildProjectCommand.setProject(this.project);
                buildProjectCommand.setUserInitiated(true);
                buildProjectCommand.performExecute();
            }
            catch (CommandException commandException) {
                PMDPlugin.getDefault().showError(commandException.getMessage(), commandException);
            }
        }
    }

    private void checkProjectRuleSetFile() throws PropertiesException {
        IProjectProperties iProjectProperties;
        if (this.propertyPageBean.isRuleSetStoredInProject() && !(iProjectProperties = PMDPlugin.getDefault().loadProjectProperties(this.project)).isRuleSetFileExist()) {
            this.createDefaultRuleSetFile();
        }
    }

    private void createDefaultRuleSetFile() throws PropertiesException {
        boolean bl = MessageDialog.openQuestion((Shell)this.shell, (String)this.getMessage("message.question.title"), (String)this.getMessage("message.question.create_ruleset_file"));
        if (bl) {
            IProjectProperties iProjectProperties = PMDPlugin.getDefault().loadProjectProperties(this.project);
            iProjectProperties.createDefaultRuleSetFile();
        } else {
            this.propertyPageBean.setRuleSetStoredInProject(false);
        }
    }

    protected String getMessage(String string) {
        return PMDPlugin.getDefault().getStringTable().getString(string);
    }
}

