/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.io;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.io.FileOutput;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public abstract class IO {
    public static void writeFile(IFile file, FileOutput output, IProgressMonitor monitor) throws CoreException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            output.writeFile(bos);
            ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
            if (!file.exists()) {
                file.create((InputStream)bis, true, monitor);
            } else {
                file.setContents((InputStream)bis, true, false, monitor);
            }
        }
        catch (IOException e) {
            IStatus status = FindbugsPlugin.createErrorStatus("Exception while " + output.getTaskDescription(), e);
            throw new CoreException(status);
        }
    }

    public static void writeFile(File file, FileOutput output, IProgressMonitor monitor) throws CoreException {
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            if (monitor != null) {
                monitor.subTask("writing data to " + file.getName());
            }
            output.writeFile(bout);
            bout.flush();
        }
        catch (IOException e) {
            try {
                IStatus status = FindbugsPlugin.createErrorStatus("Exception while " + output.getTaskDescription(), e);
                throw new CoreException(status);
            }
            catch (Throwable throwable) {
                IO.closeQuietly(fout);
                throw throwable;
            }
        }
        IO.closeQuietly(fout);
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

