/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view.explorer;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.marker.FindBugsMarker;
import de.tobject.findbugs.view.explorer.BugGroup;
import java.text.Collator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class BugPrioritySorter
extends ViewerSorter {
    public BugPrioritySorter() {
    }

    public BugPrioritySorter(Collator collator) {
        super(collator);
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int cat2;
        int cat1 = this.category(e1);
        if (cat1 != (cat2 = this.category(e2))) {
            return cat1 - cat2;
        }
        if (e1 instanceof IMarker && e2 instanceof IMarker) {
            return BugPrioritySorter.compareMarkers((IMarker)e1, (IMarker)e2);
        }
        if (e1 instanceof BugGroup && e2 instanceof BugGroup) {
            return BugPrioritySorter.compareGroups((BugGroup)e1, (BugGroup)e2);
        }
        return super.compare(viewer, e1, e2);
    }

    public int category(Object element) {
        if (element instanceof IMarker) {
            return 1;
        }
        if (element instanceof BugGroup) {
            return 5;
        }
        return super.category(element);
    }

    static int compareGroups(BugGroup m1, BugGroup m2) {
        int result = m1.getPriority().compareTo(m2.getPriority());
        if (result == 0) {
            return m1.getShortDescription().compareToIgnoreCase(m2.getShortDescription());
        }
        return result;
    }

    static int compareMarkers(IMarker m1, IMarker m2) {
        if (m1 == null || m2 == null || !m1.exists() || !m2.exists()) {
            return 0;
        }
        try {
            int ordinal1 = FindBugsMarker.Priority.ordinal(m1.getType());
            int ordinal2 = FindBugsMarker.Priority.ordinal(m2.getType());
            int result = ordinal1 - ordinal2;
            if (result != 0) {
                return result;
            }
            String a1 = m1.getAttribute("message", "");
            String a2 = m2.getAttribute("message", "");
            return a1.compareToIgnoreCase(a2);
        }
        catch (CoreException e) {
            FindbugsPlugin.getDefault().logException(e, "Sort error");
            return 0;
        }
    }
}

