/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.maven.facets;

import javax.enterprise.context.Dependent;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.jboss.forge.maven.MavenCoreFacet;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.dependencies.DependencyBuilder;
import org.jboss.forge.project.facets.BaseFacet;
import org.jboss.forge.project.facets.MetadataFacet;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.RequiresFacet;

@Dependent
@Alias(value="forge.maven.MetadataFacet")
@RequiresFacet(value={MavenCoreFacet.class})
public class MavenMetadataFacet
extends BaseFacet
implements MetadataFacet {
    private Project project;

    public String getProjectName() {
        return ((MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class)).getPartialProjectBuildingResult().getProject().getArtifactId();
    }

    public String getProjectVersion() {
        return ((MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class)).getPartialProjectBuildingResult().getProject().getVersion();
    }

    public Project getProject() {
        return this.project;
    }

    public void setProject(Project project) {
        this.project = project;
    }

    public boolean install() {
        return true;
    }

    public boolean isInstalled() {
        return this.project.hasFacet(MavenCoreFacet.class);
    }

    public void setProjectName(String name) {
        MavenCoreFacet mvn = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        Model pom = mvn.getPOM();
        pom.setArtifactId(name);
        mvn.setPOM(pom);
    }

    public void setTopLevelPackage(String groupId) {
        MavenCoreFacet mvn = (MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class);
        Model pom = mvn.getPOM();
        pom.setGroupId(groupId);
        mvn.setPOM(pom);
    }

    public String getTopLevelPackage() {
        Parent parent;
        String groupId = ((MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class)).getPOM().getGroupId();
        if (groupId == null && (parent = ((MavenCoreFacet)this.project.getFacet(MavenCoreFacet.class)).getPOM().getParent()) != null) {
            groupId = parent.getGroupId();
        }
        return groupId;
    }

    public Dependency getOutputDependency() {
        return DependencyBuilder.create().setGroupId(this.getTopLevelPackage()).setArtifactId(this.getProjectName()).setVersion(this.getProjectVersion());
    }
}

