package org.jboss.tools.birt.servlet;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.EngineConstants;
import org.eclipse.birt.report.engine.api.HTMLRenderOption;
import org.eclipse.birt.report.engine.api.HTMLServerImageHandler;
import org.eclipse.birt.report.engine.api.IGetParameterDefinitionTask;
import org.eclipse.birt.report.engine.api.IParameterDefnBase;
import org.eclipse.birt.report.engine.api.IReportEngine;
import org.eclipse.birt.report.engine.api.IReportRunnable;
import org.eclipse.birt.report.engine.api.IRunAndRenderTask;
import org.eclipse.birt.report.engine.api.IRunnable;
import org.eclipse.birt.report.engine.api.IScalarParameterDefn;

public class JBossBirtServlet extends HttpServlet {

	private static final long serialVersionUID = 1L;
	private IReportEngine birtReportEngine = null;
	protected static Logger logger = Logger.getLogger("org.jboss.tools.birt");

	public JBossBirtServlet() {
		super();
	}

	/**
	 * Destruction of the servlet.
	 */
	public void destroy() {
		super.destroy();
		// FIXME
		BirtEngine.destroyBirtEngine();
	}

	/**
	 * The doGet method of the servlet.
	 * 
	 * 
	 */
	public void doGet(HttpServletRequest req, HttpServletResponse resp)
			throws ServletException, IOException {

		//resp.setContentType("text/html");
		String reportName = req.getParameter("__report");
		String embeddable = req.getParameter("__embeddable");
		String masterpage = req.getParameter("__masterpage");
		String localeParam = req.getParameter("__locale");
		Locale locale = getLocaleFromString(localeParam);
		ServletContext sc = req.getSession().getServletContext();
		if (req.getCharacterEncoding() == null) {
			req.setCharacterEncoding("UTF-8");
		}
		this.birtReportEngine = BirtEngine.getBirtEngine(sc);

		IReportRunnable design;
		try {
			EngineConfig config = birtReportEngine.getConfig();
			HashMap appContext = (HashMap) config.getAppContext();
			appContext.put(EngineConstants.APPCONTEXT_CLASSLOADER_KEY, JBossBirtServlet.class
					.getClassLoader());
			appContext.put(EngineConstants.APPCONTEXT_BIRT_VIEWER_HTTPSERVET_REQUEST, req); 
			config.setAppContext(appContext);
			
			// Open report design
			design = birtReportEngine.openReportDesign(sc.getRealPath("/")
					+ reportName);
			// create task to run and render report
			IRunAndRenderTask task = birtReportEngine
					.createRunAndRenderTask(design);
			// set output options
			HTMLRenderOption options = new HTMLRenderOption();
			// set the image handler to a HTMLServerImageHandler if you plan on
			// using the base image url.
			options.setImageHandler(new HTMLServerImageHandler());
			options.setOutputFormat(HTMLRenderOption.OUTPUT_FORMAT_HTML);
			if ("true".equals(embeddable)) {
				options.setEmbeddable(true);
			}
			if ("false".equals(masterpage)) {
				options.setMasterPageContent(false);
			}
			if (locale != null) {
				task.setLocale(locale);
			}
			options.setOutputStream(resp.getOutputStream());
			
			options.setBaseImageURL(req.getContextPath() + "/images");
			options.setImageDirectory(sc.getRealPath("/images"));
			task.setRenderOption(options);

			// add parameters
			Map parameterValues = evaluateParameterValues(design, req);
			task.setParameterValues(parameterValues);

			// run report
			task.run();
			task.close();
		} catch (Exception e) {
			e.printStackTrace();
			throw new ServletException(e);
		}
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {

		doGet(request, response);
	}

	private Map evaluateParameterValues(IReportRunnable runnable,
			HttpServletRequest req) {
		Map<String, Object> inputValues = new HashMap<String, Object>();
		IGetParameterDefinitionTask task = this.birtReportEngine
				.createGetParameterDefinitionTask((IRunnable) runnable);
		Collection paramDefns = task.getParameterDefns(false);
		Iterator iter = paramDefns.iterator();
		while (iter.hasNext()) {
			// now only support scalar parameter
			IParameterDefnBase pBase = (IParameterDefnBase) iter.next();
			if (pBase instanceof IScalarParameterDefn) {
				IScalarParameterDefn paramDefn = (IScalarParameterDefn) pBase;
				String paramName = paramDefn.getName();
				String inputValue = req.getParameter(paramName);
				int paramType = paramDefn.getDataType();
				try {
					Object paramValue = stringToObject(paramType, inputValue);
					if (paramValue != null) {
						inputValues.put(paramName, paramValue);
					}
				} catch (BirtException ex) {
					logger.log(Level.SEVERE, "the value of parameter "
							+ paramName + " is invalid", ex);
				}
			}
		}
		return inputValues;
	}

	protected Object stringToObject(int type, String value)
			throws BirtException {
		if (value == null) {
			return null;
		}
		switch (type) {
		case IScalarParameterDefn.TYPE_BOOLEAN:
			return DataTypeUtil.toBoolean(value);

		case IScalarParameterDefn.TYPE_DATE_TIME:
			return DataTypeUtil.toDate(value);

		case IScalarParameterDefn.TYPE_DATE:
			return DataTypeUtil.toSqlDate(value);

		case IScalarParameterDefn.TYPE_TIME:
			return DataTypeUtil.toSqlTime(value);

		case IScalarParameterDefn.TYPE_DECIMAL:
			return DataTypeUtil.toBigDecimal(value);

		case IScalarParameterDefn.TYPE_FLOAT:
			return DataTypeUtil.toDouble(value);

		case IScalarParameterDefn.TYPE_STRING:
			return DataTypeUtil.toString(value);

		case IScalarParameterDefn.TYPE_INTEGER:
			return DataTypeUtil.toInteger(value);

		case IScalarParameterDefn.TYPE_ANY:
			return DataTypeUtil.toString(value);
		}
		return null;
	}

	/**
	 * Initialization of the servlet.
	 * 
	 * 
	 * @throws ServletException
	 *             if an error occure
	 */
	public void init() throws ServletException {
		BirtEngine.initBirtConfig();

	}

	private static Locale getLocaleFromString(String locale) {
		if (locale == null || locale.length() <= 0) {
			return null;
		}
		String[] sp = locale.split("_"); //$NON-NLS-1$
		if (sp.length == 1) {
			// language
			return new Locale(locale);
		} else if (sp.length == 2) {
			// language, country
			return new Locale(sp[0], sp[1]);
		} else {
			// language, country, variant
			return new Locale(sp[0], sp[1], sp[2]);
		}
	}
}
