/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.navigator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.markers.XMarkerManager;
import org.jboss.tools.common.model.ui.ModelUIImages;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.navigator.DecoratingLabelProviderExt;
import org.jboss.tools.common.model.ui.navigator.ErrorImageDescriptor;

public class LabelDecoratorImpl
implements ILabelDecorator {
    public static Image emptyImage = ModelUIImages.getImage("empty_co.gif");
    public static Image errorImage = ModelUIImages.getImage("error_co.gif");
    public static Image warningImage = ModelUIImages.getImage("warning_co.gif");
    List<ILabelProviderListener> listeners = new ArrayList<ILabelProviderListener>();
    static Map<Image, Image> errorImages = new HashMap<Image, Image>();
    static Map<Image, Image> warningImages = new HashMap<Image, Image>();
    static Set<String> missingImages = new HashSet<String>();

    public static ILabelProvider decorateLabelProvider(ILabelProvider provider) {
        LabelDecoratorImpl decorator = new LabelDecoratorImpl();
        return new DecoratingLabelProviderExt(provider, decorator);
    }

    public Image decorateImage(Image image, Object element) {
        int severity = this.getErrorState(element);
        if (image == null && element instanceof XModelObject && severity > 0) {
            String entity = ((XModelObject)element).getModelEntity().getName();
            if (!missingImages.contains(entity)) {
                missingImages.add(entity);
                ModelUIPlugin.getDefault().logWarning("Problem in " + LabelDecoratorImpl.class.getName() + ": Cannot find icon for entity " + entity);
            }
        } else {
            if (severity == 2) {
                return this.getErrorImage(image);
            }
            if (severity == 1) {
                return this.getWarningImage(image);
            }
        }
        return image;
    }

    private Image getErrorImage(Image image) {
        Image i = errorImages.get(image);
        if (i == null || i.isDisposed()) {
            ErrorImageDescriptor d = new ErrorImageDescriptor(image, 2);
            i = d.createImage();
            this.registerImage(i);
            errorImages.put(image, i);
        }
        return i;
    }

    private Image getWarningImage(Image image) {
        Image i = warningImages.get(image);
        if (i == null || i.isDisposed()) {
            ErrorImageDescriptor d = new ErrorImageDescriptor(image, 1);
            i = d.createImage();
            this.registerImage(i);
            warningImages.put(image, i);
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerImage(Image i) {
        ImageRegistry registry = ModelUIPlugin.getDefault().getImageRegistry();
        String key = "" + Math.random();
        ImageRegistry imageRegistry = registry;
        synchronized (imageRegistry) {
            registry.remove(key);
            registry.put(key, i);
        }
    }

    int getErrorState(Object element) {
        if (!(element instanceof XModelObject)) {
            return 0;
        }
        return XMarkerManager.getInstance().getErrorState((XModelObject)element);
    }

    public String decorateText(String text, Object element) {
        return text;
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }
}

