/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.render.template.compiler;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.mvel2.CompileException;
import org.mvel2.ParserContext;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.res.CodeNode;
import org.mvel2.templates.res.CommentNode;
import org.mvel2.templates.res.CompiledCodeNode;
import org.mvel2.templates.res.CompiledDeclareNode;
import org.mvel2.templates.res.CompiledEvalNode;
import org.mvel2.templates.res.CompiledExpressionNode;
import org.mvel2.templates.res.CompiledForEachNode;
import org.mvel2.templates.res.CompiledIfNode;
import org.mvel2.templates.res.CompiledNamedIncludeNode;
import org.mvel2.templates.res.CompiledTerminalExpressionNode;
import org.mvel2.templates.res.DeclareNode;
import org.mvel2.templates.res.EndNode;
import org.mvel2.templates.res.EvalNode;
import org.mvel2.templates.res.ExpressionNode;
import org.mvel2.templates.res.ForEachNode;
import org.mvel2.templates.res.IfNode;
import org.mvel2.templates.res.NamedIncludeNode;
import org.mvel2.templates.res.Node;
import org.mvel2.templates.res.TerminalExpressionNode;
import org.mvel2.templates.res.TerminalNode;
import org.mvel2.templates.res.TextNode;
import org.mvel2.templates.util.TemplateTools;
import org.mvel2.util.ExecutionStack;
import org.mvel2.util.ParseTools;

public class CustomTemplateCompiler {
    private char[] template;
    private final int length;
    private int start;
    private int cursor;
    private int lastTextRangeEnding;
    private int line;
    private int colStart;
    private boolean codeCache = false;
    private Map<String, Class<? extends Node>> customNodes;
    private ParserContext parserContext;
    private static final Map<String, Integer> OPCODES = new HashMap<String, Integer>();

    public CompiledTemplate compile() {
        return new CompiledTemplate(this.template, this.compileFrom(null, new ExecutionStack()));
    }

    public Node compileFrom(Node root, ExecutionStack stack) {
        this.line = 1;
        Node n = root;
        if (root == null) {
            n = root = new TextNode(0, 0);
        }
        try {
            block20: while (this.cursor < this.length) {
                block2 : switch (this.template[this.cursor]) {
                    case '\n': {
                        ++this.line;
                        this.colStart = this.cursor + 1;
                        break;
                    }
                    case '$': 
                    case '@': {
                        if (this.isNext(this.template[this.cursor])) {
                            this.start = ++this.cursor;
                            n = this.markTextNode(n);
                            n.setEnd(n.getEnd() + 1);
                            this.lastTextRangeEnding = ++this.cursor;
                            this.start = this.cursor;
                            continue block20;
                        }
                        int x = this.captureOrbToken();
                        if (x == -1) break;
                        this.start = x;
                        String name = new String(this.capture());
                        Integer opcode = OPCODES.get(name);
                        switch (opcode == null ? 0 : opcode) {
                            case 1: {
                                this.markTextNode((Node)n).next = this.codeCache ? new CompiledIfNode(this.start, name, this.template, this.captureOrbInternal(), this.start, this.parserContext) : new IfNode(this.start, name, this.template, this.captureOrbInternal(), this.start);
                                n = this.markTextNode((Node)n).next;
                                stack.push((Object)this.markTextNode((Node)n).next);
                                n.setTerminus((Node)new TerminalNode());
                                break block2;
                            }
                            case 2: {
                                if (stack.isEmpty() || !(stack.peek() instanceof IfNode)) break block2;
                                IfNode last = (IfNode)stack.pop();
                                this.markTextNode((Node)n).next = last.getTerminus();
                                last.demarcate(last.getTerminus(), this.template);
                                n = this.codeCache ? new CompiledIfNode(this.start, name, this.template, this.captureOrbInternal(), this.start, this.parserContext) : new IfNode(this.start, name, this.template, this.captureOrbInternal(), this.start);
                                last.next = n;
                                n.setTerminus(last.getTerminus());
                                stack.push((Object)n);
                                break block2;
                            }
                            case 3: {
                                this.markTextNode((Node)n).next = this.codeCache ? new CompiledForEachNode(this.start, name, this.template, this.captureOrbInternal(), this.start, this.parserContext) : new ForEachNode(this.start, name, this.template, this.captureOrbInternal(), this.start);
                                n = this.markTextNode((Node)n).next;
                                stack.push((Object)this.markTextNode((Node)n).next);
                                n.setTerminus((Node)new TerminalNode());
                                break block2;
                            }
                            case 51: {
                                CompiledNamedIncludeNode compiledNamedIncludeNode;
                                Node node = this.markTextNode(n);
                                if (this.codeCache) {
                                    this.start = this.cursor + 1;
                                    compiledNamedIncludeNode = new CompiledNamedIncludeNode(this.start, name, this.template, this.captureOrbInternal(), this.start, this.parserContext);
                                } else {
                                    this.start = this.cursor + 1;
                                    compiledNamedIncludeNode = new NamedIncludeNode(this.start, name, this.template, this.captureOrbInternal(), this.start);
                                }
                                node.next = compiledNamedIncludeNode;
                                n = compiledNamedIncludeNode;
                                break block2;
                            }
                            case 53: {
                                CompiledCodeNode compiledCodeNode;
                                Node node = this.markTextNode(n);
                                if (this.codeCache) {
                                    this.start = this.cursor + 1;
                                    compiledCodeNode = new CompiledCodeNode(this.start, name, this.template, this.captureOrbInternal(), this.start, this.parserContext);
                                } else {
                                    this.start = this.cursor + 1;
                                    compiledCodeNode = new CodeNode(this.start, name, this.template, this.captureOrbInternal(), this.start);
                                }
                                node.next = compiledCodeNode;
                                n = compiledCodeNode;
                                break block2;
                            }
                            case 55: {
                                CompiledEvalNode compiledEvalNode;
                                Node node = this.markTextNode(n);
                                if (this.codeCache) {
                                    this.start = this.cursor + 1;
                                    compiledEvalNode = new CompiledEvalNode(this.start, name, this.template, this.captureOrbInternal(), this.start, this.parserContext);
                                } else {
                                    this.start = this.cursor + 1;
                                    compiledEvalNode = new EvalNode(this.start, name, this.template, this.captureOrbInternal(), this.start);
                                }
                                node.next = compiledEvalNode;
                                n = compiledEvalNode;
                                break block2;
                            }
                            case 52: {
                                this.start = this.cursor + 1;
                                n = this.markTextNode((Node)n).next = new CommentNode(this.start, name, this.template, this.captureOrbInternal(), this.start);
                                break block2;
                            }
                            case 54: {
                                CompiledDeclareNode compiledDeclareNode;
                                Node node = this.markTextNode(n);
                                if (this.codeCache) {
                                    this.start = this.cursor + 1;
                                    compiledDeclareNode = new CompiledDeclareNode(this.start, name, this.template, this.captureOrbInternal(), this.start, this.parserContext);
                                } else {
                                    this.start = this.cursor + 1;
                                    compiledDeclareNode = new DeclareNode(this.start, name, this.template, this.captureOrbInternal(), this.start);
                                }
                                node.next = compiledDeclareNode;
                                n = compiledDeclareNode;
                                stack.push((Object)compiledDeclareNode);
                                n.setTerminus((Node)new TerminalNode());
                                break block2;
                            }
                            case 10: {
                                n = this.markTextNode(n);
                                Node end = (Node)stack.pop();
                                Node terminal = end.getTerminus();
                                terminal.setCStart(this.captureOrbInternal());
                                this.lastTextRangeEnding = this.start;
                                terminal.setEnd(this.lastTextRangeEnding - 1);
                                terminal.calculateContents(this.template);
                                if (end.demarcate(terminal, this.template)) {
                                    n = n.next = terminal;
                                    break block2;
                                }
                                n = terminal;
                                break block2;
                            }
                        }
                        if (name.length() == 0) {
                            CompiledExpressionNode compiledExpressionNode;
                            Node node = this.markTextNode(n);
                            if (this.codeCache) {
                                this.start = this.cursor + 1;
                                compiledExpressionNode = new CompiledExpressionNode(this.start, name, this.template, this.captureOrbInternal(), this.start, this.parserContext);
                            } else {
                                this.start = this.cursor + 1;
                                compiledExpressionNode = new ExpressionNode(this.start, name, this.template, this.captureOrbInternal(), this.start);
                            }
                            node.next = compiledExpressionNode;
                            n = compiledExpressionNode;
                            break;
                        }
                        if (this.customNodes != null && this.customNodes.containsKey(name)) {
                            Class<? extends Node> customNode = this.customNodes.get(name);
                            try {
                                n = this.markTextNode((Node)n).next = customNode.newInstance();
                                this.markTextNode((Node)n).next.setBegin(this.start);
                                n.setName(name);
                                n.setCStart(this.captureOrbInternal());
                                this.start = this.cursor + 1;
                                n.setCEnd(this.start);
                                n.setEnd(n.getCEnd());
                                n.setContents(ParseTools.subset((char[])this.template, (int)n.getCStart(), (int)(n.getCEnd() - n.getCStart() - 1)));
                                if (!n.isOpenNode()) break;
                                stack.push((Object)n);
                                break;
                            }
                            catch (InstantiationException e) {
                                throw new RuntimeException("unable to instantiate custom node class: " + customNode.getName());
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException("unable to instantiate custom node class: " + customNode.getName());
                            }
                        }
                        throw new RuntimeException("unknown token type: " + name);
                    }
                }
                ++this.cursor;
            }
        }
        catch (RuntimeException e) {
            CompileException ce2;
            CompileException ce = new CompileException(e.getMessage(), this.template, this.cursor, (Throwable)e);
            ce.setExpr(this.template);
            if (e instanceof CompileException && (ce2 = (CompileException)e).getCursor() != -1) {
                ce.setCursor(ce2.getCursor());
                if (ce2.getColumn() == -1) {
                    ce.setColumn(ce.getCursor() - this.colStart);
                } else {
                    ce.setColumn(ce2.getColumn());
                }
            }
            ce.setLineNumber(this.line);
            throw ce;
        }
        if (!stack.isEmpty()) {
            CompileException ce = new CompileException("unclosed @" + ((Node)stack.peek()).getName() + "{} block. expected @end{}", this.template, this.cursor);
            ce.setColumn(this.cursor - this.colStart);
            ce.setLineNumber(this.line);
            throw ce;
        }
        if (this.start < this.template.length) {
            n = n.next = new TextNode(this.start, this.template.length);
        }
        n.next = new EndNode();
        n = root;
        while (n.getLength() == 0 && (n = n.getNext()) != null) {
        }
        if (n != null && n.getLength() == this.template.length - 1) {
            if (n instanceof ExpressionNode) {
                return this.codeCache ? new CompiledTerminalExpressionNode(n, this.parserContext) : new TerminalExpressionNode(n);
            }
            return n;
        }
        return root;
    }

    private boolean isNext(char c) {
        return this.cursor != this.length && this.template[this.cursor + 1] == c;
    }

    private int captureOrbToken() {
        int newStart = ++this.cursor;
        while (this.cursor != this.length && ParseTools.isIdentifierPart((int)this.template[this.cursor])) {
            ++this.cursor;
        }
        if (this.cursor != this.length && this.template[this.cursor] == '{') {
            return newStart;
        }
        return -1;
    }

    private int captureOrbInternal() {
        try {
            ParserContext pCtx = new ParserContext();
            this.start = this.cursor;
            this.cursor = ParseTools.balancedCaptureWithLineAccounting((char[])this.template, (int)this.start, (int)this.length, (char)'{', (ParserContext)pCtx);
            this.line += pCtx.getLineCount();
            int ret = this.start + 1;
            this.start = this.cursor + 1;
            return ret;
        }
        catch (CompileException e) {
            e.setLineNumber(this.line);
            e.setColumn(this.cursor - this.colStart + 1);
            throw e;
        }
    }

    private char[] capture() {
        char[] newChar = new char[this.cursor - this.start];
        for (int i = 0; i < newChar.length; ++i) {
            newChar[i] = this.template[i + this.start];
        }
        return newChar;
    }

    private Node markTextNode(Node n) {
        int s;
        int n2 = s = n.getEnd() > this.lastTextRangeEnding ? n.getEnd() : this.lastTextRangeEnding;
        if (s < this.start) {
            this.lastTextRangeEnding = this.start - 1;
            n.next = new TextNode(s, this.lastTextRangeEnding);
            return n.next;
        }
        return n;
    }

    public ParserContext getParserContext() {
        return this.parserContext;
    }

    public static CompiledTemplate compileTemplate(String template) {
        return new CustomTemplateCompiler((CharSequence)template, true, ParserContext.create()).compile();
    }

    public static CompiledTemplate compileTemplate(char[] template) {
        return new CustomTemplateCompiler(template, true, ParserContext.create()).compile();
    }

    public static CompiledTemplate compileTemplate(CharSequence template) {
        return new CustomTemplateCompiler(template, true, ParserContext.create()).compile();
    }

    public static CompiledTemplate compileTemplate(String template, ParserContext context) {
        return new CustomTemplateCompiler((CharSequence)template, true, context).compile();
    }

    public static CompiledTemplate compileTemplate(char[] template, ParserContext context) {
        return new CustomTemplateCompiler(template, true, context).compile();
    }

    public static CompiledTemplate compileTemplate(CharSequence template, ParserContext context) {
        return new CustomTemplateCompiler(template, true, context).compile();
    }

    public static CompiledTemplate compileTemplate(String template, Map<String, Class<? extends Node>> customNodes) {
        return new CustomTemplateCompiler(template, customNodes, true, ParserContext.create()).compile();
    }

    public static CompiledTemplate compileTemplate(char[] template, Map<String, Class<? extends Node>> customNodes) {
        return new CustomTemplateCompiler(template, customNodes, true, ParserContext.create()).compile();
    }

    public static CompiledTemplate compileTemplate(CharSequence template, Map<String, Class<? extends Node>> customNodes) {
        return new CustomTemplateCompiler(template, customNodes, true, ParserContext.create()).compile();
    }

    public static CompiledTemplate compileTemplate(String template, Map<String, Class<? extends Node>> customNodes, ParserContext context) {
        return new CustomTemplateCompiler(template, customNodes, true, context).compile();
    }

    public static CompiledTemplate compileTemplate(char[] template, Map<String, Class<? extends Node>> customNodes, ParserContext context) {
        return new CustomTemplateCompiler(template, customNodes, true, context).compile();
    }

    public static CompiledTemplate compileTemplate(CharSequence template, Map<String, Class<? extends Node>> customNodes, ParserContext context) {
        return new CustomTemplateCompiler(template, customNodes, true, context).compile();
    }

    public static CompiledTemplate compileTemplate(InputStream stream) {
        return CustomTemplateCompiler.compileTemplate(stream, ParserContext.create());
    }

    public static CompiledTemplate compileTemplate(InputStream stream, ParserContext context) {
        return CustomTemplateCompiler.compileTemplate(stream, null, context);
    }

    public static CompiledTemplate compileTemplate(InputStream stream, Map<String, Class<? extends Node>> customNodes) {
        return new CustomTemplateCompiler(TemplateTools.readStream((InputStream)stream), customNodes, true, ParserContext.create()).compile();
    }

    public static CompiledTemplate compileTemplate(InputStream stream, Map<String, Class<? extends Node>> customNodes, ParserContext context) {
        return new CustomTemplateCompiler(TemplateTools.readStream((InputStream)stream), customNodes, true, context).compile();
    }

    public static CompiledTemplate compileTemplate(File file) {
        return CustomTemplateCompiler.compileTemplate(file, ParserContext.create());
    }

    public static CompiledTemplate compileTemplate(File file, ParserContext context) {
        return CustomTemplateCompiler.compileTemplate(file, null, context);
    }

    public static CompiledTemplate compileTemplate(File file, Map<String, Class<? extends Node>> customNodes) {
        return new CustomTemplateCompiler(TemplateTools.readInFile((File)file), customNodes, true, ParserContext.create()).compile();
    }

    public static CompiledTemplate compileTemplate(File file, Map<String, Class<? extends Node>> customNodes, ParserContext context) {
        return new CustomTemplateCompiler(TemplateTools.readInFile((File)file), customNodes, true, context).compile();
    }

    public CustomTemplateCompiler(String template) {
        this.template = template.toCharArray();
        this.length = this.template.length;
    }

    public CustomTemplateCompiler(char[] template) {
        this.template = template;
        this.length = template.length;
    }

    public CustomTemplateCompiler(String template, boolean codeCache) {
        this.template = template.toCharArray();
        this.length = this.template.length;
        this.codeCache = codeCache;
    }

    public CustomTemplateCompiler(char[] template, boolean codeCache) {
        this.template = template;
        this.length = template.length;
        this.codeCache = codeCache;
    }

    public CustomTemplateCompiler(char[] template, boolean codeCache, ParserContext context) {
        this.template = template;
        this.length = template.length;
        this.codeCache = codeCache;
        this.parserContext = context;
    }

    public CustomTemplateCompiler(CharSequence sequence) {
        this.template = ((Object)sequence).toString().toCharArray();
        this.length = this.template.length;
    }

    public CustomTemplateCompiler(CharSequence sequence, boolean codeCache) {
        this.template = ((Object)sequence).toString().toCharArray();
        this.length = this.template.length;
        this.codeCache = codeCache;
    }

    public CustomTemplateCompiler(CharSequence sequence, boolean codeCache, ParserContext context) {
        this.template = ((Object)sequence).toString().toCharArray();
        this.length = this.template.length;
        this.codeCache = codeCache;
        this.parserContext = context;
    }

    public CustomTemplateCompiler(String template, Map<String, Class<? extends Node>> customNodes) {
        this.template = template.toCharArray();
        this.length = this.template.length;
        this.customNodes = customNodes;
    }

    public CustomTemplateCompiler(char[] template, Map<String, Class<? extends Node>> customNodes) {
        this.template = template;
        this.length = template.length;
        this.customNodes = customNodes;
    }

    public CustomTemplateCompiler(CharSequence sequence, Map<String, Class<? extends Node>> customNodes) {
        this.template = ((Object)sequence).toString().toCharArray();
        this.length = this.template.length;
        this.customNodes = customNodes;
    }

    public CustomTemplateCompiler(String template, Map<String, Class<? extends Node>> customNodes, boolean codeCache) {
        this.template = template.toCharArray();
        this.length = this.template.length;
        this.customNodes = customNodes;
        this.codeCache = codeCache;
    }

    public CustomTemplateCompiler(char[] template, Map<String, Class<? extends Node>> customNodes, boolean codeCache) {
        this.template = template;
        this.length = template.length;
        this.customNodes = customNodes;
        this.codeCache = codeCache;
    }

    public CustomTemplateCompiler(CharSequence sequence, Map<String, Class<? extends Node>> customNodes, boolean codeCache) {
        this.template = ((Object)sequence).toString().toCharArray();
        this.length = this.template.length;
        this.customNodes = customNodes;
        this.codeCache = codeCache;
    }

    public CustomTemplateCompiler(String template, Map<String, Class<? extends Node>> customNodes, boolean codeCache, ParserContext context) {
        this.template = template.toCharArray();
        this.length = this.template.length;
        this.customNodes = customNodes;
        this.codeCache = codeCache;
        this.parserContext = context;
    }

    public CustomTemplateCompiler(char[] template, Map<String, Class<? extends Node>> customNodes, boolean codeCache, ParserContext context) {
        this.template = template;
        this.length = template.length;
        this.customNodes = customNodes;
        this.codeCache = codeCache;
        this.parserContext = context;
    }

    public CustomTemplateCompiler(CharSequence sequence, Map<String, Class<? extends Node>> customNodes, boolean codeCache, ParserContext context) {
        this.template = ((Object)sequence).toString().toCharArray();
        this.length = this.template.length;
        this.customNodes = customNodes;
        this.codeCache = codeCache;
        this.parserContext = context;
    }

    static {
        OPCODES.put("if", 1);
        OPCODES.put("else", 2);
        OPCODES.put("elseif", 2);
        OPCODES.put("end", 10);
        OPCODES.put("foreach", 3);
        OPCODES.put("includeNamed", 51);
        OPCODES.put("include", 50);
        OPCODES.put("comment", 52);
        OPCODES.put("code", 53);
        OPCODES.put("eval", 55);
        OPCODES.put("declare", 54);
        OPCODES.put("stop", 70);
    }
}

