/*
 * Decompiled with CFR 0.152.
 */
package jline.console;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Operation {
    UNKNOWN(-99),
    MOVE_TO_BEG(-1),
    MOVE_TO_END(-3),
    PREV_CHAR(-4),
    NEWLINE(-6),
    KILL_LINE(-7),
    CLEAR_SCREEN(-8),
    NEXT_HISTORY(-9),
    PREV_HISTORY(-11),
    REDISPLAY(-13),
    KILL_LINE_PREV(-15),
    DELETE_PREV_WORD(-16),
    NEXT_CHAR(-19),
    REPEAT_PREV_CHAR(-20),
    SEARCH_PREV(-21),
    REPEAT_NEXT_CHAR(-24),
    SEARCH_NEXT(-25),
    PREV_SPACE_WORD(-27),
    TO_END_WORD(-29),
    REPEAT_SEARCH_PREV(-34),
    PASTE_PREV(-36),
    REPLACE_MODE(-37),
    SUBSTITUTE_LINE(-38),
    TO_PREV_CHAR(-39),
    NEXT_SPACE_WORD(-40),
    DELETE_PREV_CHAR(-41),
    ADD(-42),
    PREV_WORD(-43),
    CHANGE_META(-44),
    DELETE_META(-45),
    END_WORD(-46),
    INSERT(-48),
    REPEAT_SEARCH_NEXT(-49),
    PASTE_NEXT(-50),
    REPLACE_CHAR(-51),
    SUBSTITUTE_CHAR(-52),
    TO_NEXT_CHAR(-53),
    UNDO(-54),
    NEXT_WORD(-55),
    DELETE_NEXT_CHAR(-56),
    CHANGE_CASE(-57),
    COMPLETE(-58),
    EXIT(-59),
    PASTE(-60),
    START_OF_HISTORY(-61),
    END_OF_HISTORY(-62),
    CLEAR_LINE(-63),
    ABORT(-64);

    public final short code;
    private static final Map<Short, Operation> codes;

    private Operation(int code) {
        this.code = (short)code;
    }

    public static Operation valueOf(int code) {
        return codes.get((short)code);
    }

    static {
        HashMap<Short, Operation> map = new HashMap<Short, Operation>();
        for (Operation op : Operation.values()) {
            map.put(op.code, op);
        }
        codes = map;
    }
}

