/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.handlers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.HandlerEvent;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.menus.UIElement;
import org.jboss.tools.jst.jsp.JspEditorPlugin;
import org.jboss.tools.jst.jsp.jspeditor.JSPMultiPageEditor;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.VpeController;
import org.jboss.tools.vpe.handlers.VisualPartAbstractHandler;
import org.jboss.tools.vpe.messages.VpeUIMessages;

public class RotateEditorsHandler
extends VisualPartAbstractHandler {
    public static final String COMMAND_ID = "org.jboss.tools.vpe.commands.rotateEditorsCommand";
    private static List<String> layoutValues;
    private static Map<String, String> layoutIcons;
    private static Map<String, String> layoutNamesAndTooltips;
    private static final String ICON_ORIENTATION_SOURCE_LEFT = "icons/source_left.gif";
    private static final String ICON_ORIENTATION_SOURCE_TOP = "icons/source_top.gif";
    private static final String ICON_ORIENTATION_VISUAL_LEFT = "icons/visual_left.gif";
    private static final String ICON_ORIENTATION_VISUAI_TOP = "icons/visual_top.gif";

    static {
        layoutIcons = new HashMap<String, String>();
        layoutIcons.put("3", ICON_ORIENTATION_SOURCE_LEFT);
        layoutIcons.put("1", ICON_ORIENTATION_SOURCE_TOP);
        layoutIcons.put("4", ICON_ORIENTATION_VISUAL_LEFT);
        layoutIcons.put("2", ICON_ORIENTATION_VISUAI_TOP);
        layoutNamesAndTooltips = new HashMap<String, String>();
        layoutNamesAndTooltips.put("3", VpeUIMessages.SPLITTING_HORIZ_LEFT_SOURCE_TOOLTIP);
        layoutNamesAndTooltips.put("1", VpeUIMessages.SPLITTING_VERT_TOP_SOURCE_TOOLTIP);
        layoutNamesAndTooltips.put("4", VpeUIMessages.SPLITTING_HORIZ_LEFT_VISUAL_TOOLTIP);
        layoutNamesAndTooltips.put("2", VpeUIMessages.SPLITTING_VERT_TOP_VISUAL_TOOLTIP);
        layoutValues = new ArrayList<String>();
        layoutValues.add("3");
        layoutValues.add("1");
        layoutValues.add("4");
        layoutValues.add("2");
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorReference[] openedEditors;
        IPreferenceStore preferences = JspEditorPlugin.getDefault().getPreferenceStore();
        String orientation = preferences.getString("Visual/Source Editors Splitting");
        int currentOrientationIndex = layoutValues.indexOf(orientation);
        if (++currentOrientationIndex >= layoutValues.size()) {
            currentOrientationIndex %= layoutValues.size();
        }
        String newOrientation = layoutValues.get(currentOrientationIndex);
        preferences.setValue("Visual/Source Editors Splitting", newOrientation);
        IEditorReference[] iEditorReferenceArray = openedEditors = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        int n = openedEditors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorReference openedEditor = iEditorReferenceArray[n2];
            IEditorPart editor = openedEditor.getEditor(true);
            this.rotateEditor(editor, newOrientation);
            ++n2;
        }
        Command command = event.getCommand();
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        commandService.refreshElements(command.getId(), null);
        return null;
    }

    @Override
    public void updateElement(UIElement element, Map parameters) {
        IPreferenceStore preferences = JspEditorPlugin.getDefault().getPreferenceStore();
        String orientation = preferences.getString("Visual/Source Editors Splitting");
        if (orientation.isEmpty()) {
            orientation = "3";
            preferences.setValue("Visual/Source Editors Splitting", orientation);
        }
        element.setIcon(VpePlugin.imageDescriptorFromPlugin((String)"org.jboss.tools.vpe", (String)layoutIcons.get(orientation)));
        element.setTooltip(layoutNamesAndTooltips.get(orientation));
        this.fireHandlerChanged(new HandlerEvent((IHandler)this, true, false));
    }

    private void rotateEditor(IEditorPart editor, String orientation) {
        if (!(editor instanceof JSPMultiPageEditor)) {
            return;
        }
        JSPMultiPageEditor jspEditor = (JSPMultiPageEditor)editor;
        VpeController vpeController = (VpeController)jspEditor.getVisualEditor().getController();
        if (vpeController != null) {
            vpeController.getPageContext().getEditPart().fillContainer(true, orientation);
        }
    }
}

