/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.BodySource;
import org.jboss.tools.common.model.filesystems.FileAuxiliary;
import org.jboss.tools.common.model.filesystems.FilePathHelper;
import org.jboss.tools.common.model.filesystems.impl.EclipseFileBodySource;
import org.jboss.tools.common.model.filesystems.impl.FileAnyAuxiliaryImpl;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.filesystems.impl.FileBodySource;
import org.jboss.tools.common.model.filesystems.impl.FileObjectComparator;
import org.jboss.tools.common.model.filesystems.impl.FileSystemImpl;
import org.jboss.tools.common.model.filesystems.impl.FileSystemPeer;
import org.jboss.tools.common.model.filesystems.impl.FileSystemsImpl;
import org.jboss.tools.common.model.filesystems.impl.FolderLoader;
import org.jboss.tools.common.model.filesystems.impl.LinkedResources;
import org.jboss.tools.common.model.impl.RegularObjectImpl;
import org.jboss.tools.common.model.impl.XModelImpl;
import org.jboss.tools.common.model.impl.XModelObjectImpl;
import org.jboss.tools.common.model.loaders.AuxiliaryLoader;
import org.jboss.tools.common.model.loaders.EntityRecognizer;
import org.jboss.tools.common.model.loaders.EntityRecognizerContext;
import org.jboss.tools.common.model.loaders.Reloadable;
import org.jboss.tools.common.model.loaders.XObjectLoader;
import org.jboss.tools.common.model.loaders.impl.ModelEntityRecognizer;
import org.jboss.tools.common.model.loaders.impl.PropertiesLoader;
import org.jboss.tools.common.model.markers.ResourceMarkers;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.Paths;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.util.FileUtil;

public class FolderImpl
extends RegularObjectImpl
implements FolderLoader {
    private static final long serialVersionUID = 8082046187736790127L;
    protected boolean loaded = false;
    protected IContainer resource = null;
    protected String pathForResource = null;
    LinkedResources linked = new LinkedResources();
    int updateLock = 0;
    Set<String> unsynchronized = null;
    private boolean fire = false;
    private static int editability = -1;

    public static File toFile(IResource resource) {
        File f = null;
        IPath path = resource.getLocation();
        URI uri = resource.getLocationURI();
        if (uri != null) {
            String scheme = uri.getScheme();
            if ("file".equals(scheme)) {
                try {
                    f = new File(uri);
                }
                catch (IllegalArgumentException e) {
                    ModelPlugin.getDefault().logError(e);
                }
            }
            if (f != null && !f.exists()) {
                f = null;
            }
        }
        return f;
    }

    @Override
    public int getFileType() {
        return 2;
    }

    @Override
    protected Comparator<XModelObject> createComparator() {
        return new FileObjectComparator();
    }

    protected FileSystemImpl getFileSystem() {
        FolderImpl folder = (FolderImpl)this.getParent();
        return folder == null ? null : folder.getFileSystem();
    }

    public boolean isChildEditable(XModelObject o) {
        if (!this.isObjectEditable()) {
            return false;
        }
        File f = this.getChildIOFile(o);
        if (f == null) {
            return true;
        }
        return !f.isFile() || f.canWrite();
    }

    protected File getFile() {
        String path = this.getAbsolutePath();
        return path == null ? null : new File(Paths.expand(path, this.getModel().getProperties()));
    }

    @Override
    public BodySource getBodySource(String filename) {
        File f = this.getFile();
        return f == null ? null : this.getBodySource(this.getChildIOFile(filename));
    }

    BodySource getBodySource(File f) {
        IFile ef = this.getChildFile(f.getName());
        if (ef != null) {
            return new EclipseFileBodySource(ef, f);
        }
        return new FileBodySource(f);
    }

    @Override
    public boolean isAttributeEditable(String name) {
        return false;
    }

    protected String getAbsolutePath() {
        String p;
        FolderImpl parent = (FolderImpl)this.getParent();
        String string = p = parent == null ? null : parent.getAbsolutePath();
        if (parent.linked.containsFile(this.getPathPart())) {
            return parent.linked.getFileByFileName(this.getPathPart()).getAbsolutePath();
        }
        return p == null ? null : String.valueOf(p) + "/" + this.name();
    }

    public IProject getProject() {
        return this.getParent() == null ? null : ((FolderImpl)this.getParent()).getProject();
    }

    private File[] getFiles() {
        File f = this.getFile();
        if (f == null) {
            return null;
        }
        if (!f.isDirectory()) {
            return new File[0];
        }
        return f.listFiles();
    }

    private void fillMap(Map<String, File> m) {
        File[] fs = this.getFiles();
        if (fs != null) {
            File[] fileArray = fs;
            int n = fs.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                String p = FilePathHelper.toPathPath(f.getName());
                m.put(p, f);
                ++n2;
            }
        }
    }

    @Override
    public void set(String name, String value) {
        if ("NAME".equals(name) && this.isActive() && value != null && !value.equals(this.get(name))) {
            this.copy();
        }
        super.set(name, value);
    }

    @Override
    protected void loadChildren() {
        if (this.loaded || !this.isActive()) {
            return;
        }
        File[] fs = this.getFiles();
        IResource[] rs = this.getResources();
        if (fs == null || rs == null) {
            return;
        }
        this.loaded = true;
        ((XModelImpl)this.getModel()).addLoader();
        try {
            this.loadChildren(fs, rs);
        }
        finally {
            ((XModelImpl)this.getModel()).removeLoader();
        }
    }

    private void loadChildren(File[] fs, IResource[] rs) {
        FileSystemPeer peer = this.getFileSystem().getPeer();
        int i = 0;
        while (i < fs.length) {
            this._loadChild(peer, fs[i]);
            ++i;
        }
        i = 0;
        while (i < rs.length) {
            File f;
            if (rs[i].isAccessible() && rs[i].isLinked() && (f = FolderImpl.toFile(rs[i])) != null) {
                this.linked.registerResource(rs[i]);
                this._loadChild(peer, f);
            }
            ++i;
        }
        this.bindAuxiliary();
        this.fire = true;
    }

    private void bindAuxiliary() {
        XModelObject[] cs = this.getChildren();
        int i = 0;
        while (i < cs.length) {
            XObjectLoader loader;
            if (cs[i].getFileType() == 1 && (loader = XModelObjectLoaderUtil.getObjectLoader(cs[i])) instanceof AuxiliaryLoader) {
                ((AuxiliaryLoader)((Object)loader)).bind(cs[i]);
            }
            ++i;
        }
    }

    private void _loadChild(FileSystemPeer peer, File f) {
        if (f.isDirectory()) {
            Properties p = new Properties();
            p.setProperty("name", f.getName());
            XModelObject c = this.getModel().createModelObject("FileFolder", p);
            String pp = FilePathHelper.toPathPath(f.getName());
            if (this.linked.containsFile(pp)) {
                c.setObject("file", this.linked.getFileByFileName(pp));
            }
            this.addChild(c);
        } else {
            this.createFileObject(f, true);
        }
        peer.register(f);
    }

    private Properties getEntityProperties(File f) {
        Properties p = new Properties();
        FolderImpl.parseFileName(p, f.getName());
        String ext = p.getProperty("extension");
        String body = null;
        EntityRecognizer recognizer = this.getModel().getEntityRecognizer();
        EntityRecognizerContext context = new EntityRecognizerContext(f.getName(), ext, body);
        String entity = recognizer.getEntityName(context);
        if ("FileAny".equals(entity)) {
            boolean isText = XModelObjectLoaderUtil.isTextFile(f, 100);
            if (f.length() > 100000L || !isText) {
                entity = "FileAnyLong";
            } else if (isText) {
                entity = "FileTXT";
            }
        } else if (this.isRecognizerNeedingBody(entity, recognizer, context)) {
            body = this.getBodySource(f).get();
            entity = recognizer.getEntityName(new EntityRecognizerContext(f.getName(), ext, body));
        }
        if (entity == null || this.getModel().getMetaData().getEntity(entity) == null) {
            entity = "FileAny";
        }
        p.setProperty("entity", entity);
        if (body != null) {
            p.setProperty("body", body);
        }
        return p;
    }

    private boolean isRecognizerNeedingBody(String entityForNullBody, EntityRecognizer recognizer, EntityRecognizerContext context) {
        if (recognizer instanceof ModelEntityRecognizer) {
            return ((ModelEntityRecognizer)recognizer).isBodyRequired(context, entityForNullBody);
        }
        return true;
    }

    private XModelObject createFileObject(File f, boolean add) {
        return this.createFileObject(f, this.getEntityProperties(f), add);
    }

    private XModelObject createFileObject(File f, Properties p) {
        return this.createFileObject(f, p, true);
    }

    private XModelObject createFileObject(File f, Properties p, boolean add) {
        BodySource bs = this.getBodySource(f);
        String body = p.getProperty("body");
        String entity = p.getProperty("entity");
        XModelObject c = this.getModel().createModelObject(entity, p);
        if (c == null) {
            ModelPlugin.getPluginLog().logInfo("Cannot create file for entity " + entity);
            return null;
        }
        if (FolderImpl.isLateloadFile2(c)) {
            ((FileAnyImpl)c).setBodySource(bs);
        } else {
            XObjectLoader loader = XModelObjectLoaderUtil.getObjectLoader(c);
            if (loader != null) {
                String encoding;
                if (body == null) {
                    body = bs.get();
                }
                XModelObjectLoaderUtil.setTempBody(c, body);
                if ("FilePROPERTIES".equals(entity) && bs instanceof EclipseFileBodySource && (encoding = FileUtil.getEncoding((IFile)((EclipseFileBodySource)bs).ef)) != null) {
                    c.set("_encoding_", encoding);
                }
                loader.load(c);
            } else if (c.getModelEntity().getAttribute("_file") != null) {
                c.set("_file", f.getAbsolutePath());
            }
        }
        if (this.linked.filesByFileName.containsValue(f)) {
            c.setObject("file", f);
        }
        if (add) {
            this.addChild(c);
        } else {
            ((XModelObjectImpl)c).setParent_0(this);
        }
        return c;
    }

    public XModelObject createValidChildCopy(XModelObject child) {
        String s;
        File pf = this.getFile();
        File f = new File(pf, s = FileAnyImpl.toFileName(child));
        if (f.exists()) {
            return this.createFileObject(f, false);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update() {
        block45: {
            if (!this.loaded) {
                return true;
            }
            if (this.updateLock > 0) {
                return true;
            }
            ++this.updateLock;
            HashMap<String, File> mf = new HashMap<String, File>();
            this.linked.clearFiles();
            FileSystemImpl fileSystem = this.getFileSystem();
            if (fileSystem == null) {
                return false;
            }
            FileSystemsImpl fsi = (FileSystemsImpl)fileSystem.getParent();
            try {
                IResource[] rs;
                block44: {
                    if (this.resource != null && this.resource.exists() && !this.resource.isSynchronized(1)) {
                        try {
                            fsi.lockUpdate();
                            this.resource.refreshLocal(0, null);
                            if (this.resource.exists()) {
                                rs = this.resource.members();
                                int i = 0;
                                while (i < rs.length) {
                                    if (!rs[i].isSynchronized(0)) {
                                        if (this.unsynchronized == null) {
                                            this.unsynchronized = new HashSet<String>();
                                        }
                                        String pp = FilePathHelper.toPathPath(rs[i].getName());
                                        this.unsynchronized.add(pp);
                                    }
                                    ++i;
                                }
                                if (this.resource.exists()) {
                                    this.resource.refreshLocal(1, null);
                                }
                            }
                        }
                        catch (ResourceException re) {
                            File f = FolderImpl.toFile((IResource)this.resource);
                            if (f != null && f.exists()) {
                                ModelPlugin.getPluginLog().logError("Exception caught in FolderImpl.update()", (Throwable)re);
                            }
                            fsi.unlockUpdate();
                            break block44;
                        }
                        catch (CoreException e) {
                            try {
                                ModelPlugin.getPluginLog().logError("Exception caught in FolderImpl.update()", (Throwable)e);
                                break block44;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                fsi.unlockUpdate();
                            }
                        }
                        fsi.unlockUpdate();
                    }
                }
                try {
                    if (this.resource != null && this.resource.exists()) {
                        rs = this.resource.members();
                        int i = 0;
                        while (i < rs.length) {
                            File f;
                            if (rs[i].isLinked() && (f = FolderImpl.toFile(rs[i])) != null) {
                                String p = FilePathHelper.toPathPath(f.getName());
                                mf.put(p, f);
                                this.linked.registerResource(rs[i]);
                            }
                            ++i;
                        }
                    }
                }
                catch (CoreException coreException) {
                    ModelPlugin.getPluginLog().logError("Exception caught in FolderImpl.update()");
                }
                this.fillMap(mf);
                Map<String, XModelObject> mc = this.children.getObjectsMap();
                this.updateAuxiliary(mc, mf);
                HashMap<String, XModelObject> toRemove = new HashMap<String, XModelObject>();
                Iterator<String> io = mc.keySet().iterator();
                while (io.hasNext()) {
                    String nm = io.next();
                    if (mf.containsKey(nm)) continue;
                    XModelObject o = mc.get(nm);
                    File of = this.getChildIOFile(o);
                    if (o.getFileType() == 2 ? !this.getFileSystem().getPeer().containsDir(of) : !this.getFileSystem().getPeer().contains(of)) continue;
                    toRemove.put(nm, o);
                    io.remove();
                }
                for (String nm : mf.keySet()) {
                    File f = (File)mf.get(nm);
                    XModelObject o = mc.get(nm);
                    if (o != null) {
                        this.updateLoaded(o, f);
                        mc.remove(nm);
                        continue;
                    }
                    this.updateNew(nm, f, toRemove);
                }
                for (String nm : toRemove.keySet()) {
                    this.updateRemove((XModelObject)toRemove.get(nm));
                }
                this.bindAuxiliary();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                --this.updateLock;
                this.unsynchronized = null;
                FolderImpl folderImpl = this;
                synchronized (folderImpl) {
                    this.notifyAll();
                }
                return true;
            }
            catch (XModelException xModelException) {
                FolderImpl folderImpl;
                try {
                    ModelPlugin.getPluginLog().logError("Exception caught in FolderImpl.update()");
                    --this.updateLock;
                    this.unsynchronized = null;
                    folderImpl = this;
                }
                catch (Throwable throwable) {
                    --this.updateLock;
                    this.unsynchronized = null;
                    FolderImpl folderImpl2 = this;
                    synchronized (folderImpl2) {
                        this.notifyAll();
                    }
                    throw throwable;
                }
                synchronized (folderImpl) {
                    this.notifyAll();
                    break block45;
                }
            }
            --this.updateLock;
            this.unsynchronized = null;
            FolderImpl folderImpl = this;
            synchronized (folderImpl) {
                this.notifyAll();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long waitForUpdate() {
        if (this.updateLock == 0) {
            return 0L;
        }
        long t = System.currentTimeMillis();
        long dt = 0L;
        while (this.updateLock > 0 && dt < 10000L) {
            FolderImpl folderImpl = this;
            synchronized (folderImpl) {
                try {
                    this.wait(100L);
                }
                catch (InterruptedException interruptedException) {
                    return dt;
                }
            }
            dt = System.currentTimeMillis() - t;
        }
        return dt;
    }

    protected File getChildIOFile(XModelObject o) {
        String s = FileAnyImpl.toFileName(o);
        File f = (File)o.getObject("file");
        if (f == null && this.linked.containsFile(o.getPathPart())) {
            f = this.linked.getFileByFileName(o.getPathPart());
        }
        if (f == null) {
            f = new File(this.getFile(), s);
        }
        return f;
    }

    protected File getChildIOFile(String filename) {
        File f = null;
        String p = FilePathHelper.toPathPath(filename);
        if (this.linked.containsFile(p)) {
            f = this.linked.getFileByFileName(p);
        }
        if (f == null) {
            f = new File(this.getFile(), filename);
        }
        return f;
    }

    private void updateAuxiliary(Map<String, XModelObject> mc, Map<String, File> mf) throws XModelException {
        Iterator<String> it = mf.keySet().iterator();
        while (it.hasNext()) {
            File fmain;
            XModelObject main;
            String nm = it.next();
            File f = mf.get(nm);
            XModelObject o = mc.get(nm);
            if (o == null || !o.getModelEntity().getName().equals(FileAuxiliary.AUX_FILE_ENTITY)) continue;
            it.remove();
            FileAnyAuxiliaryImpl aux = (FileAnyAuxiliaryImpl)o;
            mc.remove(nm);
            if (aux.isObsolete()) {
                FileAuxiliary h = aux.getAuxiliaryHelper();
                main = aux.getMainObject();
                if (main != null && main.isActive() && h != null) {
                    File r;
                    String n = h.getAuxiliaryName(main);
                    String p = String.valueOf(n) + "." + aux.getAttributeValue("extension");
                    XModelObject other = this.getChildByPath(p);
                    if (other != null && other != aux) {
                        other.removeFromParent();
                    }
                    aux.fileRenamed(n, aux.getAttributeValue("extension"));
                    aux.updateBodySource();
                    if (this.isOverlapped() || (r = new File(f.getParentFile(), FileAnyImpl.toFileName(aux))).equals(f) || !f.exists()) continue;
                    if (!r.exists()) {
                        FileUtil.copyFile((File)f, (File)r);
                        f.delete();
                        FileSystemPeer peer = this.getFileSystem().getPeer();
                        peer.unregister(f);
                        peer.register(r);
                        IFile ef = this.getChildFile(f.getName());
                        if (ef != null && !ef.isSynchronized(0)) {
                            try {
                                ef.refreshLocal(0, null);
                            }
                            catch (CoreException coreException) {
                                ModelPlugin.getPluginLog().logError("Exception caught in FolderImpl.update()");
                            }
                        }
                        if ((ef = this.getChildFile(r.getName())) == null || ef.isSynchronized(0)) continue;
                        try {
                            ef.refreshLocal(0, null);
                        }
                        catch (CoreException coreException) {
                            ModelPlugin.getPluginLog().logError("Exception caught in FolderImpl.update()");
                        }
                        continue;
                    }
                    f.delete();
                    this.getFileSystem().getPeer().unregister(f);
                    IFile ef = this.getChildFile(f.getName());
                    if (ef == null || ef.isSynchronized(0)) continue;
                    try {
                        ef.refreshLocal(0, null);
                    }
                    catch (CoreException coreException) {}
                    continue;
                }
                if (this.isOverlapped()) continue;
                this.updateRemove(aux);
                f.delete();
                this.getFileSystem().getPeer().unregister(f);
                continue;
            }
            FileSystemPeer peer = this.getFileSystem().getPeer();
            if (!this.registerFileInPeer(peer, f) || (main = aux.getMainObject()) == null || (fmain = mf.get(main.getPathPart())) == null) continue;
            peer.unregister(fmain);
            this.setForceLoadProperty(main, true);
            this.updateLoaded(main, fmain);
            this.setForceLoadProperty(main, false);
            mc.remove(main.getPathPart());
        }
    }

    private synchronized boolean registerFileInPeer(FileSystemPeer peer, File f) {
        if (f.isFile() && peer.contains(f) && !peer.isUpdated(f)) {
            return false;
        }
        peer.register(f);
        return true;
    }

    private void setForceLoadProperty(XModelObject f, boolean b) {
        f.set("forceLoad", b ? "true" : "");
    }

    protected void updateLoaded(XModelObject o, File f) throws XModelException {
        FileSystemPeer peer = this.getFileSystem().getPeer();
        if (o instanceof FolderImpl) {
            if (!o.getAttributeValue("name").equals(f.getName())) {
                o.setAttributeValue("name", f.getName());
                ((FolderImpl)o).getResource();
            }
            ((FolderImpl)o).update();
        } else {
            int i;
            if (!this.registerFileInPeer(peer, f) && !this.isEncodingChanged(o)) {
                if (!f.getName().equals(FileAnyImpl.toFileName(o))) {
                    String n = f.getName();
                    int i2 = n.lastIndexOf(".");
                    String nm = i2 >= 0 ? n.substring(0, i2) : n;
                    String ext = i2 >= 0 ? n.substring(i2 + 1) : "";
                    ((FileAnyImpl)o).fileRenamed(nm, ext);
                }
                return;
            }
            String p = FilePathHelper.toPathPath(f.getName());
            int n = i = !o.isModified() || this.unsynchronized == null || !this.unsynchronized.contains(p) ? 0 : this.question(f);
            if (i == 0) {
                this.reload(o, f);
            } else if (i == -100) {
                final XModelObject o1 = o;
                final File f1 = f;
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (FolderImpl.this.question(f1) == 0) {
                            try {
                                FolderImpl.this.reload(o1, f1);
                            }
                            catch (XModelException e) {
                                ModelPlugin.getPluginLog().logError((Throwable)((Object)e));
                            }
                        }
                    }
                });
            }
        }
    }

    private boolean isEncodingChanged(XModelObject o) {
        if (o != null && o.getModelEntity().getName().equals("FilePROPERTIES")) {
            String encoding = o.getAttributeValue("encoding");
            if (encoding == null) {
                return false;
            }
            String newEncoding = PropertiesLoader.getEncoding(o);
            if (newEncoding == null) {
                newEncoding = "8859_1";
            }
            if (!encoding.equals(newEncoding)) {
                return true;
            }
        }
        return false;
    }

    private int question(File f) {
        if (Display.getCurrent() == null) {
            return -100;
        }
        return this.getModel().getService().showDialog("Update", MessageFormat.format("File {0} is externally modified.\nDo you want to reload it?", f.getAbsolutePath()), new String[]{"Yes", "No"}, null, 0);
    }

    public void updateChildFile(XModelObject o, File f) throws XModelException {
        int i;
        FileSystemPeer peer = this.getFileSystem().getPeer();
        if (f.isFile() && peer.contains(f) && !peer.isUpdated(f)) {
            return;
        }
        int n = i = !o.isModified() ? 0 : this.question(f);
        if (i < 0) {
            return;
        }
        if (!this.registerFileInPeer(peer, f)) {
            return;
        }
        if (i == 0) {
            this.reload(o, f);
        }
    }

    public boolean isChangedEntity(XModelObject o, File f) {
        Properties p = this.getEntityProperties(f);
        return !o.getModelEntity().getName().equals(p.getProperty("entity"));
    }

    private void reload(XModelObject o, File f) throws XModelException {
        Properties p = this.getEntityProperties(f);
        if (!o.getModelEntity().getName().equals(p.getProperty("entity"))) {
            o.removeFromParent();
            this.createFileObject(f, p);
            return;
        }
        BodySource bs = this.getBodySource(f);
        if (FolderImpl.isLateloadFile(o)) {
            FileAnyImpl impl = (FileAnyImpl)o;
            if (impl.getBodySource() != null) {
                impl.setBodySource(bs);
                this.fireObjectChanged(null);
            } else {
                impl.edit(bs.get());
                impl.setModified(false);
                XModelObjectLoaderUtil.updateModifiedOnSave(impl);
            }
        } else {
            XObjectLoader loader = XModelObjectLoaderUtil.getObjectLoader(o);
            if (loader != null) {
                String encoding;
                XModelObjectLoaderUtil.setTempBody(o, bs.get());
                if ("FilePROPERTIES".equals(o.getModelEntity().getName()) && bs instanceof EclipseFileBodySource && (encoding = FileUtil.getEncoding((IFile)((EclipseFileBodySource)bs).ef)) != null) {
                    o.setAttributeValue("encoding", encoding);
                }
                loader.update(o);
            } else if (o instanceof Reloadable) {
                ((Reloadable)((Object)o)).reload();
            } else if ("FileAnyLong".equals(o.getModelEntity().getName())) {
                o.setModified(false);
            }
        }
    }

    protected boolean updateNew(String pathpart, File f, Map<String, XModelObject> toRemove) throws XModelException {
        FileSystemPeer peer = this.getFileSystem().getPeer();
        if (peer.contains(f) && !peer.isUpdated(f)) {
            return false;
        }
        XModelObject c = null;
        if (f.isDirectory()) {
            Properties p = new Properties();
            p.setProperty("name", f.getName());
            c = this.getModel().createModelObject("FileFolder", p);
            String pp = FilePathHelper.toPathPath(f.getName());
            if (this.linked.containsFile(pp)) {
                c.setObject("file", this.linked.getFileByFileName(pp));
            }
        } else {
            Properties ep = this.getEntityProperties(f);
            XModelObject old = this.findOldObject(ep.getProperty("entity"), toRemove);
            if (old != null) {
                String ofn = FileAnyImpl.toFileName(old);
                if (!f.getName().equals(ofn)) {
                    File of = new File(f.getParent(), ofn);
                    peer.unregister(of);
                    String nm = ep.getProperty("name");
                    String ext = ep.getProperty("extension");
                    ((FileAnyImpl)old).fileRenamed(nm, ext);
                }
                this.updateLoaded(old, f);
            } else {
                this.createFileObject(f, ep);
            }
        }
        peer.register(f);
        return c != null && this.addChild(c);
    }

    private XModelObject findOldObject(String entity, Map<String, XModelObject> toRemove) {
        if (entity == null || toRemove.size() == 0) {
            return null;
        }
        Iterator<String> it = toRemove.keySet().iterator();
        while (it.hasNext()) {
            String nm = it.next().toString();
            XModelObject o = toRemove.get(nm);
            if (!o.getModelEntity().getName().equals(entity)) continue;
            toRemove.remove(nm);
            return o;
        }
        return null;
    }

    protected void updateRemove(XModelObject o) throws XModelException {
        int i;
        boolean c;
        boolean d = o instanceof FolderImpl;
        final FileSystemPeer peer = this.getFileSystem().getPeer();
        final File rf = this.getChildIOFile(o);
        boolean bl = c = d && peer.containsDir(rf) || !d && peer.contains(rf);
        if (!c) {
            return;
        }
        int n = i = !o.isModified() ? 1 : FolderImpl.question(o);
        if (i != 0) {
            o.removeFromParent();
        } else if (i == -100) {
            if (rf.exists()) {
                return;
            }
            final XModelObject o1 = o;
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (rf.exists()) {
                        return;
                    }
                    if (FolderImpl.question(o1) == 0) {
                        o1.removeFromParent();
                    } else {
                        try {
                            FolderImpl.this.saveChild(o1, peer, rf);
                            XActionInvoker.invoke("Open", o1, null);
                        }
                        catch (XModelException e) {
                            ModelPlugin.getDefault().logError((Throwable)((Object)e));
                        }
                    }
                }
            });
        } else {
            this.saveChild(o, peer, rf);
            XActionInvoker.invoke("Open", o, null);
        }
        if (d) {
            peer.unregisterDir(rf);
        } else {
            peer.unregister(rf);
        }
    }

    public void removeChildFile(XModelObject o) {
        boolean c;
        boolean d = o instanceof FolderImpl;
        FileSystemPeer peer = this.getFileSystem().getPeer();
        File rf = this.getChildIOFile(o);
        boolean bl = c = d && peer.containsDir(rf) || !d && peer.contains(rf);
        if (!c) {
            return;
        }
        if (o.getModel().getModelBuffer().source() == o && rf.exists() && o.getModelEntity().getAttribute("_file") != null) {
            File temp = null;
            try {
                temp = File.createTempFile("efs_", rf.getName());
            }
            catch (IOException e) {
                ModelPlugin.getPluginLog().logError((Throwable)e);
            }
            if (temp != null) {
                FileUtil.copyFile((File)rf, (File)temp);
                temp.deleteOnExit();
                o.set("_file", temp.getAbsolutePath());
            }
        }
        IFile r = d ? this.getChildContainer(o.getAttributeValue("name")) : this.getChildFile(FileAnyImpl.toFileName(o));
        o.removeFromParent();
        if (r.exists()) {
            try {
                r.delete(true, null);
            }
            catch (CoreException e) {
                ModelPlugin.getPluginLog().logError((Throwable)e);
            }
        } else {
            rf.delete();
        }
        if (d) {
            peer.unregisterDir(rf);
        } else {
            peer.unregister(rf);
        }
        XModelObjectLoaderUtil.updateModifiedFlag(this);
    }

    private static int question(XModelObject o) {
        if (Display.getCurrent() == null) {
            return -100;
        }
        return o.getModel().getService().showDialog("Update", MessageFormat.format("File {0} is removed from the disk.\n Do you want to save your changes?", o.getModelEntity().getRenderer().getTitle(o)), new String[]{"Yes", "No"}, null, 0);
    }

    @Override
    protected void fireStructureChanged(int kind, Object info) {
        if (this.fire) {
            super.fireStructureChanged(kind, info);
        }
    }

    @Override
    public boolean hasChildren() {
        File[] fs;
        boolean q = super.hasChildren();
        if (q || this.loaded) {
            return q;
        }
        if (this.getParent() instanceof FolderImpl) {
            FolderImpl p = (FolderImpl)this.getParent();
            if (p.linked.containsFile(this.getPathPart())) {
                return true;
            }
        }
        boolean bl = q = (fs = this.getFiles()) != null && fs.length > 0;
        if (!q) {
            this.fire = true;
            this.loaded = true;
        }
        return q;
    }

    @Override
    public boolean save() {
        File f = this.getFile();
        if (f == null) {
            return true;
        }
        if (f.exists() && !this.isModified()) {
            return true;
        }
        if (this.isOverlapped()) {
            return true;
        }
        boolean b = true;
        if (!f.exists()) {
            IContainer c = this.getResource();
            if (this.getFileType() == 2 && c instanceof IFolder) {
                IFolder ef = (IFolder)c;
                try {
                    ef.create(true, ef.getParent().isLocal(0), null);
                }
                catch (CoreException e) {
                    ModelPlugin.getPluginLog().logError((Throwable)e);
                }
            }
            if (!f.exists()) {
                f.mkdirs();
            }
        }
        HashMap<String, File> t = new HashMap<String, File>();
        this.fillMap(t);
        FileSystemPeer peer = this.getFileSystem().getPeer();
        peer.register(f);
        XModelObject[] cs = this.getChildren();
        int i = 0;
        while (i < cs.length) {
            if (!cs[i].getModelEntity().getName().equals(FileAuxiliary.AUX_FILE_ENTITY)) {
                if (cs[i] instanceof FolderLoader) {
                    b &= ((FolderLoader)((Object)cs[i])).save();
                } else {
                    File d = this.linked.getFileByFileName(cs[i].getPathPart());
                    if (d == null) {
                        d = new File(f, FileAnyImpl.toFileName(cs[i]));
                    }
                    try {
                        b &= this.saveChild(cs[i], peer, d);
                    }
                    catch (XModelException ee) {
                        ModelPlugin.getPluginLog().logError((Throwable)((Object)ee));
                    }
                }
                t.remove(cs[i].getPathPart());
            }
            ++i;
        }
        cs = this.getChildren(FileAuxiliary.AUX_FILE_ENTITY);
        i = 0;
        while (i < cs.length) {
            File cf = this.getChildIOFile(cs[i]);
            if (cf.exists()) {
                peer.register(cf);
                FileAnyImpl impl = (FileAnyImpl)cs[i];
                if (impl.getBodySource() == null) {
                    impl.setBodySource(this.getBodySource(cf));
                }
                t.remove(cs[i].getPathPart());
            }
            ++i;
        }
        for (File df : t.values()) {
            boolean r;
            boolean d = df.isDirectory();
            boolean bl = r = d && peer.containsDir(df) || !d && peer.contains(df);
            if (!r) continue;
            XModelObjectLoaderUtil.remove(df);
            if (d) {
                peer.unregisterDir(df);
                continue;
            }
            peer.unregister(df);
        }
        if (b) {
            this.setModified(false);
        }
        return b;
    }

    public boolean saveChild(XModelObject c) throws XModelException {
        if (c == null || c.getParent() != this) {
            return false;
        }
        if (!c.isModified()) {
            return true;
        }
        File folder = this.getFile();
        if (folder == null || !folder.exists()) {
            return this.save();
        }
        ++this.updateLock;
        boolean b = false;
        try {
            File d = this.linked.getFileByFileName(c.getPathPart());
            if (d == null) {
                d = new File(folder, FileAnyImpl.toFileName(c));
            }
            this.saveChild(c, this.getFileSystem().getPeer(), d);
            if (b) {
                XModelObjectLoaderUtil.updateModifiedOnSave(c);
            }
        }
        finally {
            --this.updateLock;
        }
        this.update();
        ResourceMarkers.refreshProblemMarkersAsync(c);
        return b;
    }

    private boolean saveChild(XModelObject c, FileSystemPeer peer, File cf) throws XModelException {
        FileAnyImpl impl;
        boolean h;
        boolean b = true;
        if (!cf.exists()) {
            c.setModified(true);
        }
        if (!c.isModified()) {
            return true;
        }
        XObjectLoader loader = XModelObjectLoaderUtil.getObjectLoader(c);
        if (loader != null) {
            b &= loader.save(c);
        }
        BodySource bs = this.getBodySource(cf);
        boolean bl = h = loader == null || bs.write(c);
        if (loader == null) {
            this.saveFileWithoutLoader(cf, c);
        }
        if (h && c.isModified() || this.isChangedEntity(c, cf)) {
            this.reload(c, cf);
        }
        b &= h;
        peer.register(cf);
        if (FolderImpl.isLateloadFile(c) && (impl = (FileAnyImpl)c).getBodySource() == null) {
            impl.setBodySource(bs);
        }
        return b;
    }

    public void updateRegistration(XModelObject child) {
        if (child == null || child.getParent() != this) {
            return;
        }
        File folder = this.getFile();
        if (folder == null || !folder.exists() || this.getFileSystem() == null) {
            return;
        }
        FileSystemPeer peer = this.getFileSystem().getPeer();
        File cf = new File(folder, FileAnyImpl.toFileName(child));
        if (!cf.exists()) {
            child.setModified(true);
        }
        if (child.isModified()) {
            return;
        }
        peer.register(cf);
    }

    private boolean saveFileWithoutLoader(File f, XModelObject o) {
        if (!o.isModified()) {
            return true;
        }
        if (o.getModelEntity().getAttribute("_file") == null) {
            return true;
        }
        String sfn = o.get("_file");
        if (sfn.length() == 0) {
            return true;
        }
        if (f.getAbsolutePath().equalsIgnoreCase(sfn)) {
            o.setModified(false);
            return true;
        }
        File sf = new File(sfn);
        if (sf.isFile()) {
            f.getParentFile().mkdirs();
            FileUtil.copyFile((File)sf, (File)f);
        }
        o.set("_file", f.getAbsolutePath());
        o.setModified(false);
        return true;
    }

    public boolean changeChildTimeStamp(XModelObject c) throws XModelException {
        if (c == null || c.getParent() != this) {
            return false;
        }
        File cf = new File(this.getFile(), FileAnyImpl.toFileName(c));
        if (!cf.exists()) {
            return this.saveChild(c);
        }
        long s = cf.lastModified();
        if (c.isModified()) {
            this.saveChild(c);
            if (s != cf.lastModified()) {
                return true;
            }
        }
        cf.setLastModified(System.currentTimeMillis());
        this.getFileSystem().getPeer().register(cf);
        return true;
    }

    public void discardChildFile(XModelObject c) throws XModelException {
        if (c == null || !c.isActive() || !c.isModified() || c.getParent() != this) {
            return;
        }
        c.setModified(false);
        XModelObjectLoaderUtil.updateModifiedOnSave(c);
        File folder = this.getFile();
        if (!folder.exists()) {
            return;
        }
        File cf = new File(folder, FileAnyImpl.toFileName(c));
        String path = c.getPath();
        this.setForceLoadProperty(c, true);
        this.reload(c, cf);
        this.setForceLoadProperty(c, false);
        c = this.getModel().getByPath(path);
        if (c != null) {
            c.getChildren();
        }
    }

    public static void parseFileName(Properties p, String fn) {
        int i = fn.lastIndexOf(46);
        String n = i < 0 ? fn : fn.substring(0, i);
        String e = i < 0 ? "" : fn.substring(i + 1);
        p.setProperty("name", n);
        p.setProperty("extension", e);
    }

    @Override
    public String getPathPart() {
        String s = this.get("NAME");
        return FilePathHelper.toPathPath(s);
    }

    @Override
    public XModelObject getChildByPathPart(String pathpart) {
        if (this.linked.filesByLinkName.containsKey(pathpart)) {
            File f = this.linked.getFileByResourceName(pathpart);
            pathpart = f.getName();
        }
        pathpart = FilePathHelper.toPathPath(pathpart);
        return super.getChildByPathPart(pathpart);
    }

    static boolean isLateloadFile(XModelObject o) {
        return o.getModelEntity().getAttribute("_lateload") != null && o.getModelEntity().getAttribute("body") != null;
    }

    static boolean isLateloadFile2(XModelObject o) {
        return o.getModelEntity().getAttribute("_lateload") != null;
    }

    @Override
    protected void copy_children(XModelObject copy, boolean transform) {
        super.copy_children(copy, transform);
        if (copy instanceof FolderImpl) {
            FolderImpl f = (FolderImpl)copy;
            f.loaded = true;
            f.fire = true;
        }
    }

    private void initEditability() {
        if (editability > -1) {
            return;
        }
        editability = this.getModelEntity().getActionList().getItem("DeleteActions").getItem("Delete") != null ? 1 : 0;
    }

    @Override
    public boolean isObjectEditable() {
        this.initEditability();
        return editability == 1 && !"true".equals(this.get("overlapped")) && this.isActive();
    }

    @Override
    public String getMainIconName() {
        if ("true".equals(this.get("overlapped")) && this.isActive()) {
            XModelObject o;
            String oin = this.get("overlappedSystem");
            XModelObject xModelObject = o = oin == null || oin.length() == 0 ? null : this.getModel().getByPath(oin);
            if (o == null) {
                o = this;
                while (o != null && o.getFileType() != 3) {
                    o = o.getParent();
                }
            }
            if (o != null && o != this) {
                return o.getMainIconName();
            }
        }
        return super.getMainIconName();
    }

    public IContainer getChildContainer(String name) {
        if (this.linked.containsFile(name)) {
            IResource r = this.linked.getResourceByFileName(name);
            return r instanceof IContainer ? (IContainer)r : null;
        }
        IContainer c = this.getResource();
        return c == null ? null : c.getFolder((IPath)new Path("/" + name));
    }

    public IFile getChildFile(String name) {
        if (this.linked.containsFile(name)) {
            IResource r = this.linked.getResourceByFileName(name);
            return r instanceof IFile ? (IFile)r : null;
        }
        IContainer c = this.getResource();
        return c == null ? null : c.getFile((IPath)new Path("/" + name));
    }

    public IContainer getResource() {
        if (!this.needUpdateResource()) {
            return this.resource;
        }
        this.resource = ((FolderImpl)this.getParent()).getChildContainer(this.getAttributeValue("name"));
        this.pathForResource = this.getPath();
        return this.resource;
    }

    protected boolean needUpdateResource() {
        if (this.resource != null && !this.resource.getName().equals(this.getAttributeValue("name"))) {
            return true;
        }
        if (!this.isActive()) {
            return false;
        }
        if (this.pathForResource == null || this.resource == null) {
            return true;
        }
        String path = this.getPath();
        return path != null && !path.equals(this.pathForResource);
    }

    public IResource[] getResources() {
        block3: {
            try {
                if (this.isActive()) break block3;
                return null;
            }
            catch (CoreException e) {
                ModelPlugin.getPluginLog().logError((Throwable)e);
                return new IResource[0];
            }
        }
        IContainer c = this.getResource();
        return c != null && c.isAccessible() ? c.members() : new IResource[]{};
    }

    public boolean isOverlapped() {
        XModelObject p = this;
        while (p != null && !"true".equals(this.get("overlapped"))) {
            p = p.getParent();
        }
        return p != null;
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (IResource.class == adapter) {
            return this.getResource();
        }
        return super.getAdapter(adapter);
    }

    @Override
    public boolean isRemoved() {
        return this.resource != null && !this.resource.exists();
    }
}

