/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.core.resources;

import java.io.File;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.ui.javaeditor.JarEntryEditorInput;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.internal.part.NullEditorInput;
import org.eclipse.ui.part.FileEditorInput;
import org.jboss.tools.common.core.resources.XModelObjectEditorInputFactory;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.filesystems.impl.FileAnyAuxiliaryImpl;
import org.jboss.tools.common.model.filesystems.impl.FileAnyImpl;
import org.jboss.tools.common.model.filesystems.impl.FolderImpl;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.editor.IModelObjectEditorInput;
import org.jboss.tools.common.model.ui.editor.ModelObjectJarEntryEditorInput;
import org.jboss.tools.common.model.ui.editor.ModelObjectLocationEditorInput;
import org.jboss.tools.common.model.ui.editor.ModelObjectStorageEditorInput;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.Paths;
import org.jboss.tools.common.model.util.XModelObjectCache;

public class XModelObjectEditorInput
extends FileEditorInput
implements IModelObjectEditorInput {
    private XModelObject object;
    private XModelObjectCache cache;

    private XModelObjectEditorInput(XModelObject object) {
        super(XModelObjectEditorInput.getFileByObject(object));
        this.object = object;
        this.cache = new XModelObjectCache(object);
    }

    public boolean updateXModelObject() {
        IFile file = this.getFile();
        XModelObject o = EclipseResourceUtil.createObjectForResource((IResource)file);
        if (o != null && o != this.object) {
            this.object = o;
            this.cache = new XModelObjectCache(this.object);
            return true;
        }
        return false;
    }

    private static XModelObject getMainObject(XModelObject object) {
        XModelObject main;
        if (object instanceof FileAnyAuxiliaryImpl && (main = ((FileAnyAuxiliaryImpl)object).getMainObject()) != null) {
            object = main;
        }
        return object;
    }

    public static IModelObjectEditorInput createInstance(XModelObject object) {
        IFile f = XModelObjectEditorInput.getFileByObject(object = XModelObjectEditorInput.getMainObject(object));
        if (f == null && object instanceof FileAnyImpl) {
            String path;
            XModelObject p = object.getParent();
            if (p instanceof FolderImpl && (path = ((FileAnyImpl)object).getAbsolutePath()) != null) {
                return new ModelObjectLocationEditorInput(object, (IPath)new Path(path));
            }
            return new ModelObjectStorageEditorInput(object);
        }
        return f == null ? null : new XModelObjectEditorInput(object);
    }

    @Override
    public XModelObject getXModelObject() {
        XModelObject o = this.cache.getObject();
        if (o != null) {
            this.object = o;
        }
        return o;
    }

    public boolean exists() {
        IFile f = this.getFile();
        return f != null && f.exists();
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.object.getPresentationString();
    }

    public String getToolTipText() {
        IFile f = (IFile)EclipseResourceUtil.getResource((XModelObject)this.object);
        if (f != null && f.exists()) {
            return f.getLocation().toString();
        }
        return this.object.getPresentationString();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == XModelObject.class) {
            return this.getXModelObject();
        }
        Object result = null;
        if (IFile.class.isAssignableFrom(adapter)) {
            result = EclipseResourceUtil.getResource((XModelObject)this.object);
            if (result != null && !adapter.isAssignableFrom(result.getClass())) {
                result = null;
            }
        } else {
            result = super.getAdapter(adapter);
        }
        return result;
    }

    public boolean equals(Object o) {
        this.getXModelObject();
        if (this == o) {
            return true;
        }
        if (o instanceof FileEditorInput) {
            if (this.getFile() == null) {
                return false;
            }
            FileEditorInput other = (FileEditorInput)o;
            IFile f1 = this.getFile();
            IFile f2 = other.getFile();
            if (f1 == null || f2 == null) {
                return f1 == f2;
            }
            if (f1.equals((Object)f2)) {
                return true;
            }
            IPath loc1 = f1.getLocation();
            IPath loc2 = f2.getLocation();
            if (loc1 == null || loc2 == null) {
                return loc1 == loc2;
            }
            return loc1.equals((Object)loc2);
        }
        if (o instanceof XModelObjectEditorInput) {
            return this.object.equals(((XModelObjectEditorInput)o).getXModelObject());
        }
        return false;
    }

    public IStorage getStorage() {
        return this.getFile();
    }

    public IFile getFile() {
        return super.getFile();
    }

    public boolean isFileChanged() {
        XModelObject o = this.getXModelObject();
        IFile f1 = super.getFile();
        if (o == null || o.getPath() == null) {
            return false;
        }
        IFile f2 = XModelObjectEditorInput.getFileByObject(o);
        return !f1.equals((Object)f2);
    }

    public void synchronize() {
        XModelObject o = this.getXModelObject();
        IFile f1 = super.getFile();
        if (o == null || o.getPath() == null) {
            return;
        }
        IFile f2 = XModelObjectEditorInput.getFileByObject(o);
        if (!f1.equals((Object)f2) && f2 != null) {
            this.hackSetFile(f2);
        }
    }

    private void hackSetFile(IFile f) {
        try {
            Field field = FileEditorInput.class.getDeclaredField("file");
            field.setAccessible(true);
            field.set(this, f);
        }
        catch (NoSuchFieldException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (IllegalAccessException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    private static IFile getFileByObject(XModelObject object) {
        return (IFile)EclipseResourceUtil.getResource((XModelObject)object);
    }

    public static IEditorInput checkInput(IEditorInput input) {
        if (input instanceof IModelObjectEditorInput) {
            return input;
        }
        if (input instanceof ILocationProvider) {
            return XModelObjectEditorInput.convertExternalInput((ILocationProvider)input);
        }
        if (input instanceof IFileEditorInput) {
            return XModelObjectEditorInput.convertFileInput((IFileEditorInput)input);
        }
        if (input instanceof IStorageEditorInput) {
            return XModelObjectEditorInput.convertStorageEditorInput((IStorageEditorInput)input);
        }
        if (input instanceof IURIEditorInput) {
            URI uri = ((IURIEditorInput)input).getURI();
            String f = uri.getPath();
            XModelObject o = EclipseResourceUtil.createObjectForLocation((String)f);
            return o == null || o.getFileType() != 1 ? input : new ModelObjectLocationEditorInput(XModelObjectEditorInput.getMainObject(o), (IPath)new Path(f));
        }
        return input;
    }

    private static IEditorInput convertFileInput(IFileEditorInput input) {
        XModelObject o;
        IFileEditorInput fi = input;
        IFile f = fi.getFile();
        if (f != null && !f.isSynchronized(2)) {
            try {
                f.refreshLocal(2, null);
            }
            catch (CoreException coreException) {}
        }
        if ((o = EclipseResourceUtil.getObjectByResource((IResource)f)) == null) {
            o = EclipseResourceUtil.createObjectForResource((IResource)f);
        }
        return o == null || o.getFileType() != 1 ? input : new XModelObjectEditorInput(XModelObjectEditorInput.getMainObject(o));
    }

    private static IEditorInput convertExternalInput(ILocationProvider input) {
        XModelObject o = EclipseResourceUtil.createObjectForLocation((String)input.getPath((Object)input).toString());
        return o == null || o.getFileType() != 1 ? (IEditorInput)input : new ModelObjectLocationEditorInput(XModelObjectEditorInput.getMainObject(o), input.getPath((Object)input));
    }

    private static IEditorInput convertStorageEditorInput(IStorageEditorInput input) {
        String[] entryInfo;
        if (input instanceof JarEntryEditorInput) {
            IProject project = null;
            JarEntryEditorInput j = (JarEntryEditorInput)input;
            if (j.getStorage() instanceof IJarEntryResource) {
                IPackageFragmentRoot root;
                IJarEntryResource file = (IJarEntryResource)j.getStorage();
                String jarFile = file.getPackageFragmentRoot().getPath().toString();
                if (file.getPackageFragmentRoot().getResource() != null) {
                    jarFile = file.getPackageFragmentRoot().getResource().getLocation().toString();
                }
                String entry = file.getName();
                IJarEntryResource r = file;
                while (r != null && r.getParent() instanceof IJarEntryResource) {
                    r = (IJarEntryResource)r.getParent();
                    entry = String.valueOf(r.getName()) + "/" + entry;
                }
                if (r != null && r.getParent() instanceof IPackageFragment) {
                    Object pf = (IPackageFragment)r.getParent();
                    IJavaProject jp = pf.getJavaProject();
                    if (jp != null) {
                        project = jp.getProject();
                    }
                    while (pf != null) {
                        String p = pf.getElementName();
                        entry = String.valueOf(p) + "/" + entry;
                        pf = pf.getParent() instanceof IPackageFragment ? (IPackageFragment)pf.getParent() : null;
                    }
                } else if (r != null && r.getPackageFragmentRoot() != null && (root = r.getPackageFragmentRoot()).getJavaProject() != null) {
                    project = root.getJavaProject().getProject();
                }
                IEditorInput result = XModelObjectEditorInput.createJarEntryEditorInput(project, jarFile, entry);
                if (result != null) {
                    return result;
                }
            }
        }
        if ((entryInfo = XModelObjectEditorInput.parseJarEntryFileInput(input)) == null) {
            return input;
        }
        String jarFile = entryInfo[0];
        String entry = entryInfo[1];
        IEditorInput result = XModelObjectEditorInput.createJarEntryEditorInput(null, jarFile, entry);
        return result == null || result instanceof NullEditorInput ? input : result;
    }

    public static String[] parseJarEntryFileInput(IStorageEditorInput input) {
        IStorage storage = null;
        try {
            storage = input.getStorage();
        }
        catch (CoreException coreException) {}
        return storage == null ? null : XModelObjectEditorInput.parseJarEntryFile(storage);
    }

    public static String[] parseJarEntryFile(IStorage storage) {
        if (storage == null) {
            return null;
        }
        String s = storage.toString();
        if (!s.startsWith("JarEntryFile[")) {
            return null;
        }
        int i = (s = s.substring("JarEntryFile[".length())).indexOf("::");
        if (i < 0) {
            return null;
        }
        String jarFile = s.substring(0, i);
        String entry = storage.getFullPath().toString();
        return new String[]{jarFile, entry};
    }

    public static XModelObject getJarEntryObject(IProject p, String jarFile, String entry) {
        XModelObject[] fs;
        if (p == null) {
            IFile f = EclipseResourceUtil.getFile((String)jarFile);
            if (f == null) {
                return null;
            }
            p = f.getProject();
        }
        if (p == null) {
            return null;
        }
        IModelNature n = EclipseResourceUtil.getModelNature((IProject)p);
        XModel model = null;
        if (n != null) {
            model = n.getModel();
        } else {
            XModelObject o = EclipseResourceUtil.createObjectForResource((IResource)p);
            if (o != null) {
                model = o.getModel();
            }
        }
        if (model == null) {
            return null;
        }
        XModelObject[] xModelObjectArray = fs = FileSystemsHelper.getFileSystems((XModel)model).getChildren();
        int n2 = fs.length;
        int n3 = 0;
        while (n3 < n2) {
            XModelObject s = xModelObjectArray[n3];
            String loc = Paths.expand((String)s.get("location"), (Properties)model.getProperties());
            if (new File(loc).equals(new File(jarFile))) {
                int d;
                int q;
                XModelObject result = s.getChildByPath(entry);
                if (result == null && entry != null && (q = entry.indexOf(47)) > (d = entry.indexOf(46)) && d >= 0) {
                    String entry1 = String.valueOf(entry.substring(0, q).replace('.', '/')) + entry.substring(q);
                    result = s.getChildByPath(entry1);
                }
                if (result != null) {
                    return result;
                }
            }
            ++n3;
        }
        return n == null ? null : n.getModel().getByPath("/" + entry);
    }

    public static IEditorInput createJarEntryEditorInput(IProject project, String jarFile, String entry) {
        XModelObject o = XModelObjectEditorInput.getJarEntryObject(project, jarFile, entry);
        if (o != null) {
            return new ModelObjectJarEntryEditorInput(o, jarFile, entry);
        }
        return XModelObjectEditorInputFactory.createNullEditorInput(entry);
    }

    public String getFactoryId() {
        return XModelObjectEditorInputFactory.getFactoryId();
    }

    public void saveState(IMemento memento) {
        XModelObjectEditorInputFactory.saveState(memento, (IFileEditorInput)this);
    }

    public void revalidate() {
        IFile f = this.getFile();
        if (f == null || f.equals((Object)super.getFile())) {
            return;
        }
        try {
            Field field = FileEditorInput.class.getDeclaredField("file");
            field.setAccessible(true);
            field.set(this, f);
        }
        catch (NoSuchFieldException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (IllegalArgumentException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        catch (IllegalAccessException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
    }
}

