/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.IValueChangeListener;
import org.jboss.tools.common.model.ui.IValueEditor;
import org.jboss.tools.common.model.ui.IValueProvider;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.attribute.IPropertyDescriptorEx;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultValueAdapter;
import org.jboss.tools.common.model.ui.attribute.adapter.IModelPropertyEditorAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.EditorMessages;
import org.jboss.tools.common.model.ui.attribute.editor.ExtendedFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyFieldEditor;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;
import org.jboss.tools.common.model.util.AccessibleClasses;
import org.jboss.tools.common.model.util.AccessibleJava;
import org.jboss.tools.common.model.util.ISimpleTree;
import org.jboss.tools.common.model.util.ModelFeatureFactory;
import org.jboss.tools.common.model.util.ModelImages;

public class JavaChoicerFieldEditor
extends ExtendedFieldEditor
implements IFieldEditor,
IPropertyFieldEditor,
IValueEditor,
ModifyListener,
ISelectionChangedListener {
    protected IPropertyEditor propertyEditor;
    protected IValueChangeListener valueChangeListener;
    protected IValueProvider valueProvider;
    protected IPropertyDescriptorEx description;
    private TreeViewer tree;
    private Text text;
    private String stringValue;
    private Composite treeAndText;
    private XModel model;
    private JavaElement rootElement = new JavaRootElement("Java");
    AccessibleJava.IContextPackageProvider cpp = null;
    private static final String ROOT_PATH = "%root%";
    private static final String EMPTY_PATH = "";
    private static final Image ROOT_IMAGE = ModelImages.getImage((String)"images/navigationtree/java.gif");
    private static final Image PACKAGE_IMAGE = JavaPluginImages.get((String)"org.eclipse.jdt.ui.package_obj.gif");
    private static final Image CLASS_IMAGE = JavaPluginImages.get((String)"org.eclipse.jdt.ui.class_obj.gif");
    protected String oldValue = null;
    ISimpleTree list = null;

    public JavaChoicerFieldEditor() {
    }

    public JavaChoicerFieldEditor(IWidgetSettings settings) {
        super(settings);
    }

    public JavaChoicerFieldEditor(String name, String labelText, Composite parent) {
        this.init(name, labelText);
        this.createControl(parent);
    }

    @Override
    protected void adjustForNumColumns(int numColumns) {
        Control control = this.getLabelComposite();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.treeAndText.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Control control = this.getLabelComposite(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        gd.verticalAlignment = 1024;
        control.setLayoutData((Object)gd);
        this.treeAndText = this.getTreeAndTextControl(parent);
        gd = new GridData(1808);
        gd.horizontalSpan = numColumns;
        gd.grabExcessHorizontalSpace = true;
        this.treeAndText.setLayoutData((Object)gd);
    }

    protected void doLoad() {
    }

    protected void doLoadDefault() {
    }

    protected void doStore() {
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected Control createFavoritesChooser(Composite parent) {
        return this.getTreeAndTextControl(parent);
    }

    protected Composite getTreeAndTextControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        composite.setLayout((Layout)layout);
        layout.horizontalSpacing = 7;
        layout.verticalSpacing = 7;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        Label label = new Label(composite, 0);
        label.setText(EditorMessages.getString("JavaChoicerFieldEditor.Tab1.Tree.Label"));
        this.tree = new TreeViewer(composite, 2820);
        GridData gd = new GridData(1808);
        this.tree.getControl().setLayoutData((Object)gd);
        this.tree.setContentProvider((IContentProvider)new ContentProviderEx());
        this.tree.setLabelProvider((IBaseLabelProvider)new LabelProviderEx());
        this.tree.setInput((Object)"Java");
        if (this.stringValue != null && this.stringValue.length() > 0) {
            ISelection selection = this.getSelection(this.stringValue);
            this.tree.setSelection(selection);
        }
        this.tree.addSelectionChangedListener((ISelectionChangedListener)this);
        this.tree.setAutoExpandLevel(2);
        this.tree.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (JavaChoicerFieldEditor.this.getOwnerDialog() != null) {
                    JavaChoicerFieldEditor.this.getOwnerDialog().okPressed();
                }
            }
        });
        label = new Label(composite, 0);
        label.setText(EditorMessages.getString("JavaChoicerFieldEditor.Tab1.Text.Label"));
        this.text = new Text(composite, 2060);
        gd = new GridData(768);
        this.text.setLayoutData((Object)gd);
        this.text.setText(this.valueProvider.getStringValue(true));
        this.text.setSelection(this.valueProvider.getStringValue(true).length());
        this.text.addModifyListener((ModifyListener)this);
        this.text.setFocus();
        return composite;
    }

    private Object getObject(String path) {
        StringTokenizer st = new StringTokenizer(path, ".");
        JavaElement element = this.rootElement;
        String find = EMPTY_PATH;
        while (st.hasMoreTokens()) {
            find = st.nextToken();
            String string = find = element.getPath().equals(this.rootElement.getPath()) ? find : String.valueOf(element.getPath()) + "." + find;
            if (element.getChildByPath(find) == null) {
                int childCount = element.getChildCount();
                int i = 0;
                while (i < childCount) {
                    if (element.getChildAt(i).getPath().startsWith(find)) {
                        return element.getChildAt(i);
                    }
                    ++i;
                }
                return null;
            }
            element = element.getChildByPath(find);
        }
        return element;
    }

    private ISelection getSelection(String path) {
        String pkg;
        Object o = this.getObject(path);
        if (o == null && this.cpp != null && path != null && path.length() > 0 && path.indexOf(46) < 0 && (pkg = this.cpp.getContextPackage()) != null && pkg.length() > 0) {
            o = this.getObject(String.valueOf(pkg) + "." + path);
        }
        return new StructuredSelection(new Object[]{o});
    }

    protected void valueChanged(String newValue) {
        if (newValue != null && !newValue.equals(this.oldValue)) {
            this.text.removeModifyListener((ModifyListener)this);
            if (this.text.getText() != null && !this.text.getText().equals(newValue)) {
                this.text.setText(newValue);
                this.text.setSelection(newValue.length());
            }
            PropertyChangeEvent event = new PropertyChangeEvent(this, "IPropertyEditor.value", this.oldValue, newValue);
            this.valueChangeListener.valueChange(event);
            this.oldValue = newValue;
            this.stringValue = newValue;
            this.text.addModifyListener((ModifyListener)this);
        }
    }

    protected void handleMouseUp(MouseEvent e) {
    }

    @Override
    public void setValueChangeListener(IValueChangeListener valueChangeListener) {
        this.valueChangeListener = valueChangeListener;
    }

    @Override
    public void setValueProvider(IValueProvider valueProvider) {
        this.valueProvider = valueProvider;
    }

    public void modifyText(ModifyEvent e) {
        String newValue = ((Text)e.getSource()).getText();
        this.tree.removeSelectionChangedListener((ISelectionChangedListener)this);
        if (newValue.endsWith(" ")) {
            StructuredSelection selection = (StructuredSelection)this.tree.getSelection();
            JavaElement element = (JavaElement)selection.getFirstElement();
            if (element != null) {
                if (!ROOT_PATH.equals(element.getPath())) {
                    this.valueChanged(element.getPath());
                } else {
                    this.valueChanged(EMPTY_PATH);
                }
                newValue = this.stringValue;
                if (newValue == null) {
                    newValue = EMPTY_PATH;
                }
                this.text.setText(newValue);
                this.text.setSelection(newValue.length());
            }
        } else {
            this.valueChanged(newValue.trim());
        }
        this.tree.setSelection(this.getSelection(((Text)e.getSource()).getText()));
        Object currentObject = this.getObject(((Text)e.getSource()).getText());
        if (currentObject != null) {
            this.tree.expandToLevel(currentObject, 1);
        }
        this.tree.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    protected void init() {
        this.stringValue = this.valueProvider.getStringValue(true);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    @Override
    public void setPropertyEditor(IPropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
        if (propertyEditor != null) {
            this.valueProvider = (IValueProvider)propertyEditor.getAdapter(IValueProvider.class);
            this.valueChangeListener = (IValueChangeListener)propertyEditor.getAdapter(IValueChangeListener.class);
            Object input = propertyEditor.getInput();
            if (input instanceof DefaultValueAdapter) {
                AccessibleJava.IContextPackageProvider cpp;
                this.model = ((DefaultValueAdapter)input).getModel();
                XModelObject xmo = ((DefaultValueAdapter)this.valueProvider).getModelObject();
                XAttribute attr = ((DefaultValueAdapter)this.valueProvider).getAttribute();
                if (attr != null && (cpp = this.getPackageProvider()) != null) {
                    this.cpp = cpp;
                    cpp.setObject(xmo);
                }
            }
        }
        this.init();
    }

    @Override
    public Control[] getControls(Composite parent) {
        return new Control[]{this.getTreeAndTextControl(parent)};
    }

    public void selectionChanged(SelectionChangedEvent event) {
        JavaElement element;
        StructuredSelection selection = (StructuredSelection)event.getSelection();
        JavaElement javaElement = element = selection.isEmpty() ? null : (JavaElement)selection.getFirstElement();
        if (element != null && !ROOT_PATH.equals(element.getPath())) {
            this.valueChanged(element.getPath());
        } else {
            this.valueChanged(EMPTY_PATH);
        }
    }

    @Override
    public void cut() {
    }

    @Override
    public void copy() {
    }

    @Override
    public void paste() {
    }

    @Override
    public void delete() {
    }

    private AccessibleJava.IContextPackageProvider getPackageProvider() {
        IModelPropertyEditorAdapter adapter = (IModelPropertyEditorAdapter)this.propertyEditor.getInput();
        XAttribute a = adapter.getAttribute();
        if (a == null) {
            return null;
        }
        String cls = a.getProperty("contextPackageProvider");
        if (cls == null || cls.length() == 0) {
            return null;
        }
        try {
            AccessibleJava.IContextPackageProvider o = (AccessibleJava.IContextPackageProvider)ModelFeatureFactory.getInstance().createFeatureInstance(cls);
            if (o != null) {
                o.setObject(((DefaultValueAdapter)adapter).getModelObject());
            }
            return o;
        }
        catch (ClassCastException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
            return null;
        }
    }

    class ContentProviderEx
    implements ITreeContentProvider {
        public ContentProviderEx() {
            JavaChoicerFieldEditor.this.list = new AccessibleClasses(JavaChoicerFieldEditor.this.model, true);
        }

        public Object[] getChildren(Object parentElement) {
            return ((JavaElement)parentElement).getChildrens();
        }

        public Object getParent(Object element) {
            if (element instanceof JavaElement) {
                return ((JavaElement)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            return ((JavaElement)element).getChildCount() > 0;
        }

        public Object[] getElements(Object inputElement) {
            JavaChoicerFieldEditor.this.rootElement.check();
            return JavaChoicerFieldEditor.this.rootElement.getChildrens();
        }

        public void dispose() {
            JavaChoicerFieldEditor.this.list = null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class JavaElement {
        protected JavaElement parent = null;
        private boolean isLoaded = false;
        protected String path = "";
        protected String name = "";
        protected boolean isPackage = false;
        private List<JavaElement> children = new ArrayList<JavaElement>();

        protected JavaElement() {
        }

        public JavaElement(String parentpath, String name) {
            this.path = parentpath == null ? name : String.valueOf(parentpath) + "." + name;
            this.name = name;
        }

        public boolean isPackage() {
            return this.isPackage;
        }

        public JavaElement createChild(String name) {
            JavaElement c = new JavaElement(this._getPath(), name);
            c.parent = this;
            return c;
        }

        public Object[] getChildrens() {
            return this.children.toArray(new Object[this.children.size()]);
        }

        public String getPath() {
            return this.path;
        }

        protected String _getPath() {
            return this.path;
        }

        public JavaElement getChildByPath(String path) {
            this.check();
            int i = 0;
            while (i < this.children.size()) {
                JavaElement element = this.children.get(i);
                if (element.getPath().equals(path)) {
                    return element;
                }
                ++i;
            }
            return null;
        }

        protected void check() {
            if (this.isLoaded) {
                return;
            }
            this.isLoaded = true;
            String[] ns = JavaChoicerFieldEditor.this.list.getContent(this.path);
            if (ns == null) {
                return;
            }
            int i = 0;
            while (i < ns.length) {
                String s = ns[i];
                boolean p = s.endsWith(".");
                if (p) {
                    s = s.substring(0, s.length() - 1);
                }
                if (this.isJavaName(s)) {
                    JavaElement c = this.createChild(s);
                    c.isPackage = p;
                    this.children.add(c);
                }
                ++i;
            }
        }

        boolean isJavaName(String name) {
            if (name.length() == 0) {
                return false;
            }
            if (!Character.isJavaIdentifierStart(name.charAt(0))) {
                return false;
            }
            int i = 1;
            while (i < name.length()) {
                if (!Character.isJavaIdentifierPart(name.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public JavaElement getChildAt(int childIndex) {
            this.check();
            return this.children.get(childIndex);
        }

        public int getChildCount() {
            this.check();
            return this.children.size();
        }

        public JavaElement getParent() {
            return this.parent;
        }

        public int getIndex(JavaElement node) {
            this.check();
            int i = 0;
            while (i < this.children.size()) {
                if (this.children.get(i) == node) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public boolean isLeaf() {
            this.check();
            return this.getChildCount() == 0;
        }

        public Iterator<JavaElement> children() {
            return this.children.iterator();
        }

        public String toString() {
            return this.name;
        }
    }

    class JavaRootElement
    extends JavaElement {
        public JavaRootElement(String name) {
            this.path = JavaChoicerFieldEditor.ROOT_PATH;
            this.name = name;
        }

        @Override
        protected String _getPath() {
            return null;
        }
    }

    class LabelProviderEx
    extends LabelProvider {
        LabelProviderEx() {
        }

        public Image getImage(Object element) {
            JavaElement javaElement = (JavaElement)element;
            if (JavaChoicerFieldEditor.ROOT_PATH.equals(javaElement.getPath())) {
                return ROOT_IMAGE;
            }
            if (javaElement.isPackage()) {
                return PACKAGE_IMAGE;
            }
            return CLASS_IMAGE;
        }

        public String getText(Object element) {
            return super.getText(element);
        }
    }
}

