/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.editor;

import java.beans.PropertyChangeListener;
import java.util.Arrays;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.jboss.tools.common.model.ui.IAttributeErrorProvider;
import org.jboss.tools.common.model.ui.IListEditor;
import org.jboss.tools.common.model.ui.IListValueAdapter;
import org.jboss.tools.common.model.ui.ISelectionEditor;
import org.jboss.tools.common.model.ui.IValueChangeListener;
import org.jboss.tools.common.model.ui.IValueEditor;
import org.jboss.tools.common.model.ui.IValueProvider;
import org.jboss.tools.common.model.ui.attribute.IListContentProvider;
import org.jboss.tools.common.model.ui.attribute.editor.ExtendedFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IPropertyFieldEditor;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;

public class ListSelectionFieldEditor
extends ExtendedFieldEditor
implements IFieldEditor,
IValueEditor,
IListEditor,
ISelectionEditor,
IPropertyFieldEditor,
IPropertyChangeListener,
PropertyChangeListener {
    protected ListViewer listViewer;
    protected int style = 2820;
    protected IValueChangeListener valueChangeListener;
    protected IValueProvider valueProvider;
    protected ILabelProvider labelProvider;
    protected IListContentProvider listContentProvider;
    protected IListValueAdapter listValueAdapter;
    protected ISelectionProvider selectionProvider;
    protected ISelectionChangedListener selectionChangedListener;
    IPropertyEditor propertyEditor;
    Object[] elements;
    String[] tags = new String[0];

    public ListSelectionFieldEditor() {
    }

    public ListSelectionFieldEditor(IWidgetSettings settings) {
        super(settings);
    }

    @Override
    protected void adjustForNumColumns(int numColumns) {
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        this.getLabelComposite(parent);
        Control list = this.createListControl(parent);
        GridData gd = new GridData(1808);
        gd.horizontalSpan = --numColumns;
        list.setLayoutData((Object)gd);
    }

    protected void doLoad() {
    }

    protected void doLoadDefault() {
    }

    protected void doStore() {
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected Control getListControl() {
        if (this.listViewer != null) {
            return this.listViewer.getList();
        }
        return null;
    }

    protected Control createListControl(Composite parent) {
        this.listViewer = new ListViewer(parent, this.getStyle());
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.listViewer.setContentProvider((IContentProvider)this.listContentProvider);
        if (this.selectionProvider != null) {
            this.listViewer.setSelection(this.selectionProvider.getSelection());
        }
        if (this.selectionChangedListener != null) {
            this.listViewer.addPostSelectionChangedListener(this.selectionChangedListener);
        }
        this.listViewer.setInput((Object)this);
        if (this.valueProvider != null) {
            String v = ("" + this.valueProvider.getValue()).toString();
            this.listViewer.setSelection((ISelection)new StructuredSelection((Object)v));
        }
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ListSelectionFieldEditor.this.valueChanged();
            }
        });
        return this.listViewer.getList();
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int i) {
        this.style = i;
    }

    @Override
    public void setSelectionChangedListener(ISelectionChangedListener selectionChangedListener) {
        this.selectionChangedListener = selectionChangedListener;
    }

    @Override
    public void setSelectionProvider(ISelectionProvider selectionProvider) {
        this.selectionProvider = selectionProvider;
    }

    @Override
    public void setLabelProvider(ILabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    @Override
    public void setListContentProvider(IListContentProvider listContentProvider) {
        this.listContentProvider = listContentProvider;
    }

    public void setListValueAdapter(IListValueAdapter listValueAdapter) {
        this.listValueAdapter = listValueAdapter;
    }

    @Override
    public void setValueChangeListener(IValueChangeListener valueChangeListener) {
        this.valueChangeListener = valueChangeListener;
    }

    @Override
    public void setValueProvider(IValueProvider valueProvider) {
        this.valueProvider = valueProvider;
    }

    @Override
    public Control[] getControls(Composite parent) {
        return new Control[]{this.getLabelComposite(parent), this.createListControl(parent)};
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.getListControl() != null) {
            this.getListControl().setEnabled(enabled);
        }
    }

    @Override
    public void cut() {
    }

    @Override
    public void copy() {
    }

    @Override
    public void paste() {
    }

    @Override
    public void delete() {
    }

    @Override
    public void setPropertyEditor(IPropertyEditor propertyEditor) {
        this.propertyEditor = propertyEditor;
        if (propertyEditor != null) {
            this.valueProvider = (IValueProvider)propertyEditor.getAdapter(IValueProvider.class);
            this.valueChangeListener = (IValueChangeListener)propertyEditor.getAdapter(IValueChangeListener.class);
            this.labelProvider = (ILabelProvider)propertyEditor.getAdapter(ILabelProvider.class);
            this.listContentProvider = (IListContentProvider)propertyEditor.getAdapter(IListContentProvider.class);
            this.setErrorProvider((IAttributeErrorProvider)propertyEditor.getAdapter(IAttributeErrorProvider.class));
        }
        this.setPropertyChangeListener(this);
        this.valueProvider.addValueChangeListener(this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("field_editor_value".equals(event.getProperty())) {
            this.setPropertyChangeListener(null);
            java.beans.PropertyChangeEvent e = new java.beans.PropertyChangeEvent(this, "IPropertyEditor.value", ListSelectionFieldEditor.mapFromTo(this.tags, this.elements, event.getOldValue()), ListSelectionFieldEditor.mapFromTo(this.tags, this.elements, event.getNewValue()));
            this.valueChangeListener.valueChange(e);
            this.setPropertyChangeListener(this);
        }
    }

    @Override
    public void propertyChange(java.beans.PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if ("IPropertyEditor.value".equals(evt.getPropertyName())) {
            Object v = evt.getNewValue();
            this.valueProvider.removeValueChangeListener(this);
            if (v != null) {
                this.listViewer.setSelection((ISelection)new StructuredSelection(v));
            } else {
                this.listViewer.setSelection((ISelection)new StructuredSelection());
            }
            this.valueProvider.addValueChangeListener(this);
        }
    }

    protected String[] getTags() {
        this.elements = this.listContentProvider.getElements(this);
        this.tags = new String[this.elements.length];
        int i = 0;
        while (i < this.elements.length) {
            this.tags[i] = this.labelProvider.getText(this.elements[i]);
            ++i;
        }
        return this.tags;
    }

    private static Object mapFromTo(Object[] from, Object[] to, Object value) {
        if (from == null || from.length == 0 || to == null || to.length == 0) {
            return value;
        }
        int index = Arrays.asList(from).indexOf(value);
        return index == -1 ? value : to[index];
    }

    protected void valueChanged() {
        this.setPresentsDefaultValue(false);
        String oldValue = "";
        String newValue = this.getSelection();
        this.valueProvider.removeValueChangeListener(this);
        java.beans.PropertyChangeEvent event = new java.beans.PropertyChangeEvent(this, "IPropertyEditor.value", oldValue, newValue);
        this.valueChangeListener.valueChange(event);
        this.valueProvider.addValueChangeListener(this);
    }

    String getSelection() {
        ISelection s = this.listViewer.getSelection();
        if (s == null || s.isEmpty()) {
            return "";
        }
        if (!(s instanceof StructuredSelection)) {
            return "";
        }
        return ((StructuredSelection)s).getFirstElement().toString();
    }
}

