/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.forms;

import org.jboss.tools.common.model.ui.forms.IFormActionData;
import org.jboss.tools.common.model.ui.forms.IFormAttributeData;
import org.jboss.tools.common.model.ui.forms.IFormData;
import org.jboss.tools.common.model.ui.widgets.IWidgetSettings;
import org.jboss.tools.common.model.ui.widgets.WhiteSettings;

public class FormData
implements IFormData {
    private String header;
    private String description;
    private IFormAttributeData[] attributes;
    private String[] entities;
    private IFormActionData[] actions;
    private IFormData[] forms;
    private String entityName;
    private IWidgetSettings widgetSettings;
    private String formClassName;

    public FormData(String header, String description, String entityName, IFormAttributeData[] attributes, String[] entities, IFormActionData[] actions, IFormData[] forms, IWidgetSettings widgetSettings) {
        this.header = header;
        this.description = description;
        this.entityName = entityName;
        this.attributes = attributes;
        this.entities = entities;
        this.actions = actions;
        this.forms = forms;
        this.widgetSettings = widgetSettings;
    }

    public FormData(String header, String description, String entityName, IFormAttributeData[] attributes, String[] entities, IFormActionData[] actions) {
        this(header, description, entityName, attributes, entities, actions, null, WhiteSettings.getWhite());
    }

    public FormData(String header, String description, IFormAttributeData[] attributes, String[] entities, IFormActionData[] actions) {
        this(header, description, null, attributes, entities, actions, null, WhiteSettings.getWhite());
    }

    public FormData(String entityName, String[] entities, IFormData[] forms) {
        this(null, null, entityName, null, entities, null, forms, WhiteSettings.getWhite());
    }

    public FormData(String header, String description, String entityName, IFormAttributeData[] attributes) {
        this(header, description, entityName, attributes, null, null, null, WhiteSettings.getWhite());
    }

    public FormData(String header, String description, IFormAttributeData[] attributes) {
        this(header, description, null, attributes, null, null, null, WhiteSettings.getWhite());
    }

    public FormData(String entityName, IFormData[] forms) {
        this(null, null, entityName, null, null, null, forms, null);
    }

    public FormData(String formClassName) {
        this.formClassName = formClassName;
    }

    @Override
    public IFormAttributeData[] getAttributes() {
        return this.attributes;
    }

    @Override
    public String[] getEntities() {
        return this.entities;
    }

    @Override
    public IFormActionData[] getActions() {
        return this.actions;
    }

    @Override
    public IFormData[] getForms() {
        return this.forms;
    }

    @Override
    public String getEntityName() {
        return this.entityName;
    }

    @Override
    public IWidgetSettings getWidgetSettings() {
        return this.widgetSettings;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getHeader() {
        return this.header;
    }

    @Override
    public String getFormClassName() {
        return this.formClassName;
    }

    @Override
    public boolean isNotLayouredForm() {
        return this.formClassName != null;
    }
}

