/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.widgets.xpl;

import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TypedListener;
import org.jboss.tools.common.model.ui.widgets.xpl.FormLabel;

public class SelectableFormLabel
extends FormLabel {
    private boolean hasFocus;
    private Color passiveColor;
    private Color activeColor;
    private Color disabledColor;
    private Cursor activeCursor;
    boolean hover = false;
    private boolean oldUnderlined;

    public boolean getSelection() {
        return this.hasFocus;
    }

    public SelectableFormLabel(Composite parent, int style) {
        super(parent, style);
        this.setUnderlined(Boolean.TRUE);
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r') {
                    SelectableFormLabel.this.notifyListeners(14);
                }
            }
        });
        this.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                switch (e.detail) {
                    case 4: 
                    case 32: 
                    case 64: 
                    case 256: 
                    case 512: {
                        e.doit = false;
                        return;
                    }
                }
                e.doit = true;
            }
        });
        this.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (!SelectableFormLabel.this.hasFocus) {
                    SelectableFormLabel.this.hasFocus = true;
                    SelectableFormLabel.this.redraw();
                }
            }

            public void mouseUp(MouseEvent e) {
                if (SelectableFormLabel.this.hasFocus) {
                    SelectableFormLabel.this.hasFocus = false;
                    SelectableFormLabel.this.notifyListeners(13);
                    if (!SelectableFormLabel.this.isDisposed()) {
                        SelectableFormLabel.this.redraw();
                    }
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (!SelectableFormLabel.this.hasFocus) {
                    SelectableFormLabel.this.hasFocus = true;
                    SelectableFormLabel.this.notifyListeners(13);
                    SelectableFormLabel.this.redraw();
                }
            }

            public void focusLost(FocusEvent e) {
                if (SelectableFormLabel.this.hasFocus) {
                    SelectableFormLabel.this.hasFocus = false;
                    SelectableFormLabel.this.notifyListeners(13);
                    SelectableFormLabel.this.redraw();
                }
            }
        });
        this.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                SelectableFormLabel.this.hover = true;
                SelectableFormLabel.this.setForeground(SelectableFormLabel.this.activeColor);
                if (SelectableFormLabel.this.activeCursor != null) {
                    SelectableFormLabel.this.setCursor(SelectableFormLabel.this.activeCursor);
                }
                SelectableFormLabel.this.redraw();
            }

            public void mouseExit(MouseEvent e) {
                SelectableFormLabel.this.hover = false;
                SelectableFormLabel.this.setForeground(SelectableFormLabel.this.passiveColor);
                if (SelectableFormLabel.this.activeCursor != null) {
                    SelectableFormLabel.this.setCursor(null);
                }
                SelectableFormLabel.this.redraw();
            }
        });
        this.marginWidth = 1;
        this.marginHeight = 1;
    }

    @Override
    protected void initAccessible() {
        Accessible accessible = this.getAccessible();
        accessible.addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = SelectableFormLabel.this.getText();
            }

            public void getHelp(AccessibleEvent e) {
                e.result = SelectableFormLabel.this.getToolTipText();
            }
        });
        accessible.addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point pt = SelectableFormLabel.this.toControl(new Point(e.x, e.y));
                e.childID = SelectableFormLabel.this.getBounds().contains(pt) ? -1 : -2;
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = SelectableFormLabel.this.getBounds();
                Point pt = SelectableFormLabel.this.toDisplay(new Point(location.x, location.y));
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 43;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = SelectableFormLabel.this.getSelection() ? 2 : 0;
            }
        });
    }

    private void notifyListeners(int eventType) {
        Event event = new Event();
        event.type = eventType;
        event.widget = this;
        this.notifyListeners(eventType, event);
    }

    @Override
    protected void paint(PaintEvent e) {
        super.paint(e);
        if (this.hasFocus) {
            GC gc = e.gc;
            Point size = this.getSize();
            gc.setForeground(this.getForeground());
            gc.drawFocus(0, 0, size.x, size.y);
        }
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            return;
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            return;
        }
        this.removeListener(13, (SWTEventListener)listener);
        this.removeListener(14, (SWTEventListener)listener);
    }

    public void setActiveCursor(Cursor cursor) {
        this.activeCursor = cursor;
    }

    public void setActiveColor(Color color) {
        this.activeColor = color;
    }

    public void setPassiveColor(Color color) {
        this.passiveColor = color;
        this.setForeground(color);
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(Color color) {
        this.disabledColor = color;
    }

    public void setEnabled(boolean enabled) {
        if (this.isEnabled()) {
            this.oldUnderlined = this.isUnderlined();
        }
        super.setEnabled(enabled);
        if (enabled) {
            this.setForeground(this.passiveColor);
            this.setUnderlined(this.oldUnderlined);
            this.setCursor(this.activeCursor);
        } else {
            if (this.disabledColor != null) {
                this.setForeground(this.disabledColor);
            } else {
                this.setForeground(Display.getCurrent().getSystemColor(18));
            }
            this.setUnderlined(Boolean.FALSE);
            this.setCursor(null);
        }
        this.redraw();
    }
}

