/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.command.fshparser;

import java.util.LinkedList;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.command.Execution;
import org.jboss.forge.shell.command.ExecutionParser;
import org.jboss.forge.shell.command.PluginRegistry;
import org.jboss.forge.shell.command.fshparser.AutoReducingQueue;
import org.jboss.forge.shell.command.fshparser.FSHParser;
import org.jboss.forge.shell.command.fshparser.LogicalStatement;
import org.jboss.forge.shell.command.fshparser.Node;
import org.jboss.forge.shell.command.fshparser.PipeNode;
import org.jboss.forge.shell.command.fshparser.ScriptNode;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.util.PipeOutImpl;

@Singleton
public class FSHRuntime {
    private final Shell shell;
    private final PluginRegistry pluginRegistry;
    private final Instance<Execution> executionInstance;
    private final ExecutionParser executionParser;

    @Inject
    public FSHRuntime(Shell shell, PluginRegistry pluginRegistry, Instance<Execution> executionInstance, ExecutionParser executionParser) {
        this.shell = shell;
        this.pluginRegistry = pluginRegistry;
        this.executionInstance = executionInstance;
        this.executionParser = executionParser;
    }

    public void run(String str) {
        this.run(new FSHParser(str).parse(), null);
    }

    public void run(Node startNode, PipeOut forwardPipe) {
        Node n = startNode;
        PipeOutImpl lastPipe = null;
        do {
            if (!(n instanceof LogicalStatement)) {
                if (n instanceof PipeNode) {
                    if (lastPipe == null) {
                        throw new RuntimeException("broken pipe");
                    }
                    this.run(((PipeNode)n).getNest(), lastPipe);
                    continue;
                }
                throw new RuntimeException("badly formed stack:" + n);
            }
            AutoReducingQueue arQueue = new AutoReducingQueue(((LogicalStatement)n).getNest(), this);
            LinkedList<String> outQueue = new LinkedList<String>();
            for (String s : arQueue) {
                if (s == null || s.equals("")) continue;
                outQueue.add(s);
            }
            if (outQueue.isEmpty()) continue;
            PipeOutImpl pipeOut = new PipeOutImpl(this.shell);
            if (n.next != null && n.next instanceof PipeNode) {
                pipeOut.setPiped(true);
                lastPipe = pipeOut;
            }
            Node x = n;
            while (x instanceof LogicalStatement && (x = ((LogicalStatement)x).nest) != null && !(x instanceof ScriptNode) && x.next == null) {
            }
            String pipeIn = forwardPipe != null ? forwardPipe.getBuffer() : null;
            Execution execution = this.executionParser.parse(outQueue, pipeIn, pipeOut);
            execution.verifyConstraints(this.shell);
            execution.perform(forwardPipe);
        } while ((n = n.next) != null);
    }

    public void shell(String command) {
        this.run(command);
    }

    public Shell getShell() {
        return this.shell;
    }

    public PluginRegistry getPluginRegistry() {
        return this.pluginRegistry;
    }

    public Instance<Execution> getExecutionInstance() {
        return this.executionInstance;
    }
}

