/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.protocol.mgmt;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.protocol.ProtocolChannelClient;
import org.jboss.as.protocol.ProtocolConnectionConfiguration;
import org.jboss.as.protocol.ProtocolMessages;
import org.jboss.as.protocol.mgmt.FutureManagementChannel;
import org.jboss.as.protocol.mgmt.ManagementChannelReceiver;
import org.jboss.as.protocol.mgmt.ManagementMessageHandler;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Connection;
import org.xnio.OptionMap;

public abstract class ManagementClientChannelStrategy
implements Closeable {
    private static final String DEFAULT_CHANNEL_SERVICE_TYPE = "management";

    public abstract Channel getChannel() throws IOException;

    public static ManagementClientChannelStrategy create(Channel channel) {
        return new Existing(channel);
    }

    public static ManagementClientChannelStrategy create(ProtocolChannelClient setup, ManagementMessageHandler handler, CallbackHandler cbHandler, Map<String, String> saslOptions, SSLContext sslContext, CloseHandler<Channel> closeHandler) {
        return ManagementClientChannelStrategy.create(ManagementClientChannelStrategy.createConfiguration(setup.getConfiguration(), saslOptions, cbHandler, sslContext), ManagementChannelReceiver.createDelegating(handler), closeHandler);
    }

    public static ManagementClientChannelStrategy create(ProtocolConnectionConfiguration configuration, Channel.Receiver receiver, CloseHandler<Channel> closeHandler) {
        return new Establishing(configuration, receiver, closeHandler);
    }

    private static ProtocolConnectionConfiguration createConfiguration(ProtocolConnectionConfiguration configuration, Map<String, String> saslOptions, CallbackHandler callbackHandler, SSLContext sslContext) {
        ProtocolConnectionConfiguration config = ProtocolConnectionConfiguration.copy(configuration);
        config.setCallbackHandler(callbackHandler);
        config.setSslContext(sslContext);
        config.setSaslOptions(saslOptions);
        return config;
    }

    private static class Establishing
    extends FutureManagementChannel.Establishing {
        private final CloseHandler<Channel> closeHandler;

        private Establishing(ProtocolConnectionConfiguration configuration, Channel.Receiver receiver, CloseHandler<Channel> closeHandler) {
            super(ManagementClientChannelStrategy.DEFAULT_CHANNEL_SERVICE_TYPE, receiver, configuration);
            this.closeHandler = closeHandler;
        }

        @Override
        protected Channel openChannel(Connection connection, String serviceType, OptionMap options) throws IOException {
            Channel channel = super.openChannel(connection, serviceType, options);
            channel.addCloseHandler(this.closeHandler);
            return channel;
        }
    }

    private static class Existing
    extends ManagementClientChannelStrategy {
        private final Channel channel;
        private volatile boolean closed = false;

        private Existing(Channel channel) {
            this.channel = channel;
        }

        @Override
        public Channel getChannel() throws IOException {
            if (this.closed) {
                throw ProtocolMessages.MESSAGES.channelClosed();
            }
            return this.channel;
        }

        @Override
        public void close() {
            this.closed = true;
        }
    }
}

