/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import javax.faces.context.FacesContext;
import org.richfaces.component.LastElementAware;
import org.richfaces.component.TreeRowKey;
import org.richfaces.component.UITree;

public abstract class TreeDataModelEventNavigator
implements LastElementAware {
    private TreeRowKey floatingKey;
    protected boolean lastElement = false;
    protected boolean actualLast = false;
    protected Boolean stackedLast = null;
    private TreeRowKey rowKey;
    private UITree tree;
    private FacesContext facesContext;

    public TreeDataModelEventNavigator(UITree tree, FacesContext context, TreeRowKey floatingKey) {
        this.tree = tree;
        this.rowKey = (TreeRowKey)this.tree.getRowKey();
        this.facesContext = context;
        this.floatingKey = floatingKey;
    }

    public void followRowKey(TreeRowKey newRowKey) throws IOException {
        this.actualLast = this.lastElement;
        this.resetLastElement();
        if (newRowKey != null) {
            int level = this.rowKey != null ? this.rowKey.depth() : 0;
            int delta = level - newRowKey.depth();
            if (delta > 0) {
                this.beforeUp(delta);
            } else if (delta < 0) {
                if (delta == -1) {
                    this.beforeDown();
                } else {
                    throw new IllegalArgumentException("One or more nodes skipped in falldown - maybe illegal RowKey, incorrect model or model handler!");
                }
            }
            this.stackedLast = new Boolean(this.actualLast);
            this.tree.setRowKey(newRowKey);
            if (delta > 0) {
                this.afterUp(delta);
            } else if (delta == -1) {
                this.afterDown();
            }
        } else {
            this.stackedLast = null;
            int level = 0;
            if (this.rowKey != null) {
                level = this.rowKey.depth();
                if (this.floatingKey != null) {
                    level -= this.floatingKey.depth();
                }
                if (level != 0) {
                    this.beforeUp(level);
                }
            }
            this.tree.setRowKey(null);
            if (level != 0) {
                this.afterUp(level);
            }
        }
        this.rowKey = newRowKey;
    }

    public abstract void beforeUp(int var1) throws IOException;

    public abstract void beforeDown() throws IOException;

    public abstract void afterUp(int var1) throws IOException;

    public abstract void afterDown() throws IOException;

    protected UITree getTree() {
        return this.tree;
    }

    protected FacesContext getFacesContext() {
        return this.facesContext;
    }

    public void setLastElement() {
        this.lastElement = true;
    }

    public void resetLastElement() {
        this.lastElement = false;
    }

    protected TreeRowKey getRowKey() {
        return this.rowKey;
    }

    protected boolean isLastElement() {
        return this.lastElement;
    }

    protected boolean isStackedLastElement() {
        if (this.stackedLast != null) {
            return this.stackedLast;
        }
        return false;
    }
}

