/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html.images;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Date;
import javax.faces.context.FacesContext;
import org.ajax4jsf.framework.resource.GifRenderer;
import org.ajax4jsf.framework.resource.InternetResourceBuilder;
import org.ajax4jsf.framework.resource.Java2Dresource;
import org.ajax4jsf.framework.resource.ResourceContext;
import org.ajax4jsf.framework.resource.ResourceRenderer;
import org.ajax4jsf.framework.skin.Skin;
import org.ajax4jsf.framework.skin.SkinFactory;
import org.ajax4jsf.framework.util.HtmlColor;

public class ModalPanelGridSeparatorImage
extends Java2Dresource {
    public ModalPanelGridSeparatorImage() {
        this.setRenderer((ResourceRenderer)new GifRenderer());
        this.setLastModified(new Date(InternetResourceBuilder.getInstance().getStartTime()));
    }

    protected Object getDataToStore(FacesContext context, Object data) {
        Data separatorData = new Data();
        Skin skin = SkinFactory.getInstance().getSkin(context);
        String tmp = (String)skin.getParameter(context, "headerBackgroundColor");
        separatorData.setHeaderBackgroundColor(HtmlColor.decode((String)(tmp == null ? "#224986" : tmp)).getRGB());
        separatorData.setSeparatorHeight(20);
        return separatorData;
    }

    protected Dimension getDimensions(ResourceContext resourceContext) {
        return this.calculateDimension((Data)this.restoreData(resourceContext));
    }

    public Dimension getDimensions(FacesContext facesContext, Object data) {
        return this.calculateDimension((Data)this.getDataToStore(facesContext, data));
    }

    protected void paint(ResourceContext context, Graphics2D g2d) {
        Data separatorData = (Data)this.restoreData(context);
        Dimension dimensions = this.calculateDimension(separatorData);
        BufferedImage texture = new BufferedImage(3, 3, 2);
        Graphics2D txG2d = texture.createGraphics();
        txG2d.setColor(new Color(separatorData.getHeaderBackgroundColor()));
        txG2d.fillRect(0, 0, 2, 2);
        txG2d.setColor(new Color(255, 255, 255, 150));
        txG2d.fillRect(0, 0, 1, 1);
        txG2d.dispose();
        g2d.setPaint(new TexturePaint(texture, new Rectangle(1, 1, 3, 3)));
        g2d.fillRect(0, 0, dimensions.width, dimensions.height);
    }

    private Dimension calculateDimension(Data separatorData) {
        int h = separatorData.getSeparatorHeight();
        int w = 9;
        return new Dimension(w, h);
    }

    protected static class Data
    implements Serializable {
        private static final long serialVersionUID = -6367074056069548706L;
        private int headerBackgroundColor;
        private int separatorHeight;

        protected Data() {
        }

        public int getHeaderBackgroundColor() {
            return this.headerBackgroundColor;
        }

        public void setHeaderBackgroundColor(int bgColor) {
            this.headerBackgroundColor = bgColor;
        }

        public int getSeparatorHeight() {
            return this.separatorHeight;
        }

        public void setSeparatorHeight(int separatorHeight) {
            this.separatorHeight = separatorHeight;
        }
    }
}

