/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino.util.resource;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.zip.ZipFile;
import org.codehaus.janino.util.iterator.EnumerationIterator;
import org.codehaus.janino.util.iterator.TransformingIterator;
import org.codehaus.janino.util.resource.DirectoryResourceFinder;
import org.codehaus.janino.util.resource.LazyMultiResourceFinder;
import org.codehaus.janino.util.resource.MultiResourceFinder;
import org.codehaus.janino.util.resource.ResourceFinder;
import org.codehaus.janino.util.resource.ZipFileResourceFinder;

public class PathResourceFinder
extends LazyMultiResourceFinder {
    public PathResourceFinder(String string) {
        this(new EnumerationIterator(new StringTokenizer(string, File.pathSeparator)));
    }

    public PathResourceFinder(Iterator iterator) {
        super(iterator);
    }

    public PathResourceFinder(File[] fileArray) {
        super(PathResourceFinder.createIterator(Arrays.asList(fileArray).iterator()));
    }

    private static Iterator createIterator(Iterator iterator) {
        return new TransformingIterator(iterator){

            protected Object transform(Object object) {
                return PathResourceFinder.createResourceFinder((File)object);
            }
        };
    }

    private static ResourceFinder createResourceFinder(File file) {
        if ((file.getName().endsWith(".jar") || file.getName().endsWith(".zip")) && file.isFile()) {
            try {
                return new ZipFileResourceFinder(new ZipFile(file));
            }
            catch (IOException iOException) {
                return MultiResourceFinder.EMPTY_RESOURCE_FINDER;
            }
        }
        if (file.isDirectory()) {
            return new DirectoryResourceFinder(file);
        }
        return MultiResourceFinder.EMPTY_RESOURCE_FINDER;
    }

    public static File[] parsePath(String string) {
        int n = 0;
        ArrayList<File> arrayList = new ArrayList<File>();
        while (true) {
            int n2;
            if ((n2 = string.indexOf(File.pathSeparatorChar, n)) == -1) {
                if (n == string.length()) break;
                arrayList.add(new File(string.substring(n)));
                break;
            }
            if (n2 != n) {
                arrayList.add(new File(string.substring(n, n2)));
            }
            n = n2 + 1;
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }
}

