/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.resource;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.primefaces.resource.stream.CSSResourceStreamer;
import org.primefaces.resource.stream.DefaultResourceStreamer;
import org.primefaces.resource.stream.ResourceStreamer;

public class ResourceServlet
extends HttpServlet {
    private static final Logger logger = Logger.getLogger(ResourceServlet.class.getName());
    private static Map<String, String> mimeTypes;
    private List<ResourceStreamer> resourceStreamers;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.initMimeTypes();
        this.initResourceStreamers();
    }

    private void initMimeTypes() {
        mimeTypes = new HashMap<String, String>();
        mimeTypes.put("css", "text/css");
        mimeTypes.put("js", "text/js");
        mimeTypes.put("jpg", "image/jpeg");
        mimeTypes.put("jpeg", "image/jpeg");
        mimeTypes.put("png", "image/png");
        mimeTypes.put("gif", "image/gif");
        mimeTypes.put("swf", "application/x-shockwave-flash");
    }

    private void initResourceStreamers() {
        this.resourceStreamers = new ArrayList<ResourceStreamer>();
        this.resourceStreamers.add(new DefaultResourceStreamer());
        this.resourceStreamers.add(new CSSResourceStreamer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String resourcePath = "/META-INF/resources" + this.getResourcePath(req.getRequestURI());
        URL url = ResourceServlet.class.getResource(resourcePath);
        if (url == null) {
            logger.log(Level.SEVERE, "Resource \"{0}\" not found", resourcePath);
            resp.sendError(404);
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Streaming resource \"{0}\"", resourcePath);
        }
        InputStream inputStream = null;
        try {
            inputStream = ResourceServlet.class.getResourceAsStream(resourcePath);
            String mimeType = this.getResourceContentType(resourcePath);
            resp.setContentType(mimeType);
            resp.setStatus(200);
            this.setCaching(resp);
            this.streamResource(req, resp, mimeType, inputStream);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Resource \"{0}\" streamed succesfully", resourcePath);
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "Error in streaming resource \"{0}\". Exception is \"{1}\"", new Object[]{resourcePath, exception.getMessage()});
        }
        finally {
            inputStream.close();
            resp.getOutputStream().flush();
            resp.getOutputStream().close();
        }
    }

    private void streamResource(HttpServletRequest req, HttpServletResponse resp, String mimeType, InputStream inputStream) throws IOException {
        for (ResourceStreamer streamer : this.resourceStreamers) {
            if (!streamer.isAppropriateStreamer(mimeType)) continue;
            streamer.stream(req, resp, inputStream);
        }
    }

    private void setCaching(HttpServletResponse response) {
        long now = System.currentTimeMillis();
        long oneYear = 31363200000L;
        response.setHeader("Cache-Control", "Public");
        response.setDateHeader("Expires", now + oneYear);
    }

    protected String getResourcePath(String requestURI) {
        int patternIndex = requestURI.indexOf("/primefaces_resource/2.0.0.RC");
        return requestURI.substring(patternIndex + "/primefaces_resource/2.0.0.RC".length(), requestURI.length());
    }

    protected String getResourceContentType(String resourcePath) {
        String resourceFileExtension = this.getResourceFileExtension(resourcePath);
        return mimeTypes.get(resourceFileExtension);
    }

    protected String getResourceFileExtension(String resourcePath) {
        String[] parsed = resourcePath.split("\\.");
        return parsed[parsed.length - 1];
    }
}

