/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.component;

import javax.el.ELContext;
import javax.el.MethodExpression;
import javax.el.ValueExpression;
import javax.faces.component.StateHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import org.ajax4jsf.Messages;
import org.ajax4jsf.component.AjaxContainerBase;
import org.ajax4jsf.event.AjaxEvent;
import org.richfaces.log.RichfacesLogger;
import org.slf4j.Logger;

public class AjaxRegionBrige
implements AjaxContainerBase,
StateHolder {
    private static final Logger log = RichfacesLogger.COMPONENTS.getLogger();
    private MethodExpression ajaxListener = null;
    private boolean immediate = false;
    private boolean immediateSet = false;
    private boolean selfRendered = false;
    private boolean selfRenderedSet = false;
    private boolean transientFlag = false;
    private UIComponent component;
    private boolean submitted = false;

    public AjaxRegionBrige(UIComponent component) {
        this.component = component;
    }

    public MethodExpression getAjaxListener() {
        return this.ajaxListener;
    }

    public void setAjaxListener(MethodExpression ajaxListener) {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage((String)"SET_AJAX_LISTENER", (Object)ajaxListener.getExpressionString()));
        }
        this.ajaxListener = ajaxListener;
    }

    public boolean isImmediate() {
        if (this.immediateSet) {
            return this.immediate;
        }
        ValueExpression vb = this.component.getValueExpression("immediate");
        if (vb != null) {
            return Boolean.TRUE.equals(vb.getValue(FacesContext.getCurrentInstance().getELContext()));
        }
        return this.immediate;
    }

    public void setImmediate(boolean immediate) {
        if (immediate != this.immediate) {
            this.immediate = immediate;
        }
        this.immediateSet = true;
    }

    public boolean isSelfRendered() {
        if (this.selfRenderedSet) {
            return this.selfRendered;
        }
        ValueExpression vb = this.component.getValueExpression("selfRendered");
        if (vb != null) {
            return Boolean.TRUE.equals(vb.getValue(FacesContext.getCurrentInstance().getELContext()));
        }
        return this.selfRendered;
    }

    public void setSelfRendered(boolean selfRendered) {
        this.selfRendered = selfRendered;
        this.selfRenderedSet = true;
    }

    public boolean isSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(boolean submitted) {
        if (log.isDebugEnabled() && submitted && !this.isSubmitted()) {
            log.debug(Messages.getMessage((String)"SUBMITTED_AJAX_REQUEST"));
        }
        this.submitted = submitted;
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (event instanceof AjaxEvent) {
            MethodExpression mb;
            if (log.isDebugEnabled()) {
                log.debug(Messages.getMessage((String)"SEND_EVENT_TO_AJAX_LISTENER", (Object)this.component.getId()));
            }
            if ((mb = this.getAjaxListener()) != null) {
                FacesContext context = FacesContext.getCurrentInstance();
                ELContext elContext = context.getELContext();
                mb.invoke(elContext, new Object[]{event});
            }
        }
    }

    public void restoreState(FacesContext context, Object state) {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage((String)"RESTORE_AJAX_COMPONENT_STATE", (Object)this.component.getId()));
        }
        Object[] values = (Object[])state;
        this.immediate = (Boolean)values[0];
        this.immediateSet = (Boolean)values[1];
        this.ajaxListener = (MethodExpression)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)values[2]);
        this.selfRendered = (Boolean)values[3];
        this.selfRenderedSet = (Boolean)values[4];
    }

    public Object saveState(FacesContext context) {
        if (log.isDebugEnabled()) {
            log.debug(Messages.getMessage((String)"SAVE_AJAX_COMPONENT_STATE", (Object)this.component.getId()));
        }
        Object[] values = new Object[]{this.immediate, this.immediateSet, UIComponentBase.saveAttachedState((FacesContext)context, (Object)this.ajaxListener), this.selfRendered, this.selfRenderedSet};
        return values;
    }

    public boolean isTransient() {
        return this.transientFlag;
    }

    public void setTransient(boolean transientFlag) {
        this.transientFlag = transientFlag;
    }
}

