/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.framework.ajax.xmlfilter;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.ajax4jsf.framework.ajax.xmlfilter.BaseXMLFilter;
import org.ajax4jsf.framework.ajax.xmlfilter.Log4JConfigurator;
import org.ajax4jsf.framework.resource.InternetResourceService;
import org.ajax4jsf.framework.util.message.Messages;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseFilter
implements Filter {
    private static final Log log = LogFactory.getLog((Class)BaseFilter.class);
    public static final boolean DEBUG = true;
    private FilterConfig filterConfig;
    private static final String FUNCTION_NAME_PARAMETER = "function";
    private String function = "alert('Data received');JSHttpRequest.dataReady";
    private String attributesNames;
    private boolean rewriteid = false;
    private static final String REWRITEID_PARAMETER = "rewriteid";
    private static final String STYLESHEET_PARAMETER = "xsl";
    private static final String ABSOLUTE_TAGS_PARAMETER = "absolute-attributes";
    private static final long serialVersionUID = -2295534611886142935L;
    public static final String DATA_PARAMETER = "DATA";
    public static final String DEFAULT_SERVLET_PATH = "/resource";
    public static final String RENDERER_PREFIX = "/renderer";
    public static final String CACHEABLE_PREFIX = "/cache";
    public static final String FILTER_PERFORMED = "com.exade.vcp.Filter.done";
    public static final String RESPONSE_WRAPPER_ATTRIBUTE = "com.exade.vcp.Filter.ResponseWrapper";
    protected BaseXMLFilter xmlFilter = null;
    InternetResourceService resourceService = null;

    public void init(FilterConfig config) throws ServletException {
        this.filterConfig = config;
        this.setFunction((String)this.nz(this.filterConfig.getInitParameter(FUNCTION_NAME_PARAMETER), this.getFunction()));
        this.setAttributesNames(this.filterConfig.getInitParameter(ABSOLUTE_TAGS_PARAMETER));
        this.xmlFilter.init(config);
        if ("true".equalsIgnoreCase(this.filterConfig.getInitParameter(REWRITEID_PARAMETER))) {
            this.setRewriteid(true);
        }
        String prefix = this.filterConfig.getServletContext().getRealPath("/");
        String file = this.filterConfig.getInitParameter("log4j-init-file");
        if (file != null) {
            Log4JConfigurator log4jconfig = new Log4JConfigurator(prefix);
            log4jconfig.doConfigure(file);
        }
    }

    protected void setupRequestEncoding(HttpServletRequest httpServletRequest) throws UnsupportedEncodingException {
        String contentType = httpServletRequest.getHeader("Content-Type");
        String characterEncoding = this.lookupCharacterEncoding(contentType);
        if (characterEncoding == null) {
            HttpSession session = httpServletRequest.getSession(false);
            if (session != null) {
                characterEncoding = (String)session.getAttribute("javax.faces.request.charset");
            }
            if (characterEncoding != null) {
                httpServletRequest.setCharacterEncoding(characterEncoding);
            }
        }
    }

    private String lookupCharacterEncoding(String contentType) {
        String characterEncoding = null;
        if (contentType != null) {
            int charsetFind = contentType.indexOf("charset=");
            if (charsetFind != -1) {
                if (charsetFind == 0) {
                    characterEncoding = contentType.substring(8);
                } else {
                    char charBefore = contentType.charAt(charsetFind - 1);
                    if (charBefore == ';' || Character.isWhitespace(charBefore)) {
                        characterEncoding = contentType.substring(charsetFind + 8);
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)Messages.getMessage(Messages.CONTENT_TYPE_ENCODING, characterEncoding));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage(Messages.CONTENT_TYPE_NO_ENCODING, contentType));
            }
        }
        return characterEncoding;
    }

    private Object nz(Object param, Object def) {
        return param != null ? param : def;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        long startTimeMills = 0L;
        HttpServletRequest httpServletRequest = (HttpServletRequest)request;
        HttpServletResponse httpServletResponse = (HttpServletResponse)response;
        if (log.isDebugEnabled()) {
            startTimeMills = System.currentTimeMillis();
            log.debug((Object)Messages.getMessage(Messages.FILTER_START_INFO, new Date(startTimeMills), httpServletRequest.getRequestURI()));
        }
        if (request.getAttribute(FILTER_PERFORMED) != Boolean.TRUE) {
            request.setAttribute(FILTER_PERFORMED, (Object)Boolean.TRUE);
            if (!this.getResourceService().serviceResource(httpServletRequest, httpServletResponse)) {
                this.setupRequestEncoding(httpServletRequest);
                if (log.isDebugEnabled()) {
                    log.debug((Object)Messages.getMessage(Messages.FILTER_XML_OUTPUT));
                }
                this.xmlFilter.doXmlFilter(chain, httpServletRequest, httpServletResponse);
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)Messages.getMessage(Messages.FILTER_NO_XML_CHAIN_2));
            }
            chain.doFilter(request, response);
        }
        if (log.isDebugEnabled()) {
            startTimeMills = System.currentTimeMillis() - startTimeMills;
            log.debug((Object)Messages.getMessage(Messages.FILTER_STOP_INFO, "" + startTimeMills, httpServletRequest.getRequestURI()));
        }
    }

    protected boolean isAjaxRequest(ServletRequest request) {
        try {
            return null != request.getParameter("AJAXREQUEST");
        }
        catch (Exception e) {
            return false;
        }
    }

    public void destroy() {
    }

    ServletContext getServletContext() {
        return this.filterConfig.getServletContext();
    }

    protected synchronized InternetResourceService getResourceService() throws ServletException {
        if (this.resourceService == null) {
            this.resourceService = new InternetResourceService();
            this.resourceService.init(this.filterConfig);
        }
        return this.resourceService;
    }

    protected void setFunction(String function) {
        this.function = function;
    }

    protected String getFunction() {
        return this.function;
    }

    protected void setRewriteid(boolean rewriteid) {
        this.rewriteid = rewriteid;
    }

    protected boolean isRewriteid() {
        return this.rewriteid;
    }

    protected void setAttributesNames(String attributesNames) {
        this.attributesNames = attributesNames;
    }

    protected String getAttributesNames() {
        return this.attributesNames;
    }
}

