/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.pdf;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.pdf.DocumentData;

@Name(value="org.jboss.seam.pdf.documentStore")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=0)
public class DocumentStore
implements Serializable {
    private static final long serialVersionUID = -357154201942127711L;
    Map<String, DocumentData> dataStore = new HashMap<String, DocumentData>();
    long nextId = 1L;
    boolean useExtensions = false;
    String errorPage = null;

    public void setUseExtensions(boolean useExtensions) {
        this.useExtensions = useExtensions;
    }

    public void setErrorPage(String errorPage) {
        this.errorPage = errorPage;
    }

    public String getErrorPage() {
        return this.errorPage;
    }

    public String newId() {
        return String.valueOf(this.nextId++);
    }

    public void saveData(String id, DocumentData documentData) {
        this.dataStore.put(id, documentData);
    }

    public boolean idIsValid(String id) {
        return this.dataStore.get(id) != null;
    }

    public DocumentData getDocumentData(String id) {
        return this.dataStore.get(id);
    }

    public static DocumentStore instance() {
        return (DocumentStore)Component.getInstance(DocumentStore.class, (boolean)true);
    }

    public String preferredUrlForContent(String baseName, DocumentData.DocType docType, String contentId) {
        String baseUrl = "seam-doc.seam";
        if (this.useExtensions) {
            baseUrl = baseName + "." + docType.getExtension();
        }
        return baseUrl + "?docId=" + contentId;
    }
}

