/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.drools.rule.Declaration;
import org.drools.spi.ColumnExtractor;
import org.drools.spi.Extractor;
import org.drools.spi.FieldConstraint;
import org.drools.spi.ObjectType;

public class Column
implements Serializable {
    private static final long serialVersionUID = 9167552040211010022L;
    private final ObjectType objectType;
    private List constraints = Collections.EMPTY_LIST;
    final Declaration declaration;
    private final int index;
    private int offset;

    public Column(int n, ObjectType objectType) {
        this(n, 0, objectType, null);
    }

    public Column(int n, ObjectType objectType, String string) {
        this(n, 0, objectType, string);
    }

    public Column(int n, int n2, ObjectType objectType, String string) {
        this.index = n;
        this.offset = n2;
        this.objectType = objectType;
        this.declaration = string != null ? new Declaration(string, new ColumnExtractor(objectType), this.getFactIndex()) : null;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public List getConstraints() {
        return Collections.unmodifiableList(this.constraints);
    }

    public void addConstraint(FieldConstraint fieldConstraint) {
        if (this.constraints == Collections.EMPTY_LIST) {
            this.constraints = new ArrayList(1);
        }
        this.constraints.add(fieldConstraint);
    }

    public Declaration addDeclaration(String string, Extractor extractor) {
        if (this.constraints == Collections.EMPTY_LIST) {
            this.constraints = new ArrayList(1);
        }
        Declaration declaration = new Declaration(string, extractor, this.getFactIndex());
        this.constraints.add(declaration);
        return declaration;
    }

    public boolean isBound() {
        return this.declaration != null;
    }

    public Declaration getDeclaration() {
        return this.declaration;
    }

    public int getIndex() {
        return this.index;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getFactIndex() {
        return this.index + this.offset;
    }

    public void adjustOffset(int n) {
        this.offset += n;
        if (this.declaration != null) {
            this.declaration.setColumn(this.getFactIndex());
        }
        Iterator iterator = this.constraints.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Declaration)) continue;
            ((Declaration)e).setColumn(this.getFactIndex());
        }
    }

    public String toString() {
        return "Column type='" + this.objectType + "', index='" + this.index + "', offset='" + this.getOffset() + "', identifer='" + this.declaration.getIdentifier() + "'";
    }
}

