/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.persistence.Persistence;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.util.Naming;

@Scope(value=ScopeType.APPLICATION)
@Intercept(value=InterceptionType.NEVER)
@Startup(depends={"org.jboss.seam.core.microcontainer"})
public class EntityManagerFactory {
    private String persistenceUnitName;
    private Map persistenceUnitProperties;
    private javax.persistence.EntityManagerFactory entityManagerFactory;

    @Unwrap
    public javax.persistence.EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    @Create
    public void startup(Component component) throws Exception {
        if (this.persistenceUnitName == null) {
            this.persistenceUnitName = component.getName();
        }
        HashMap properties = new HashMap();
        Hashtable jndiProperties = Naming.getInitialContextProperties();
        if (jndiProperties != null) {
            for (Map.Entry entry : jndiProperties.entrySet()) {
                properties.put("hibernate.jndi." + (String)entry.getKey(), entry.getValue());
            }
        }
        if (this.persistenceUnitProperties != null) {
            properties.putAll(this.persistenceUnitProperties);
        }
        this.entityManagerFactory = properties.isEmpty() ? Persistence.createEntityManagerFactory((String)this.persistenceUnitName) : Persistence.createEntityManagerFactory((String)this.persistenceUnitName, properties);
    }

    @Destroy
    public void shutdown() {
        if (this.entityManagerFactory != null) {
            this.entityManagerFactory.close();
        }
    }

    public String getPersistenceUnitName() {
        return this.persistenceUnitName;
    }

    public void setPersistenceUnitName(String persistenceUnitName) {
        this.persistenceUnitName = persistenceUnitName;
    }

    public Map getPersistenceUnitProperties() {
        return this.persistenceUnitProperties;
    }

    public void setPersistenceUnitProperties(Map persistenceUnitProperties) {
        this.persistenceUnitProperties = persistenceUnitProperties;
    }
}

