/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.ContextAdaptor;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.contexts.Lifecycle;
import org.jboss.seam.core.Conversation;
import org.jboss.seam.core.ConversationEntries;
import org.jboss.seam.core.ConversationEntry;
import org.jboss.seam.core.Events;
import org.jboss.seam.core.FacesPage;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.core.Pageflow;
import org.jboss.seam.core.Pages;
import org.jboss.seam.core.RedirectException;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.pages.ConversationIdParameter;
import org.jboss.seam.pages.Page;
import org.jboss.seam.util.Id;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.EVENT)
@Name(value="org.jboss.seam.core.manager")
@Install(precedence=0)
@Intercept(value=InterceptionType.NEVER)
public class Manager {
    private static final LogProvider log = Logging.getLogProvider(Manager.class);
    private String currentConversationId;
    private List<String> currentConversationIdStack;
    private boolean isLongRunningConversation;
    private boolean controllingRedirect;
    private boolean destroyBeforeRedirect;
    private int conversationTimeout = 600000;
    private int concurrentRequestTimeout = 1000;
    private String conversationIdParameter = "conversationId";
    private String parentConversationIdParameter = "parentConversationId";
    private String conversationIsLongRunningParameter = "conversationIsLongRunning";
    private ConversationEntry currentConversationEntry;

    public String getCurrentConversationId() {
        return this.currentConversationId;
    }

    public void setCurrentConversationId(String id) {
        this.currentConversationId = id;
        this.currentConversationEntry = null;
    }

    public void updateCurrentConversationId(String id) {
        if (ConversationEntries.instance().getConversationIds().contains(id)) {
            throw new IllegalStateException("Conversation id is already in use");
        }
        String[] names = Contexts.getConversationContext().getNames();
        Object[] values = new Object[names.length];
        for (int i = 0; i < names.length; ++i) {
            values[i] = Contexts.getConversationContext().get(names[i]);
            Contexts.getConversationContext().remove(names[i]);
        }
        Contexts.getConversationContext().flush();
        ConversationEntry ce = ConversationEntries.instance().updateConversationId(this.currentConversationId, id);
        this.setCurrentConversationId(id);
        if (ce != null) {
            this.setCurrentConversationIdStack(ce.getConversationIdStack());
        }
        for (int i = 0; i < names.length; ++i) {
            Contexts.getConversationContext().set(names[i], values[i]);
        }
    }

    private static void touchConversationStack(List<String> stack) {
        if (stack != null) {
            ListIterator<String> iter = stack.listIterator(stack.size());
            while (iter.hasPrevious()) {
                String conversationId = iter.previous();
                ConversationEntry conversationEntry = ConversationEntries.instance().getConversationEntry(conversationId);
                if (conversationEntry == null) continue;
                conversationEntry.touch();
            }
        }
    }

    private static void endNestedConversations(String id) {
        for (ConversationEntry ce : ConversationEntries.instance().getConversationEntries()) {
            if (!ce.getConversationIdStack().contains(id)) continue;
            ce.end();
        }
    }

    public Object getCurrentConversationInitiator() {
        ConversationEntry ce = this.getCurrentConversationEntry();
        if (ce != null) {
            return ce.getInitiatorComponentName();
        }
        return null;
    }

    public List<String> getCurrentConversationIdStack() {
        return this.currentConversationIdStack;
    }

    public void setCurrentConversationIdStack(List<String> stack) {
        this.currentConversationIdStack = stack;
    }

    private List<String> createCurrentConversationIdStack(String id) {
        this.currentConversationIdStack = new ArrayList<String>();
        this.currentConversationIdStack.add(id);
        return this.currentConversationIdStack;
    }

    public String getCurrentConversationDescription() {
        ConversationEntry ce = this.getCurrentConversationEntry();
        if (ce == null) {
            return null;
        }
        return ce.getDescription();
    }

    public Integer getCurrentConversationTimeout() {
        ConversationEntry ce = this.getCurrentConversationEntry();
        if (ce == null) {
            return null;
        }
        return ce.getTimeout();
    }

    public String getCurrentConversationViewId() {
        ConversationEntry ce = this.getCurrentConversationEntry();
        if (ce == null) {
            return null;
        }
        return ce.getViewId();
    }

    public String getParentConversationViewId() {
        ConversationEntry conversationEntry = ConversationEntries.instance().getConversationEntry(this.getParentConversationId());
        return conversationEntry == null ? null : conversationEntry.getViewId();
    }

    public String getParentConversationId() {
        return this.currentConversationIdStack == null || this.currentConversationIdStack.size() < 2 ? null : this.currentConversationIdStack.get(1);
    }

    public String getRootConversationId() {
        return this.currentConversationIdStack == null || this.currentConversationIdStack.size() < 1 ? null : this.currentConversationIdStack.get(this.currentConversationIdStack.size() - 1);
    }

    public boolean isLongRunningConversation() {
        return this.isLongRunningConversation;
    }

    public boolean isLongRunningOrNestedConversation() {
        return this.isLongRunningConversation() || this.isNestedConversation();
    }

    public boolean isReallyLongRunningConversation() {
        return this.isLongRunningConversation() && !this.getCurrentConversationEntry().isRemoveAfterRedirect() && !Seam.isSessionInvalid();
    }

    public boolean isNestedConversation() {
        return this.currentConversationIdStack != null && this.currentConversationIdStack.size() > 1;
    }

    public void setLongRunningConversation(boolean isLongRunningConversation) {
        this.isLongRunningConversation = isLongRunningConversation;
    }

    public static Manager instance() {
        if (!Contexts.isEventContextActive()) {
            throw new IllegalStateException("No active event context");
        }
        Manager instance = (Manager)Component.getInstance(Manager.class, ScopeType.EVENT);
        if (instance == null) {
            throw new IllegalStateException("No Manager could be created, make sure the Component exists in application scope");
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void conversationTimeout(ContextAdaptor session) {
        long currentTime = System.currentTimeMillis();
        ArrayList<ConversationEntry> entries = new ArrayList<ConversationEntry>(ConversationEntries.instance().getConversationEntries());
        for (ConversationEntry conversationEntry : entries) {
            boolean locked = conversationEntry.lockNoWait();
            try {
                long delta = currentTime - conversationEntry.getLastRequestTime();
                if (delta <= (long)conversationEntry.getTimeout()) continue;
                if (locked) {
                    if (log.isDebugEnabled()) {
                        log.debug("conversation timeout for conversation: " + conversationEntry.getId());
                    }
                } else {
                    log.info("destroying conversation with garbage lock: " + conversationEntry.getId());
                }
                this.destroyConversation(conversationEntry.getId(), session);
            }
            finally {
                if (!locked) continue;
                conversationEntry.unlock();
            }
        }
    }

    private void destroyConversation(String conversationId, ContextAdaptor session) {
        Lifecycle.destroyConversationContext(session, conversationId);
        ConversationEntries.instance().removeConversationEntry(conversationId);
    }

    public void endRequest(ContextAdaptor session) {
        if (this.isLongRunningConversation()) {
            if (log.isDebugEnabled()) {
                log.debug("Storing conversation state: " + this.getCurrentConversationId());
            }
            Manager.touchConversationStack(this.getCurrentConversationIdStack());
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Discarding conversation state: " + this.getCurrentConversationId());
            }
            this.removeCurrentConversationAndDestroyNestedContexts(session);
        }
        if (!Init.instance().isClientSideConversations()) {
            Manager.instance().conversationTimeout(session);
        }
    }

    public void unlockConversation() {
        ConversationEntry ce = this.getCurrentConversationEntry();
        if (ce != null) {
            if (ce.isLockedByCurrentThread()) {
                ce.unlock();
            }
        } else if (this.isNestedConversation()) {
            ConversationEntries.instance().getConversationEntry(this.getParentConversationId()).unlock();
        }
    }

    private void removeCurrentConversationAndDestroyNestedContexts(ContextAdaptor session) {
        ConversationEntries.instance().removeConversationEntry(this.getCurrentConversationId());
        this.destroyNestedConversationContexts(session, this.getCurrentConversationId());
    }

    private void destroyNestedConversationContexts(ContextAdaptor session, String conversationId) {
        ArrayList<ConversationEntry> entries = new ArrayList<ConversationEntry>(ConversationEntries.instance().getConversationEntries());
        for (ConversationEntry ce : entries) {
            if (!ce.getConversationIdStack().contains(conversationId)) continue;
            String entryConversationId = ce.getId();
            log.debug("destroying nested conversation: " + entryConversationId);
            this.destroyConversation(entryConversationId, session);
        }
    }

    private String getPropagationFromRequestParameter(Map parameters) {
        Object type = parameters.get("conversationPropagation");
        if (type == null) {
            return null;
        }
        if (type instanceof String) {
            return (String)type;
        }
        return ((String[])type)[0];
    }

    public boolean restoreConversation(Map parameters) {
        String propagation;
        Object page;
        String storedConversationId = null;
        String storedParentConversationId = null;
        Boolean isLongRunningConversation = null;
        String viewId = Pages.getCurrentViewId();
        if (viewId != null) {
            page = Pages.instance().getPage(viewId);
            storedConversationId = ((Page)page).getConversationIdParameter().getRequestConversationId(parameters);
            isLongRunningConversation = "true".equals(Manager.getRequestParameterValue(parameters, this.conversationIsLongRunningParameter));
        }
        if (storedConversationId == null) {
            storedConversationId = Manager.getRequestParameterValue(parameters, this.conversationIdParameter);
            storedParentConversationId = Manager.getRequestParameterValue(parameters, this.parentConversationIdParameter);
            isLongRunningConversation = "true".equals(Manager.getRequestParameterValue(parameters, this.conversationIsLongRunningParameter));
        }
        if (this.isMissing(storedConversationId)) {
            if (Contexts.isPageContextActive()) {
                page = FacesPage.instance();
                storedConversationId = ((FacesPage)page).getConversationId();
                storedParentConversationId = null;
                isLongRunningConversation = ((FacesPage)page).isConversationLongRunning();
            }
        } else {
            log.debug("Found conversation id in request parameter: " + storedConversationId);
        }
        if ("new".equals(storedConversationId)) {
            storedConversationId = null;
            storedParentConversationId = null;
            isLongRunningConversation = false;
        }
        if ("none".equals(propagation = this.getPropagationFromRequestParameter(parameters))) {
            storedConversationId = null;
            storedParentConversationId = null;
            isLongRunningConversation = false;
        }
        return this.restoreConversation(storedConversationId, storedParentConversationId, isLongRunningConversation) || "end".equals(propagation);
    }

    public void handleConversationPropagation(Map parameters) {
        String propagation = this.getPropagationFromRequestParameter(parameters);
        if (propagation != null && propagation.startsWith("begin")) {
            if (this.isLongRunningConversation) {
                throw new IllegalStateException("long-running conversation already active");
            }
            this.beginConversation(null);
            if (propagation.length() > 6) {
                Pageflow.instance().begin(propagation.substring(6));
            }
        } else if (propagation != null && propagation.startsWith("join")) {
            if (!this.isLongRunningConversation) {
                this.beginConversation(null);
                if (propagation.length() > 5) {
                    Pageflow.instance().begin(propagation.substring(5));
                }
            }
        } else if (propagation != null && propagation.startsWith("nest")) {
            this.beginNestedConversation(null);
            if (propagation.length() > 5) {
                Pageflow.instance().begin(propagation.substring(5));
            }
        } else if ("end".equals(propagation)) {
            this.endConversation(false);
        }
    }

    public boolean restoreConversation(String conversationId) {
        return this.restoreConversation(conversationId, null, false);
    }

    private boolean restoreConversation(String conversationId, String parentConversationId, boolean isLongRunningConversation) {
        ConversationEntries entries;
        ConversationEntry ce = null;
        if (conversationId != null && (ce = (entries = ConversationEntries.instance()).getConversationEntry(conversationId)) == null) {
            ce = entries.getConversationEntry(parentConversationId);
        }
        return this.restoreAndLockConversation(ce, isLongRunningConversation);
    }

    private boolean restoreAndLockConversation(ConversationEntry ce, boolean isLongRunningConversation) {
        if (ce != null && ce.lock()) {
            boolean removeAfterRedirect;
            Manager.touchConversationStack(ce.getConversationIdStack());
            log.debug("Restoring conversation with id: " + ce.getId());
            this.setLongRunningConversation(true);
            this.setCurrentConversationId(ce.getId());
            this.setCurrentConversationIdStack(ce.getConversationIdStack());
            boolean bl = removeAfterRedirect = ce.isRemoveAfterRedirect() && (!Init.instance().isDebug() || FacesContext.getCurrentInstance() == null || !"/debug.xhtml".equals(Pages.getCurrentViewId()));
            if (removeAfterRedirect) {
                this.setLongRunningConversation(false);
                ce.setRemoveAfterRedirect(false);
            }
            return true;
        }
        log.debug("No stored conversation, or concurrent call to the stored conversation");
        this.initializeTemporaryConversation();
        return !isLongRunningConversation;
    }

    public static String getRequestParameterValue(Map parameters, String parameterName) {
        Object object = parameters.get(parameterName);
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        String[] values = (String[])object;
        if (values.length != 1) {
            throw new IllegalArgumentException("expected exactly one value for conversationId request parameter");
        }
        return values[0];
    }

    private boolean isMissing(String storedConversationId) {
        return storedConversationId == null || "".equals(storedConversationId);
    }

    public void initializeTemporaryConversation() {
        String id = this.generateInitialConversationId();
        this.setCurrentConversationId(id);
        this.createCurrentConversationIdStack(id);
        this.setLongRunningConversation(false);
    }

    private String generateInitialConversationId() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String viewId = Pages.getViewId(facesContext);
        if (viewId != null) {
            return Pages.instance().getPage(viewId).getConversationIdParameter().getInitialConversationId(facesContext.getExternalContext().getRequestParameterMap());
        }
        return Id.nextId();
    }

    private ConversationEntry createConversationEntry() {
        ConversationEntry entry = ConversationEntries.instance().createConversationEntry(this.getCurrentConversationId(), this.getCurrentConversationIdStack());
        if (!entry.isNested()) {
            entry.lock();
        }
        return entry;
    }

    public void beginConversation(String initiator) {
        log.debug("Beginning long-running conversation");
        this.setLongRunningConversation(true);
        this.createConversationEntry().setInitiatorComponentName(initiator);
        Conversation.instance();
        this.storeConversationToViewRootIfNecessary();
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.beginConversation", new Object[0]);
        }
    }

    public void beginNestedConversation(String ownerName) {
        log.debug("Beginning nested conversation");
        List<String> oldStack = this.getCurrentConversationIdStack();
        if (oldStack == null) {
            throw new IllegalStateException("No long-running conversation active");
        }
        String id = Id.nextId();
        this.setCurrentConversationId(id);
        this.createCurrentConversationIdStack(id).addAll(oldStack);
        ConversationEntry conversationEntry = this.createConversationEntry();
        conversationEntry.setInitiatorComponentName(ownerName);
        this.storeConversationToViewRootIfNecessary();
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.beginConversation", new Object[0]);
        }
    }

    public void endConversation(boolean beforeRedirect) {
        log.debug("Ending long-running conversation");
        if (Events.exists()) {
            Events.instance().raiseEvent("org.jboss.seam.endConversation", new Object[0]);
        }
        this.setLongRunningConversation(false);
        this.destroyBeforeRedirect = beforeRedirect;
        Manager.endNestedConversations(this.getCurrentConversationId());
        this.storeConversationToViewRootIfNecessary();
    }

    private void storeConversationToViewRootIfNecessary() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && Lifecycle.getPhaseId() == PhaseId.RENDER_RESPONSE) {
            FacesPage.instance().storeConversation();
        }
    }

    public ConversationEntry getCurrentConversationEntry() {
        if (this.currentConversationEntry == null) {
            this.currentConversationEntry = ConversationEntries.instance().getConversationEntry(this.getCurrentConversationId());
        }
        return this.currentConversationEntry;
    }

    public void leaveConversation() {
        this.initializeTemporaryConversation();
    }

    public boolean switchConversation(String id) {
        ConversationEntry ce = ConversationEntries.instance().getConversationEntry(id);
        if (ce != null) {
            if (ce.lock()) {
                this.unlockConversation();
                this.setCurrentConversationId(id);
                this.setCurrentConversationIdStack(ce.getConversationIdStack());
                this.setLongRunningConversation(true);
                return true;
            }
            return false;
        }
        return false;
    }

    public int getConversationTimeout() {
        return this.conversationTimeout;
    }

    public void setConversationTimeout(int conversationTimeout) {
        this.conversationTimeout = conversationTimeout;
    }

    public void beforeRedirect() {
        if (!this.destroyBeforeRedirect) {
            ConversationEntry ce = this.getCurrentConversationEntry();
            if (ce == null) {
                ce = this.createConversationEntry();
            }
            ce.setRemoveAfterRedirect(!this.isLongRunningConversation());
            this.setLongRunningConversation(true);
        }
    }

    public void beforeRedirect(String viewId) {
        ConversationIdParameter targetPage;
        ConversationIdParameter currentPage;
        this.beforeRedirect();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String currentViewId = Pages.getViewId(facesContext);
        if (viewId != null && currentViewId != null && this.isDifferentConversationId(currentPage = Pages.instance().getPage(currentViewId).getConversationIdParameter(), targetPage = Pages.instance().getPage(viewId).getConversationIdParameter())) {
            this.updateCurrentConversationId(targetPage.getConversationId());
        }
    }

    private boolean isDifferentConversationId(ConversationIdParameter sp, ConversationIdParameter tp) {
        return sp.getName() != tp.getName() && (sp.getName() == null || !sp.getName().equals(tp.getName()));
    }

    public String encodeConversationId(String url) {
        return this.encodeConversationIdParameter(url, this.getConversationIdParameter(), this.getCurrentConversationId());
    }

    public String encodeConversationId(String url, String viewId) {
        ConversationIdParameter cip = Pages.instance().getPage(viewId).getConversationIdParameter();
        return this.encodeConversationIdParameter(url, cip.getParameterName(), cip.getParameterValue());
    }

    private String encodeConversationIdParameter(String url, String paramName, String paramValue) {
        if (Seam.isSessionInvalid() || this.containsParameter(url, paramName)) {
            return url;
        }
        if (this.destroyBeforeRedirect) {
            if (this.isNestedConversation()) {
                return new StringBuilder(url.length() + paramName.length() + 5).append(url).append(url.contains("?") ? (char)'&' : '?').append(paramName).append('=').append(this.encode(this.getParentConversationId())).append('&').append(this.conversationIsLongRunningParameter).append("=true").toString();
            }
            return url;
        }
        StringBuilder builder = new StringBuilder(url.length() + paramName.length() + 5).append(url).append(url.contains("?") ? (char)'&' : '?').append(paramName).append('=').append(this.encode(paramValue));
        if (this.isNestedConversation() && !this.isReallyLongRunningConversation()) {
            builder.append('&').append(this.parentConversationIdParameter).append('=').append(this.encode(this.getParentConversationId()));
        }
        if (this.isReallyLongRunningConversation()) {
            builder.append('&').append(this.conversationIsLongRunningParameter).append("=true");
        }
        return builder.toString();
    }

    public void interpolateAndRedirect(String url) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        int loc = url.indexOf(63);
        if (loc > 0) {
            StringTokenizer tokens = new StringTokenizer(url.substring(loc), "?=&");
            while (tokens.hasMoreTokens()) {
                String name = tokens.nextToken();
                String value = Interpolator.instance().interpolate(tokens.nextToken(), new Object[0]);
                parameters.put(name, value);
            }
            url = url.substring(0, loc);
        }
        this.redirect(url, parameters, true);
    }

    public String encodeParameters(String url, Map<String, Object> parameters) {
        if (parameters.isEmpty()) {
            return url;
        }
        StringBuilder builder = new StringBuilder(url);
        for (Map.Entry<String, Object> param : parameters.entrySet()) {
            String parameterName = param.getKey();
            if (this.containsParameter(url, parameterName)) continue;
            Object parameterValue = param.getValue();
            if (parameterValue instanceof Iterable) {
                for (Object value : (Iterable)parameterValue) {
                    builder.append('&').append(parameterName).append('=');
                    if (value == null) continue;
                    builder.append(this.encode(value));
                }
                continue;
            }
            builder.append('&').append(parameterName).append('=');
            if (parameterValue == null) continue;
            builder.append(this.encode(parameterValue));
        }
        if (url.indexOf(63) < 0) {
            builder.setCharAt(url.length(), '?');
        }
        return builder.toString();
    }

    private boolean containsParameter(String url, String parameterName) {
        return url.indexOf('?' + parameterName + '=') > 0 || url.indexOf('&' + parameterName + '=') > 0;
    }

    private String encode(Object value) {
        try {
            return URLEncoder.encode(String.valueOf(value), "UTF-8");
        }
        catch (UnsupportedEncodingException iee) {
            throw new RuntimeException(iee);
        }
    }

    public void redirect(String viewId) {
        this.redirect(viewId, null, true);
    }

    public void redirect(String viewId, Map<String, Object> parameters, boolean includeConversationId) {
        FacesContext context = FacesContext.getCurrentInstance();
        String url = context.getApplication().getViewHandler().getActionURL(context, viewId);
        if (parameters != null) {
            url = this.encodeParameters(url, parameters);
        }
        url = Pages.instance().encodePageParameters(FacesContext.getCurrentInstance(), url, viewId, parameters == null ? Collections.EMPTY_SET : parameters.keySet());
        if (includeConversationId) {
            this.beforeRedirect(viewId);
            url = this.encodeConversationId(url, viewId);
        }
        url = Pages.instance().encodeScheme(viewId, context, url);
        if (log.isDebugEnabled()) {
            log.debug("redirecting to: " + url);
        }
        ExternalContext externalContext = context.getExternalContext();
        this.controllingRedirect = true;
        try {
            externalContext.redirect(externalContext.encodeActionURL(url));
        }
        catch (IOException ioe) {
            throw new RedirectException(ioe);
        }
        finally {
            this.controllingRedirect = false;
        }
        context.responseComplete();
    }

    public String appendConversationIdFromRedirectFilter(String url, String viewId) {
        boolean appendConversationId;
        boolean bl = appendConversationId = !this.controllingRedirect;
        if (appendConversationId) {
            this.beforeRedirect(viewId);
            url = this.encodeConversationId(url, viewId);
        }
        return url;
    }

    public void prepareBackswitch(FacesContext facesContext) {
        org.jboss.seam.pageflow.Page pageflowPage;
        Conversation conversation = Conversation.instance();
        org.jboss.seam.pageflow.Page page = pageflowPage = this.isLongRunningConversation() && Init.instance().isJbpmInstalled() && Pageflow.instance().isInProcess() ? Pageflow.instance().getPage() : null;
        if (pageflowPage == null) {
            Pages pages = Pages.instance();
            if (pages != null) {
                String viewId = Pages.getViewId(facesContext);
                Page pageEntry = pages.getPage(viewId);
                if (pageEntry.isSwitchEnabled()) {
                    conversation.setViewId(viewId);
                }
                if (pageEntry.hasDescription()) {
                    conversation.setDescription(pageEntry.renderDescription());
                }
                conversation.setTimeout(pages.getTimeout(viewId));
            }
        } else {
            if (pageflowPage.isSwitchEnabled()) {
                conversation.setViewId(Pageflow.instance().getPageViewId());
            }
            if (pageflowPage.hasDescription()) {
                conversation.setDescription(pageflowPage.getDescription());
            }
            conversation.setTimeout(pageflowPage.getTimeout());
        }
        if (this.isLongRunningConversation()) {
            conversation.flush();
        }
    }

    public String getConversationIdParameter() {
        return this.conversationIdParameter;
    }

    public void setConversationIdParameter(String conversationIdParameter) {
        this.conversationIdParameter = conversationIdParameter;
    }

    public String getConversationIsLongRunningParameter() {
        return this.conversationIsLongRunningParameter;
    }

    public void setConversationIsLongRunningParameter(String conversationIdLongRunning) {
        this.conversationIsLongRunningParameter = conversationIdLongRunning;
    }

    public int getConcurrentRequestTimeout() {
        return this.concurrentRequestTimeout;
    }

    public void setConcurrentRequestTimeout(int requestWait) {
        this.concurrentRequestTimeout = requestWait;
    }

    public String toString() {
        return "Manager(" + this.currentConversationIdStack + ")";
    }

    protected String getParentConversationIdParameter() {
        return this.parentConversationIdParameter;
    }

    protected void setParentConversationIdParameter(String nestedConversationIdParameter) {
        this.parentConversationIdParameter = nestedConversationIdParameter;
    }
}

