/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.datascroller;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.faces.application.Application;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.component.html.HtmlCommandLink;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.FacesEvent;
import org.apache.myfaces.custom.datascroller.HtmlDataScroller;
import org.apache.myfaces.custom.datascroller.ScrollerActionEvent;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRenderer;

public class HtmlDataScrollerRenderer
extends HtmlRenderer {
    public static final String RENDERER_TYPE = "org.apache.myfaces.DataScroller";
    protected static final String PAGE_NAVIGATION = "idx".intern();
    static /* synthetic */ Class class$org$apache$myfaces$custom$datascroller$HtmlDataScroller;

    public boolean getRendersChildren() {
        return true;
    }

    public void decode(FacesContext context, UIComponent component) {
        RendererUtils.checkParamValidity(context, component, class$org$apache$myfaces$custom$datascroller$HtmlDataScroller == null ? (class$org$apache$myfaces$custom$datascroller$HtmlDataScroller = HtmlDataScrollerRenderer.class$("org.apache.myfaces.custom.datascroller.HtmlDataScroller")) : class$org$apache$myfaces$custom$datascroller$HtmlDataScroller);
        Map parameter = context.getExternalContext().getRequestParameterMap();
        String param = (String)parameter.get(component.getClientId(context));
        if (param != null && param.length() > 0) {
            if (param.startsWith(PAGE_NAVIGATION)) {
                component.queueEvent((FacesEvent)new ScrollerActionEvent(component, Integer.parseInt(param.substring(PAGE_NAVIGATION.length(), param.length()))));
            } else {
                component.queueEvent((FacesEvent)new ScrollerActionEvent(component, param));
            }
        }
    }

    protected void setVariables(FacesContext facescontext, HtmlDataScroller scroller) throws IOException {
        String lastRowIndexVar;
        String firstRowIndexVar;
        String displayedRowsCountVar;
        String rowsCountVar;
        String pageIndexVar;
        Map requestMap = facescontext.getExternalContext().getRequestMap();
        String pageCountVar = scroller.getPageCountVar();
        if (pageCountVar != null) {
            int pageCount = scroller.getPageCount();
            requestMap.put(pageCountVar, new Integer(pageCount));
        }
        if ((pageIndexVar = scroller.getPageIndexVar()) != null) {
            int pageIndex = scroller.getRowCount() > 0 ? scroller.getPageIndex() : 0;
            requestMap.put(pageIndexVar, new Integer(pageIndex));
        }
        if ((rowsCountVar = scroller.getRowsCountVar()) != null) {
            int rowsCount = scroller.getRowCount();
            requestMap.put(rowsCountVar, new Integer(rowsCount));
        }
        if ((displayedRowsCountVar = scroller.getDisplayedRowsCountVar()) != null) {
            int max;
            int displayedRowsCount = scroller.getRows();
            if (displayedRowsCount > (max = scroller.getRowCount() - scroller.getFirstRow())) {
                displayedRowsCount = max;
            }
            requestMap.put(displayedRowsCountVar, new Integer(displayedRowsCount));
        }
        if ((firstRowIndexVar = scroller.getFirstRowIndexVar()) != null) {
            int firstRowIndex = scroller.getRowCount() > 0 ? scroller.getFirstRow() + 1 : 0;
            requestMap.put(firstRowIndexVar, new Integer(firstRowIndex));
        }
        if ((lastRowIndexVar = scroller.getLastRowIndexVar()) != null) {
            int count;
            int lastRowIndex = scroller.getFirstRow() + scroller.getRows();
            if (lastRowIndex > (count = scroller.getRowCount())) {
                lastRowIndex = count;
            }
            requestMap.put(lastRowIndexVar, new Integer(lastRowIndex));
        }
    }

    public void removeVariables(FacesContext facescontext, HtmlDataScroller scroller) throws IOException {
        String lastRowIndexVar;
        String firstRowIndexVar;
        String displayedRowsCountVar;
        String rowsCountVar;
        String pageIndexVar;
        Map requestMap = facescontext.getExternalContext().getRequestMap();
        String pageCountVar = scroller.getPageCountVar();
        if (pageCountVar != null) {
            requestMap.remove(pageCountVar);
        }
        if ((pageIndexVar = scroller.getPageIndexVar()) != null) {
            requestMap.remove(pageIndexVar);
        }
        if ((rowsCountVar = scroller.getRowsCountVar()) != null) {
            requestMap.remove(rowsCountVar);
        }
        if ((displayedRowsCountVar = scroller.getDisplayedRowsCountVar()) != null) {
            requestMap.remove(displayedRowsCountVar);
        }
        if ((firstRowIndexVar = scroller.getFirstRowIndexVar()) != null) {
            requestMap.remove(firstRowIndexVar);
        }
        if ((lastRowIndexVar = scroller.getLastRowIndexVar()) != null) {
            requestMap.remove(lastRowIndexVar);
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        super.encodeBegin(facesContext, uiComponent);
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$org$apache$myfaces$custom$datascroller$HtmlDataScroller == null ? (class$org$apache$myfaces$custom$datascroller$HtmlDataScroller = HtmlDataScrollerRenderer.class$("org.apache.myfaces.custom.datascroller.HtmlDataScroller")) : class$org$apache$myfaces$custom$datascroller$HtmlDataScroller);
        HtmlDataScroller scroller = (HtmlDataScroller)uiComponent;
        this.setVariables(facesContext, scroller);
    }

    public void encodeChildren(FacesContext facescontext, UIComponent uicomponent) throws IOException {
        RendererUtils.checkParamValidity(facescontext, uicomponent, class$org$apache$myfaces$custom$datascroller$HtmlDataScroller == null ? (class$org$apache$myfaces$custom$datascroller$HtmlDataScroller = HtmlDataScrollerRenderer.class$("org.apache.myfaces.custom.datascroller.HtmlDataScroller")) : class$org$apache$myfaces$custom$datascroller$HtmlDataScroller);
        RendererUtils.renderChildren(facescontext, uicomponent);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        RendererUtils.checkParamValidity(facesContext, uiComponent, class$org$apache$myfaces$custom$datascroller$HtmlDataScroller == null ? (class$org$apache$myfaces$custom$datascroller$HtmlDataScroller = HtmlDataScrollerRenderer.class$("org.apache.myfaces.custom.datascroller.HtmlDataScroller")) : class$org$apache$myfaces$custom$datascroller$HtmlDataScroller);
        HtmlDataScroller scroller = (HtmlDataScroller)uiComponent;
        if (scroller.getUIData() == null) {
            return;
        }
        this.renderScroller(facesContext, scroller);
        this.removeVariables(facesContext, scroller);
    }

    protected void renderScroller(FacesContext facesContext, HtmlDataScroller scroller) throws IOException {
        String style;
        ResponseWriter writer = facesContext.getResponseWriter();
        if (!scroller.isRenderFacetsIfSinglePage() && scroller.getPageCount() <= 1) {
            return;
        }
        if (scroller.getFirst() == null && scroller.getFastRewind() == null && scroller.getPrevious() == null && !scroller.isPaginator() && scroller.getNext() == null && scroller.getFastForward() == null && scroller.getLast() == null) {
            return;
        }
        writer.startElement("table", (UIComponent)scroller);
        String styleClass = scroller.getStyleClass();
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        if ((style = scroller.getStyle()) != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.startElement("tr", (UIComponent)scroller);
        UIComponent facetComp = scroller.getFirst();
        if (facetComp != null) {
            writer.startElement("td", (UIComponent)scroller);
            this.renderFacet(facesContext, scroller, facetComp, HtmlDataScroller.FACET_FIRST);
            writer.endElement("td");
        }
        if ((facetComp = scroller.getFastRewind()) != null) {
            writer.startElement("td", (UIComponent)scroller);
            this.renderFacet(facesContext, scroller, facetComp, HtmlDataScroller.FACET_FAST_REWIND);
            writer.endElement("td");
        }
        if ((facetComp = scroller.getPrevious()) != null) {
            writer.startElement("td", (UIComponent)scroller);
            this.renderFacet(facesContext, scroller, facetComp, HtmlDataScroller.FACET_PREVIOUS);
            writer.endElement("td");
        }
        if (scroller.isPaginator()) {
            writer.startElement("td", (UIComponent)scroller);
            this.renderPaginator(facesContext, scroller);
            writer.endElement("td");
        }
        if ((facetComp = scroller.getNext()) != null) {
            writer.startElement("td", (UIComponent)scroller);
            this.renderFacet(facesContext, scroller, facetComp, HtmlDataScroller.FACET_NEXT);
            writer.endElement("td");
        }
        if ((facetComp = scroller.getFastForward()) != null) {
            writer.startElement("td", (UIComponent)scroller);
            this.renderFacet(facesContext, scroller, facetComp, HtmlDataScroller.FACET_FAST_FORWARD);
            writer.endElement("td");
        }
        if ((facetComp = scroller.getLast()) != null) {
            writer.startElement("td", (UIComponent)scroller);
            this.renderFacet(facesContext, scroller, facetComp, HtmlDataScroller.FACET_LAST);
            writer.endElement("td");
        }
        writer.endElement("tr");
        writer.endElement("table");
    }

    protected void renderFacet(FacesContext facesContext, HtmlDataScroller scroller, UIComponent facetComp, String facetName) throws IOException {
        String onclick = scroller.getOnclick();
        String ondblclick = scroller.getOndblclick();
        HtmlCommandLink link = this.getLink(facesContext, scroller, facetName);
        if (onclick != null) {
            link.setOnclick(onclick);
        }
        if (ondblclick != null) {
            link.setOndblclick(ondblclick);
        }
        link.encodeBegin(facesContext);
        facetComp.encodeBegin(facesContext);
        if (facetComp.getRendersChildren()) {
            facetComp.encodeChildren(facesContext);
        }
        facetComp.encodeEnd(facesContext);
        link.encodeEnd(facesContext);
    }

    protected void renderPaginator(FacesContext facesContext, HtmlDataScroller scroller) throws IOException {
        String style;
        int start;
        int pages;
        int pageCount;
        ResponseWriter writer = facesContext.getResponseWriter();
        int maxPages = scroller.getPaginatorMaxPages();
        if (maxPages <= 1) {
            maxPages = 2;
        }
        if ((pageCount = scroller.getPageCount()) <= 1) {
            return;
        }
        int pageIndex = scroller.getPageIndex();
        int delta = maxPages / 2;
        if (pageCount > maxPages && pageIndex > delta) {
            pages = maxPages;
            start = pageIndex - pages / 2 - 1;
            if (start + pages > pageCount) {
                start = pageCount - pages;
            }
        } else {
            pages = pageCount < maxPages ? pageCount : maxPages;
            start = 0;
        }
        writer.startElement("table", (UIComponent)scroller);
        String styleClass = scroller.getPaginatorTableClass();
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        if ((style = scroller.getPaginatorTableStyle()) != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        writer.startElement("tr", (UIComponent)scroller);
        String onclick = scroller.getOnclick();
        String ondblclick = scroller.getOndblclick();
        int size = start + pages;
        for (int i = start; i < size; ++i) {
            String cStyle;
            String cStyleClass;
            int idx = i + 1;
            writer.startElement("td", (UIComponent)scroller);
            if (idx == pageIndex) {
                cStyleClass = scroller.getPaginatorActiveColumnClass();
                cStyle = scroller.getPaginatorActiveColumnStyle();
            } else {
                cStyleClass = scroller.getPaginatorColumnClass();
                cStyle = scroller.getPaginatorColumnStyle();
            }
            if (cStyleClass != null) {
                writer.writeAttribute("class", (Object)cStyleClass, null);
            }
            if (cStyle != null) {
                writer.writeAttribute("style", (Object)cStyle, null);
            }
            HtmlCommandLink link = this.getLink(facesContext, scroller, Integer.toString(idx), idx);
            if (onclick != null) {
                link.setOnclick(onclick);
            }
            if (ondblclick != null) {
                link.setOndblclick(ondblclick);
            }
            link.encodeBegin(facesContext);
            link.encodeChildren(facesContext);
            link.encodeEnd(facesContext);
            writer.endElement("td");
        }
        writer.endElement("tr");
        writer.endElement("table");
    }

    protected HtmlCommandLink getLink(FacesContext facesContext, HtmlDataScroller scroller, String text, int pageIndex) {
        String id = PAGE_NAVIGATION + Integer.toString(pageIndex);
        Application application = facesContext.getApplication();
        HtmlCommandLink link = (HtmlCommandLink)application.createComponent("javax.faces.HtmlCommandLink");
        link.setId(scroller.getId() + id);
        link.setTransient(true);
        UIParameter parameter = (UIParameter)application.createComponent("javax.faces.Parameter");
        parameter.setId(scroller.getId() + id + "_param");
        parameter.setTransient(true);
        parameter.setName(scroller.getClientId(facesContext));
        parameter.setValue((Object)id);
        List children = link.getChildren();
        children.add(parameter);
        if (text != null) {
            HtmlOutputText uiText = (HtmlOutputText)application.createComponent("javax.faces.HtmlOutputText");
            uiText.setTransient(true);
            uiText.setValue((Object)text);
            children.add(uiText);
        }
        scroller.getChildren().add(link);
        return link;
    }

    protected HtmlCommandLink getLink(FacesContext facesContext, HtmlDataScroller scroller, String facetName) {
        Application application = facesContext.getApplication();
        HtmlCommandLink link = (HtmlCommandLink)application.createComponent("javax.faces.HtmlCommandLink");
        link.setId(scroller.getId() + facetName);
        link.setTransient(true);
        UIParameter parameter = (UIParameter)application.createComponent("javax.faces.Parameter");
        parameter.setId(scroller.getId() + facetName + "_param");
        parameter.setTransient(true);
        parameter.setName(scroller.getClientId(facesContext));
        parameter.setValue((Object)facetName);
        List children = link.getChildren();
        children.add(parameter);
        scroller.getChildren().add(link);
        return link;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

