/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.ui;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.Id;
import org.jboss.seam.Component;
import org.jboss.seam.InterceptionType;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Transactional;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.core.FacesMessages;
import org.jboss.seam.log.Log;
import org.jboss.seam.log.Logging;
import org.jboss.seam.ui.EntityConverterStore;
import org.jboss.seam.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.jboss.seam.ui.entityConverter")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=0)
@org.jboss.seam.annotations.jsf.Converter
@Intercept(value=InterceptionType.NEVER)
public class EntityConverter
implements Converter,
Serializable {
    private Expressions.ValueBinding<EntityManager> entityManager;
    private Log log = Logging.getLog(EntityConverter.class);
    private String errorMessage = "Error selecting object";

    public void setEntityManager(Expressions.ValueBinding<EntityManager> entityManager) {
        this.entityManager = entityManager;
    }

    private EntityManager getEntityManager() {
        if (this.entityManager == null) {
            return (EntityManager)Component.getInstance((String)"entityManager");
        }
        return (EntityManager)this.entityManager.getValue();
    }

    protected void errorGettingIdMessage(UIComponent cmp, FacesContext facesContext, Object entity) {
        this.log.error((Object)"@Id annotation not on #0", new Object[]{entity.getClass()});
        throw new ConverterException(FacesMessages.createFacesMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)this.getErrorMessageKey(), (String)this.getErrorMessage(), (Object[])new Object[0]));
    }

    protected String getErrorMessage() {
        return this.errorMessage;
    }

    protected String getErrorMessageKey() {
        return this.getEntityConverterKeyPrefix() + "idNotFound";
    }

    protected void invalidSelectionMessage(Class clazz, Object id) {
        this.log.error((Object)"Cannot load entity (#0 with id #1) from persistence context", new Object[]{clazz.getName(), id});
        throw new ConverterException(FacesMessages.createFacesMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)this.getErrorMessageKey(), (String)this.getErrorMessage(), (Object[])new Object[0]));
    }

    protected void entityManagerNotFoundMessage() {
        this.log.error((Object)"Entity Manager not found", new Object[0]);
        throw new ConverterException(FacesMessages.createFacesMessage((FacesMessage.Severity)FacesMessage.SEVERITY_ERROR, (String)this.getErrorMessageKey(), (String)this.getErrorMessage(), (Object[])new Object[0]));
    }

    protected String getEntityConverterKeyPrefix() {
        return "org.jboss.seam.ui.entityConverter.";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getIdFromEntity(UIComponent cmp, FacesContext facesContext, Object entity, Class entityClass) {
        Object id = null;
        List fields = Reflections.getFields((Class)entityClass, Id.class);
        if (fields.size() == 1) {
            Field field = (Field)fields.get(0);
            boolean accessible = field.isAccessible();
            field.setAccessible(true);
            try {
                id = Reflections.get((Field)field, (Object)entity);
            }
            catch (Exception e) {
                this.errorGettingIdMessage(cmp, facesContext, entity);
            }
            finally {
                field.setAccessible(accessible);
            }
        } else {
            List methods = Reflections.getGetterMethods((Class)entityClass, Id.class);
            if (methods.size() == 1) {
                try {
                    id = Reflections.invoke((Method)((Method)methods.get(0)), (Object)entity, (Object[])new Object[0]);
                }
                catch (Exception e) {
                    this.errorGettingIdMessage(cmp, facesContext, entity);
                }
            }
        }
        if (id == null) {
            return "org.jboss.seam.ui.NoSelectionConverter.noSelectionValue";
        }
        return id;
    }

    @Transactional
    public String getAsString(FacesContext facesContext, UIComponent cmp, Object value) throws ConverterException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        Class entityClass = this.deproxy(value.getClass());
        return EntityConverterStore.instance().put(entityClass, this.getIdFromEntity(cmp, facesContext, value, entityClass)).toString();
    }

    private Class deproxy(Class clazz) {
        if (Object.class.equals((Object)clazz) || clazz.isAnnotationPresent(Entity.class)) {
            return clazz;
        }
        return this.deproxy(clazz.getSuperclass());
    }

    @Transactional
    public Object getAsObject(FacesContext facesContext, UIComponent cmp, String value) throws ConverterException {
        if (value == null) {
            return null;
        }
        Integer key = new Integer(value);
        Class clazz = EntityConverterStore.instance().getClass(key);
        Object id = EntityConverterStore.instance().getId(key);
        return this.loadEntityFromPersistenceContext(clazz, id);
    }

    protected Object loadEntityFromPersistenceContext(Class clazz, Object id) {
        if (id == null || clazz == null) {
            return null;
        }
        Object entity = null;
        if (this.getEntityManager() == null) {
            this.entityManagerNotFoundMessage();
        }
        if ((entity = this.getEntityManager().find(clazz, id)) == null) {
            this.invalidSelectionMessage(clazz, id);
            return null;
        }
        return entity;
    }
}

