/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.jsf;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;

public class MapDataModel
extends DataModel
implements Serializable {
    private static final long serialVersionUID = -4888962547222002402L;
    private int rowIndex = -1;
    private Map map;
    private List<Map.Entry> entries;

    public MapDataModel() {
    }

    public MapDataModel(Map map) {
        if (map == null) {
            throw new IllegalArgumentException("null map data");
        }
        this.setWrappedData(map);
    }

    public int getRowCount() {
        if (this.map == null) {
            return -1;
        }
        return this.map.size();
    }

    public Object getRowData() {
        if (this.map == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException("row is unavailable");
        }
        return this.entries.get(this.rowIndex);
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public Object getWrappedData() {
        return this.map;
    }

    public boolean isRowAvailable() {
        return this.entries != null && this.rowIndex >= 0 && this.rowIndex < this.entries.size();
    }

    public void setRowIndex(int newRowIndex) {
        if (newRowIndex < -1) {
            throw new IllegalArgumentException("illegal rowIndex " + newRowIndex);
        }
        int oldRowIndex = this.rowIndex;
        this.rowIndex = newRowIndex;
        if (this.map != null && oldRowIndex != newRowIndex) {
            Object data = this.isRowAvailable() ? this.getRowData() : null;
            DataModelEvent event = new DataModelEvent((DataModel)this, newRowIndex, data);
            DataModelListener[] listeners = this.getDataModelListeners();
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].rowSelected(event);
            }
        }
    }

    public void setWrappedData(Object data) {
        this.map = (Map)data;
        this.entries = new ArrayList(this.map.entrySet());
        int rowIndex = data != null ? 0 : -1;
        this.setRowIndex(rowIndex);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeObject(this.map);
        oos.writeInt(this.rowIndex);
        oos.writeObject(this.entries);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.map = (Map)ois.readObject();
        this.rowIndex = ois.readInt();
        this.entries = (List)ois.readObject();
    }
}

