/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.event;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import org.hibernate.ejb.event.Callback;
import org.hibernate.util.ReflectHelper;

public class ListenerCallback
extends Callback {
    protected transient Object listener;

    public ListenerCallback(Method callbackMethod, Object listener) {
        super(callbackMethod);
        this.listener = listener;
    }

    public void invoke(Object bean) {
        try {
            this.callbackMethod.invoke(this.listener, bean);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.listener.getClass().getName());
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        String listenerClass = (String)ois.readObject();
        try {
            this.listener = ReflectHelper.classForName(listenerClass, this.getClass()).newInstance();
        }
        catch (InstantiationException e) {
            throw new ClassNotFoundException("Unable to load class:" + listenerClass, e);
        }
        catch (IllegalAccessException e) {
            throw new ClassNotFoundException("Unable to load class:" + listenerClass, e);
        }
    }
}

