/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mail.ui;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.util.ByteArrayDataSource;
import org.jboss.seam.mail.ui.MailComponent;
import org.jboss.seam.pdf.DocumentData;
import org.jboss.seam.pdf.ui.UIDocument;
import org.jboss.seam.ui.JSF;
import org.jboss.seam.util.Resources;

public class UIAttachment
extends MailComponent
implements ValueHolder {
    private Object value;
    private String contentType;
    private String fileName;

    public Object getValue() {
        if (this.value != null) {
            return this.value;
        }
        return this.getValue("value");
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        if (this.getChildCount() > 0) {
            if (this.getChildren().get(0) instanceof UIDocument) {
                UIDocument document = (UIDocument)this.getChildren().get(0);
                document.setSendRedirect(false);
                JSF.renderChildren((FacesContext)context, (UIComponent)this);
            } else {
                this.setValue(this.encode(context).getBytes());
                if (this.getContentType() == null) {
                    this.setContentType("text/html");
                }
            }
        }
    }

    public void encodeEnd(FacesContext context) throws IOException {
        URLDataSource ds = null;
        try {
            if (this.getValue() instanceof URL) {
                URL url = (URL)this.getValue();
                ds = new URLDataSource(url);
            } else if (this.getValue() instanceof File) {
                File file = (File)this.getValue();
                ds = new FileDataSource(file);
            } else if (this.getValue() instanceof String) {
                String string = (String)this.getValue();
                ds = new URLDataSource(Resources.getResource((String)string));
            } else if (this.getValue() instanceof InputStream) {
                InputStream is = (InputStream)this.getValue();
                ds = new ByteArrayDataSource(is, this.getContentType());
            } else if (this.getValue() instanceof DocumentData) {
                DocumentData documentData = (DocumentData)this.getValue();
                ds = new ByteArrayDataSource(documentData.getData(), documentData.getDocType().getMimeType());
            } else if (this.getValue() != null && this.getValue().getClass().isArray() && this.getValue().getClass().getComponentType().isAssignableFrom(Byte.TYPE)) {
                byte[] b = (byte[])this.getValue();
                ds = new ByteArrayDataSource(b, this.getContentType());
            }
            if (ds != null) {
                MimeBodyPart attachment = new MimeBodyPart();
                attachment.setDataHandler(new DataHandler((DataSource)ds));
                attachment.setFileName(this.getName(ds.getName()));
                super.getRootMultipart().addBodyPart((BodyPart)attachment);
            }
        }
        catch (MessagingException e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
    }

    public String getContentType() {
        if (this.contentType == null) {
            return this.getString("contentType");
        }
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getFileName() {
        if (this.fileName == null) {
            return this.getString("fileName");
        }
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    private String removePath(String fileName) {
        if (fileName.lastIndexOf("/") > 0) {
            return fileName.substring(fileName.lastIndexOf("/") + 1);
        }
        return fileName;
    }

    private String getName(String name) {
        if (this.getFileName() != null) {
            return this.getFileName();
        }
        return this.removePath(name);
    }

    public Converter getConverter() {
        return null;
    }

    public Object getLocalValue() {
        return this.value;
    }

    public void setConverter(Converter converter) {
        throw new UnsupportedOperationException("Cannot attach a converter to an attachment");
    }
}

