/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.processor;

import com.sun.faces.application.ApplicationAssociate;
import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.el.ELUtils;
import com.sun.faces.mgbean.BeanManager;
import com.sun.faces.mgbean.ManagedBeanInfo;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.TypedCollections;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.bean.ManagedBean;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ManagedBeanConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String MANAGED_BEAN = "managed-bean";
    private static final String DESCRIPTION = "description";
    private static final String MGBEAN_NAME = "managed-bean-name";
    private static final String MGBEAN_CLASS = "managed-bean-class";
    private static final String MGBEAN_SCOPE = "managed-bean-scope";
    private static final String MG_PROPERTY = "managed-property";
    private static final String MG_PROPERTY_NAME = "property-name";
    private static final String MG_PROPERTY_TYPE = "property-class";
    private static final String NULL_VALUE = "null-value";
    private static final String VALUE = "value";
    private static final String KEY = "key";
    private static final String MAP_KEY_CLASS = "key-class";
    private static final String VALUE_CLASS = "value-class";
    private static final String MAP_ENTRY = "map-entry";
    private static final String MAP_ENTRIES = "map-entries";
    private static final String LIST_ENTRIES = "list-entries";
    private static final String EAGER_ATTRIBUTE = "eager";
    private static final String DEFAULT_SCOPE = "request";

    public void process(DocumentInfo[] documentInfos) throws Exception {
        this.processAnnotations(ManagedBean.class);
        BeanManager beanManager = ApplicationAssociate.getCurrentInstance().getBeanManager();
        for (int i = 0; i < documentInfos.length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing managed-bean elements for document: ''{0}''", documentInfos[i].getSourceURL()));
            }
            Document document = documentInfos[i].getDocument();
            String namespace = document.getDocumentElement().getNamespaceURI();
            NodeList managedBeans = document.getDocumentElement().getElementsByTagNameNS(namespace, MANAGED_BEAN);
            if (managedBeans == null || managedBeans.getLength() <= 0) continue;
            int size = managedBeans.getLength();
            for (int m = 0; m < size; ++m) {
                this.addManagedBean(beanManager, managedBeans.item(m));
            }
        }
        beanManager.preProcessesBeans();
        this.invokeNext(documentInfos);
    }

    private void addManagedBean(BeanManager beanManager, Node managedBean) {
        NodeList children = managedBean.getChildNodes();
        String beanName = null;
        String beanClass = null;
        String beanScope = null;
        ManagedBeanInfo.ListEntry listEntry = null;
        ManagedBeanInfo.MapEntry mapEntry = null;
        ArrayList<Node> managedProperties = null;
        ArrayList<Node> descriptions = null;
        int size = children.getLength();
        for (int i = 0; i < size; ++i) {
            Node n = children.item(i);
            if (n.getNodeType() != 1) continue;
            if (MGBEAN_NAME.equals(n.getLocalName())) {
                beanName = this.getNodeText(n);
                continue;
            }
            if (MGBEAN_CLASS.equals(n.getLocalName())) {
                beanClass = this.getNodeText(n);
                continue;
            }
            if (MGBEAN_SCOPE.equals(n.getLocalName())) {
                beanScope = this.getNodeText(n);
                if (beanScope != null) continue;
                beanScope = DEFAULT_SCOPE;
                continue;
            }
            if (LIST_ENTRIES.equals(n.getLocalName())) {
                listEntry = this.buildListEntry(n);
                continue;
            }
            if (MAP_ENTRIES.equals(n.getLocalName())) {
                mapEntry = this.buildMapEntry(n);
                continue;
            }
            if (MG_PROPERTY.equals(n.getLocalName())) {
                if (managedProperties == null) {
                    managedProperties = new ArrayList<Node>(size);
                }
                managedProperties.add(n);
                continue;
            }
            if (!DESCRIPTION.equals(n.getLocalName())) continue;
            if (descriptions == null) {
                descriptions = new ArrayList<Node>(4);
            }
            descriptions.add(n);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Begin processing managed bean ''{0}''", beanName);
        }
        ArrayList<ManagedBeanInfo.ManagedProperty> properties = null;
        if (managedProperties != null && !managedProperties.isEmpty()) {
            properties = new ArrayList<ManagedBeanInfo.ManagedProperty>(managedProperties.size());
            for (Node managedProperty : managedProperties) {
                properties.add(this.buildManagedProperty(managedProperty));
            }
        }
        beanManager.register(new ManagedBeanInfo(beanName, beanClass, beanScope, this.isEager(managedBean, beanName, beanScope), mapEntry, listEntry, properties, this.getTextMap(descriptions)));
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Completed processing bean ''{0}''", beanName);
        }
    }

    private ManagedBeanInfo.ListEntry buildListEntry(Node listEntry) {
        if (listEntry != null) {
            String valueClass = "java.lang.String";
            ArrayList<String> values = null;
            NodeList children = listEntry.getChildNodes();
            int size = children.getLength();
            for (int i = 0; i < size; ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                if (VALUE_CLASS.equals(child.getLocalName())) {
                    valueClass = this.getNodeText(child);
                    continue;
                }
                if (VALUE.equals(child.getLocalName())) {
                    if (values == null) {
                        values = new ArrayList<String>(size);
                    }
                    values.add(this.getNodeText(child));
                    continue;
                }
                if (!NULL_VALUE.equals(child.getLocalName())) continue;
                if (values == null) {
                    values = new ArrayList(size);
                }
                values.add("null_value");
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Created ListEntry valueClass={1}, values={3}", valueClass, values != null && !values.isEmpty() ? ((Object)values).toString() : "none"));
            }
            return new ManagedBeanInfo.ListEntry(valueClass, values == null ? TypedCollections.dynamicallyCastList(Collections.emptyList(), String.class) : values);
        }
        return null;
    }

    private ManagedBeanInfo.MapEntry buildMapEntry(Node mapEntry) {
        if (mapEntry != null) {
            String valueClass = "java.lang.String";
            String keyClass = "java.lang.String";
            LinkedHashMap<String, String> entries = null;
            NodeList children = mapEntry.getChildNodes();
            int size = children.getLength();
            for (int i = 0; i < size; ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                if (VALUE_CLASS.equals(child.getLocalName())) {
                    valueClass = this.getNodeText(child);
                    continue;
                }
                if (MAP_KEY_CLASS.equals(child.getLocalName())) {
                    keyClass = this.getNodeText(child);
                    continue;
                }
                if (!MAP_ENTRY.equals(child.getLocalName())) continue;
                if (entries == null) {
                    entries = new LinkedHashMap<String, String>(8, 1.0f);
                }
                NodeList c = child.getChildNodes();
                String key = null;
                String value = null;
                int jsize = c.getLength();
                for (int j = 0; j < jsize; ++j) {
                    Node node = c.item(j);
                    if (node.getNodeType() != 1) continue;
                    if (KEY.equals(node.getLocalName())) {
                        key = this.getNodeText(node);
                        continue;
                    }
                    if (VALUE.equals(node.getLocalName())) {
                        value = this.getNodeText(node);
                        continue;
                    }
                    if (!NULL_VALUE.equals(node.getLocalName())) continue;
                    value = "null_value";
                }
                entries.put(key, value);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Created MapEntry keyClass={0}, valueClass={1}, entries={3}", keyClass, valueClass, entries != null ? ((Object)entries).toString() : "none"));
            }
            return new ManagedBeanInfo.MapEntry(keyClass, valueClass, entries);
        }
        return null;
    }

    private ManagedBeanInfo.ManagedProperty buildManagedProperty(Node managedProperty) {
        if (managedProperty != null) {
            String propertyName = null;
            String propertyClass = null;
            String value = null;
            ManagedBeanInfo.MapEntry mapEntry = null;
            ManagedBeanInfo.ListEntry listEntry = null;
            NodeList children = managedProperty.getChildNodes();
            int size = children.getLength();
            for (int i = 0; i < size; ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 1) continue;
                if (MG_PROPERTY_NAME.equals(child.getLocalName())) {
                    propertyName = this.getNodeText(child);
                    continue;
                }
                if (MG_PROPERTY_TYPE.equals(child.getLocalName())) {
                    propertyClass = this.getNodeText(child);
                    continue;
                }
                if (VALUE.equals(child.getLocalName())) {
                    value = this.getNodeText(child);
                    continue;
                }
                if (NULL_VALUE.equals(child.getLocalName())) {
                    value = "null_value";
                    continue;
                }
                if (LIST_ENTRIES.equals(child.getLocalName())) {
                    listEntry = this.buildListEntry(child);
                    continue;
                }
                if (!MAP_ENTRIES.equals(child.getLocalName())) continue;
                mapEntry = this.buildMapEntry(child);
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Adding ManagedProperty propertyName={0}, propertyClass={1}, propertyValue={2}, hasMapEntry={3}, hasListEntry={4}", propertyName, propertyClass != null ? propertyClass : "inferred", value, mapEntry != null, listEntry != null));
            }
            return new ManagedBeanInfo.ManagedProperty(propertyName, propertyClass, value, mapEntry, listEntry);
        }
        return null;
    }

    private boolean isEager(Node managedBean, String beanName, String scope) {
        NamedNodeMap attributes = managedBean.getAttributes();
        Node eagerNode = attributes.getNamedItem(EAGER_ATTRIBUTE);
        boolean eager = false;
        if (eagerNode != null && (eager = Boolean.valueOf(this.getNodeText(eagerNode)).booleanValue()) && (scope == null || !ELUtils.Scope.APPLICATION.toString().equals(scope))) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "jsf.configuration.illegal.eager.bean", new Object[]{beanName, scope});
            }
            eager = false;
        }
        return eager;
    }
}

